/*
 * Decompiled with CFR 0.152.
 */
package won.node.camel.processor.socket.groupSocket;

import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import org.apache.camel.Exchange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import won.node.camel.processor.AbstractCamelProcessor;
import won.node.camel.processor.annotation.SocketMessageProcessor;
import won.node.camel.service.WonCamelHelper;
import won.protocol.message.WonMessage;
import won.protocol.message.builder.ConnectionMessageBuilder;
import won.protocol.message.builder.WonMessageBuilder;
import won.protocol.model.Connection;
import won.protocol.model.ConnectionState;
import won.protocol.repository.ConnectionRepository;
import won.protocol.util.WonRdfUtils;

@Component
@SocketMessageProcessor(socketType="https://w3id.org/won/ext/group#GroupSocket", direction="https://w3id.org/won/message#FromExternal", messageType="https://w3id.org/won/message#ConnectionMessage")
public class SendMessageFromNodeGroupSocketImpl
extends AbstractCamelProcessor {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Autowired
    private ConnectionRepository connectionRepository;

    public void process(Exchange exchange) throws Exception {
        WonMessage wonMessage = (WonMessage)exchange.getIn().getHeader("won.message");
        WonCamelHelper.suppressMessageToOwner(exchange);
        URI parent = WonCamelHelper.getParentURIRequired(exchange);
        WonMessage headAndForwarded = wonMessage.getHeadAndForwarded(true);
        for (WonMessage checkMsg : headAndForwarded.getAllMessages()) {
            for (URI forwarded : checkMsg.getForwardedMessageURIs()) {
                if (!this.messageEventRepository.findOneByMessageURIAndParentURI(forwarded, parent).isPresent()) continue;
                if (logger.isDebugEnabled()) {
                    URI groupUri = wonMessage.getRecipientAtomURI();
                    logger.debug("suppressing message {} as its innermost message is {} which has already been processed by group {}", new Object[]{wonMessage.getMessageURI(), forwarded, groupUri});
                }
                return;
            }
        }
        Optional conOfIncomingMessage = this.connectionRepository.findOneBySocketURIAndTargetSocketURI(wonMessage.getRecipientSocketURIRequired(), wonMessage.getSenderSocketURIRequired());
        List consInGroup = this.connectionRepository.findBySocketURIAndState(((Connection)conOfIncomingMessage.get()).getSocketURI(), ConnectionState.CONNECTED);
        if (consInGroup == null || consInGroup.size() < 2) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("processing message {} received from atom {} in group {} - preparing to send it to {} group members (text message: '{}'}", new Object[]{wonMessage.getMessageURI(), wonMessage.getSenderAtomURI(), wonMessage.getRecipientAtomURI(), consInGroup.size() - 1, WonRdfUtils.MessageUtils.getTextMessage((WonMessage)wonMessage)});
        }
        for (Connection conToSendTo : consInGroup) {
            try {
                if (conToSendTo.equals(conOfIncomingMessage.get())) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug("forwarding message {} received from atom {} in group {} to group member {}", new Object[]{wonMessage.getMessageURI(), wonMessage.getSenderAtomURI(), wonMessage.getRecipientAtomURI(), conToSendTo.getTargetAtomURI()});
                }
                WonMessage newWonMessage = ((ConnectionMessageBuilder)((ConnectionMessageBuilder)WonMessageBuilder.connectionMessage().direction().fromSystem()).forward(headAndForwarded).sockets().sender(conToSendTo.getSocketURI()).recipient(conToSendTo.getTargetSocketURI())).build();
                this.camelWonMessageService.sendSystemMessage(newWonMessage);
            }
            catch (Exception e) {
                logger.warn("caught Exception:", (Throwable)e);
            }
        }
    }
}

