/*
 * Decompiled with CFR 0.152.
 */
package won.node.camel.processor.socket.reviewSocket;

import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import won.node.camel.processor.AbstractCamelProcessor;
import won.node.camel.processor.annotation.SocketMessageProcessor;
import won.protocol.message.WonMessage;
import won.protocol.model.Atom;
import won.protocol.model.Connection;
import won.protocol.util.WonRdfUtils;
import won.protocol.vocabulary.SCHEMA;
import won.protocol.vocabulary.WXREVIEW;

@Component
@SocketMessageProcessor(socketType="https://w3id.org/won/ext/review#ReviewSocket", direction="https://w3id.org/won/message#FromExternal", messageType="https://w3id.org/won/message#ConnectMessage")
public class ConnectFromNodeReviewSocketImpl
extends AbstractCamelProcessor {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void process(Exchange exchange) {
        Message message = exchange.getIn();
        WonMessage wonMessage = (WonMessage)message.getHeader("won.message");
        Optional con = this.connectionRepository.findOneBySocketURIAndTargetSocketURI(wonMessage.getRecipientSocketURIRequired(), wonMessage.getSenderSocketURIRequired());
        try {
            Map reviewData = WonRdfUtils.MessageUtils.getReviewContent((WonMessage)wonMessage);
            if (reviewData != null) {
                this.addReviewToAtom(reviewData, ((Connection)con.get()).getConnectionURI());
            } else {
                logger.debug("No review data found in message: {}", (Object)wonMessage);
            }
        }
        catch (IllegalArgumentException e) {
            logger.debug("{}: for {}", (Object)e, (Object)wonMessage);
        }
    }

    private void addReviewToAtom(Map<Property, String> reviewData, URI connectionUri) throws IllegalArgumentException {
        String aboutAtomURI = reviewData.get(SCHEMA.ABOUT);
        Double rating = Double.parseDouble(reviewData.get(SCHEMA.RATING_VALUE)) > 0.0 ? Double.parseDouble(reviewData.get(SCHEMA.RATING_VALUE)) : 0.0;
        Atom aboutAtom = this.atomService.getAtomRequired(URI.create(aboutAtomURI));
        Dataset atomDataset = aboutAtom.getDatatsetHolder().getDataset();
        Model derivationModel = atomDataset.getNamedModel(aboutAtom.getAtomURI() + "#derivedData");
        Resource aboutAtomResource = derivationModel.getResource(aboutAtomURI);
        Resource conRes = derivationModel.getResource(connectionUri.toString());
        Statement reviewdConnectionsProperty = derivationModel.getProperty(aboutAtomResource, WXREVIEW.reviewedConnection);
        if (reviewdConnectionsProperty == null) {
            derivationModel.add(aboutAtomResource, WXREVIEW.reviewedConnection, (RDFNode)conRes);
            reviewdConnectionsProperty = derivationModel.getProperty(aboutAtomResource, WXREVIEW.reviewedConnection);
        } else {
            Property ratedConnections = derivationModel.getProperty(WXREVIEW.reviewedConnection.toString());
            if (derivationModel.contains(aboutAtomResource, ratedConnections, (RDFNode)conRes)) {
                logger.debug("Connection already reviewed {}", (Object)connectionUri.toString());
                throw new IllegalArgumentException("Connection already reviewed");
            }
            derivationModel.add(aboutAtomResource, ratedConnections, (RDFNode)conRes);
        }
        Statement aggregateRatingProperty = derivationModel.getProperty(aboutAtomResource, SCHEMA.AGGREGATE_RATING);
        if (aggregateRatingProperty == null) {
            derivationModel.addLiteral(aboutAtomResource, SCHEMA.AGGREGATE_RATING, (Object)rating);
            aggregateRatingProperty = derivationModel.getProperty(aboutAtomResource, SCHEMA.AGGREGATE_RATING);
        }
        int ratingCount = 0;
        Statement reviewCountProperty = derivationModel.getProperty(aboutAtomResource, SCHEMA.REVIEW_COUNT);
        if (reviewCountProperty != null) {
            ratingCount = reviewCountProperty.getInt();
        } else {
            derivationModel.addLiteral(aboutAtomResource, SCHEMA.REVIEW_COUNT, 0.0);
            reviewCountProperty = derivationModel.getProperty(aboutAtomResource, SCHEMA.REVIEW_COUNT);
        }
        Double aggregateRating = aggregateRatingProperty.getDouble();
        Double ratingSum = 0.0;
        ratingSum = ratingCount < 1 ? aggregateRating : Double.valueOf(aggregateRating * (double)ratingCount + rating);
        Double newAggregateRating = ratingSum / (double)(++ratingCount);
        aggregateRatingProperty.changeLiteralObject(newAggregateRating.doubleValue());
        reviewCountProperty.changeLiteralObject(ratingCount);
        aboutAtom.getDatatsetHolder().setDataset(atomDataset);
        this.atomRepository.save((Object)aboutAtom);
    }
}

