/*
 * Decompiled with CFR 0.152.
 */
package won.node.camel.route.fixed;

import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.PredicateBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.TransactedDefinition;
import org.apache.jena.query.Dataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import won.node.camel.predicate.IsReactionAllowedPredicate;
import won.node.camel.predicate.ShouldCallSocketImplForMessagePredicate;
import won.node.camel.service.WonCamelHelper;
import won.protocol.message.WonMessage;
import won.protocol.message.WonMessageType;
import won.protocol.util.RdfUtils;
import won.protocol.vocabulary.WONMSG;

public class WonMessageRoutes
extends RouteBuilder {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Predicate causesOutgoingMessage = new CausesOutgoingMessage();
    private Predicate isAllowedToReact = new IsReactionAllowedPredicate();
    private Predicate shouldCallSocketImplForMessage = new ShouldCallSocketImplForMessagePredicate();
    private Predicate shouldRespond = new Predicate(){

        public boolean matches(Exchange exchange) {
            WonMessage wonMessage = (WonMessage)exchange.getIn().getHeader("won.message");
            WonMessageType messageType = wonMessage.getMessageType();
            return !messageType.isResponseMessage();
        }
    };
    private Predicate shouldSendToOwner = new Predicate(){

        public boolean matches(Exchange exchange) {
            Boolean suppress = (Boolean)exchange.getIn().getHeader("won.suppressMessageToOwner");
            return suppress == null || suppress != true;
        }
    };
    private Predicate shouldSendToExternal = new Predicate(){

        public boolean matches(Exchange exchange) {
            Boolean suppress = (Boolean)exchange.getIn().getHeader("won.suppressMessageToNode");
            return suppress == null || suppress != true;
        }
    };
    private Predicate responseIsPresent = new Predicate(){

        public boolean matches(Exchange exchange) {
            WonMessage response = (WonMessage)exchange.getIn().getHeader("won.responseMessage");
            return response != null && response.getMessageTypeRequired().isResponseMessage();
        }
    };
    private Processor responseIntoMessageToSendHeader = new Processor(){

        public void process(Exchange exchange) throws Exception {
            WonCamelHelper.putMessageToSend(exchange, WonCamelHelper.getResponseRequired(exchange));
        }
    };
    private Processor messageIntoMessageToSendHeader = new Processor(){

        public void process(Exchange exchange) throws Exception {
            WonCamelHelper.putMessageToSend(exchange, WonCamelHelper.getMessageRequired(exchange));
        }
    };
    private Processor messageAndResponseIntoToSendHeader = new Processor(){

        public void process(Exchange exchange) throws Exception {
            WonMessage msg = WonCamelHelper.getMessageRequired(exchange);
            Optional<WonMessage> resp = WonCamelHelper.getResponse(exchange);
            if (resp.isPresent()) {
                Dataset ds = msg.getCompleteDataset();
                RdfUtils.addDatasetToDataset((Dataset)ds, (Dataset)resp.get().getCompleteDataset());
                msg = WonMessage.of((Dataset)ds);
            }
            WonCamelHelper.putMessageToSend(exchange, msg);
        }
    };

    public void configure() throws Exception {
        ExecutorService executorSvc = Executors.newCachedThreadPool();
        ((OnExceptionDefinition)((OnExceptionDefinition)this.from("direct:onExceptionFailResponder").routeId("direct:onExceptionFailResponder").onException(Exception.class).log(LoggingLevel.WARN, this.simple("failure during direct:onExceptionFailResponder, ignoring. Exception message: ${exception.message}, Stacktrace: ${exception.stacktrace}").getText())).handled(true).stop()).end().to("bean:failResponder").end();
        ((OnExceptionDefinition)this.from("direct:checkMessage").routeId("direct:checkMessage").onException(Exception.class).handled(true).to("direct:onExceptionFailResponder")).end().to("bean:wellformednessChecker").to("bean:uriConsistencyChecker").to("bean:parentFinder").to("bean:uriInUseChecker").to("bean:signatureChecker");
        ((RouteDefinition)this.from("activemq:queue:OwnerProtocol.in?concurrentConsumers=5").routeId("activemq:queue:OwnerProtocol.in").setHeader("won.direction", (Expression)this.constant(URI.create("https://w3id.org/won/message#FromOwner")))).to("seda:msgFromOwner");
        ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("seda:msgFromOwner?concurrentConsumers=10").routeId("seda:msgFromOwner").to("direct:msgFromOwner_process")).to("direct:msgFromOwner_react")).to("direct:msgFromOwner_forwardToNode")).to("direct:msgFromOwner_respondToOwner");
        ((ChoiceDefinition)((ExpressionNode)((TransactedDefinition)((TransactedDefinition)((TransactedDefinition)((TransactedDefinition)((OnExceptionDefinition)this.from("direct:msgFromOwner_process").routeId("direct:msgFromOwner_process").onException(Exception.class).maximumRedeliveries(3).redeliveryDelay(0L).handled(true).to("direct:onExceptionFailResponder")).end().transacted("PROPAGATION_REQUIRES_NEW").to("bean:wonMessageIntoCamelProcessor")).to("direct:checkMessage")).to("bean:parentLocker")).to("bean:connectionStateChangeBuilder")).routingSlip((Expression)this.method("fixedMessageProcessorSlip")).to("bean:dataDeriver")).choice().when(this.shouldCallSocketImplForMessage).to("bean:socketTypeExtractor")).routingSlip((Expression)this.method("socketTypeSlip")).endChoice().end().to("bean:persister").to("bean:successResponder").to("bean:responsePersister");
        ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:msgFromOwner_respondToOwner").routeId("direct:msgFromOwner_respondToOwner").choice().when(this.shouldSendToOwner).to("bean:responseRoutingInfoExtractor")).bean((Object)this.messageAndResponseIntoToSendHeader)).to("direct:sendToOwner")).end().to("bean:atomDeleter");
        ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:msgFromOwner_forwardToNode").routeId("direct:msgFromOwner_forwardToNode").choice().when(PredicateBuilder.and((Predicate)this.causesOutgoingMessage, (Predicate)this.shouldSendToExternal)).to("bean:routingInfoExtractor")).bean((Object)this.messageAndResponseIntoToSendHeader)).to("direct:sendToNode")).endChoice().end();
        ((ChoiceDefinition)this.from("direct:msgFromOwner_react").routeId("direct:msgFromOwner_react").transacted("PROPAGATION_REQUIRES_NEW").choice().when(this.isAllowedToReact).to("direct:reactToMessage")).endChoice().end();
        ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("seda:SystemMessageIn?concurrentConsumers=5").routeId("seda:SystemMessageIn").to("bean:wonMessageIntoCamelProcessor")).setHeader("won.direction", (Expression)new URIConstant(URI.create("https://w3id.org/won/message#FromSystem")))).to("bean:signatureToMessageAdder")).to("seda:msgFromOwner");
        ((RouteDefinition)this.from("direct:reactToMessage").to("bean:parentLocker")).routeId("direct:reactToMessage").routingSlip((Expression)this.method("fixedMessageReactionProcessorSlip"));
        ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("activemq:queue:AtomProtocol.in?concurrentConsumers=5").routeId("activemq:queue:AtomProtocol.in").choice().when(this.header("methodName").isEqualTo((Object)"register")).to("bean:ownerManagementService?method=registerOwnerApplication")).when(this.header("methodName").isEqualTo((Object)"getEndpoints")).to("bean:queueManagementService?method=getEndpointsForOwnerApplication")).otherwise().to("bean:wonMessageIntoCamelProcessor")).to("seda:msgFromExternal")).endChoice().end();
        ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("seda:msgFromExternal?concurrentConsumers=10").routeId("seda:msgFromExternal").to("direct:msgFromExternal_process")).to("direct:msgFromExternal_react")).to("direct:msgFromExternal_respondToNode")).to("direct:msgFromExternal_forwardToOwner")).end();
        ((ChoiceDefinition)((ChoiceDefinition)((ExpressionNode)((ExpressionNode)((TransactedDefinition)((TransactedDefinition)((TransactedDefinition)((TransactedDefinition)((OnExceptionDefinition)this.from("direct:msgFromExternal_process").routeId("direct:msgFromExternal_process").onException(Exception.class).maximumRedeliveries(0).redeliveryDelay(0L).handled(true).to("direct:onExceptionFailResponder")).end().transacted("PROPAGATION_REQUIRES_NEW").setHeader("won.direction", (Expression)new URIConstant(URI.create(WONMSG.FromExternal.getURI())))).to("direct:checkMessage")).to("bean:parentLocker")).to("bean:connectionStateChangeBuilder")).routingSlip((Expression)this.method("fixedMessageProcessorSlip")).to("bean:dataDeriver")).to("bean:socketTypeExtractor")).choice().when(this.shouldCallSocketImplForMessage).routingSlip((Expression)this.method("socketTypeSlip")).endChoice().end().to("bean:persister").choice().when(this.shouldRespond).to("bean:successResponder")).to("bean:responsePersister")).endChoice().end();
        ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:msgFromExternal_respondToNode").routeId("direct:msgFromExternal_respondToNode").choice().when(this.responseIsPresent).to("bean:responseRoutingInfoExtractor")).bean((Object)this.responseIntoMessageToSendHeader)).to("direct:sendToNode")).endChoice().end();
        ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:msgFromExternal_forwardToOwner").routeId("direct:msgFromExternal_forwardToOwner").choice().when(this.shouldSendToOwner).to("bean:routingInfoExtractor")).bean((Object)this.messageAndResponseIntoToSendHeader)).to("direct:sendToOwner")).endChoice().end();
        ((ChoiceDefinition)this.from("direct:msgFromExternal_react").routeId("direct:msgFromExternal_react").transacted("PROPAGATION_REQUIRES_NEW").choice().when(this.isAllowedToReact).to("direct:reactToMessage")).endChoice().end();
        ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((TransactedDefinition)((TransactedDefinition)((TransactedDefinition)((OnExceptionDefinition)this.from("activemq:queue:MatcherProtocol.in?concurrentConsumers=5").onException(Exception.class).log(LoggingLevel.WARN, this.simple("failure during direct:onExceptionFailResponder, ignoring. Exception message: ${exception.message}, Stacktrace: ${exception.stacktrace}").getText())).handled(true).end().transacted("PROPAGATION_REQUIRES_NEW").routeId("activemq:queue:MatcherProtocol.in")).to("bean:wonMessageIntoCamelProcessor")).setHeader("won.direction", (Expression)this.constant(URI.create("https://w3id.org/won/message#FromExternal")))).choice().when(PredicateBuilder.or((Predicate)this.header("won.messageType").isEqualTo((Object)URI.create("https://w3id.org/won/message#AtomHintMessage")), (Predicate)this.header("won.messageType").isEqualTo((Object)URI.create("https://w3id.org/won/message#SocketHintMessage")))).to("bean:wellformednessChecker")).to("bean:uriConsistencyChecker")).to("bean:parentFinder")).to("bean:uriInUseChecker")).to("bean:parentLocker")).choice().when(this.header("won.messageType").isEqualTo((Object)URI.create("https://w3id.org/won/message#AtomHintMessage"))).to("bean:atomHintMessageProcessor?method=process")).when(this.header("won.messageType").isEqualTo((Object)URI.create("https://w3id.org/won/message#SocketHintMessage"))).to("bean:socketHintMessageProcessor?method=process")).endChoice().choice().when(PredicateBuilder.not((Predicate)this.header("won.ignoreHint"))).to("bean:persister")).to("bean:routingInfoExtractor")).bean((Object)this.messageIntoMessageToSendHeader)).to("direct:sendToOwner")).otherwise().log(LoggingLevel.DEBUG, "suppressing sending of message to owner because the header 'won.ignoreHint' is 'true'")).endChoice().endChoice().end();
        this.from("direct:sendToOwner").routeId("direct:sendToOwner").to("bean:toOwnerSender");
        this.from("direct:sendToOwnerApplications").routeId("direct:sendToOwnerApplications").recipientList((Expression)this.header("won.ownerApplicationIds"));
        this.from("direct:sendToNode").routeId("direct:sendToNode").to("bean:toNodeSender");
        this.from("seda:MatcherProtocolOut?concurrentConsumers=5").routeId("seda:MatcherProtocolOut").to("activemq:topic:MatcherProtocol.Out.Atom");
    }

    public static class CausesOutgoingMessage
    implements Predicate {
        public boolean matches(Exchange exchange) {
            WonMessage msg = (WonMessage)exchange.getIn().getHeader("won.message");
            return msg != null && msg.getMessageTypeRequired().causesOutgoingMessage();
        }
    }

    private class URIConstant
    implements Expression {
        private URI uri;

        public URIConstant(URI uri) {
            this.uri = uri;
        }

        public <T> T evaluate(Exchange exchange, Class<T> type) {
            return type.cast(this.uri);
        }
    }
}

