/*
 * Decompiled with CFR 0.152.
 */
package won.node.camel.service;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import won.node.service.persistence.AtomService;
import won.protocol.jms.MessagingService;
import won.protocol.message.WonMessage;

@Component
public class CamelWonMessageService {
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Autowired
    AtomService atomService;
    @Autowired
    MessagingService messagingService;

    public void sendSystemMessage(WonMessage message) {
        HashMap<String, WonMessage> headerMap = new HashMap<String, WonMessage>();
        headerMap.put("won.message", message);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("sending system message: {}", (Object)message.toStringForDebug(true));
        }
        this.messagingService.sendInOnlyMessage(null, headerMap, null, "seda:SystemMessageIn");
    }
}

