/*
 * Decompiled with CFR 0.152.
 */
package won.node.camel.service;

import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.camel.Exchange;
import org.apache.jena.query.Dataset;
import org.apache.jena.riot.Lang;
import won.node.service.persistence.ConnectionService;
import won.protocol.message.WonMessage;
import won.protocol.message.WonMessageDirection;
import won.protocol.message.WonMessageEncoder;
import won.protocol.message.WonMessageType;
import won.protocol.message.processor.camel.WonCamelConstants;
import won.protocol.model.Connection;
import won.protocol.util.RdfUtils;

public class WonCamelHelper {
    public static void putMessage(Exchange exchange, WonMessage message) {
        Objects.requireNonNull(exchange);
        Objects.requireNonNull(message);
        exchange.getIn().setHeader("won.message", (Object)message);
    }

    public static Optional<WonMessage> getMessage(Exchange exchange) {
        Objects.requireNonNull(exchange);
        return Optional.ofNullable((WonMessage)exchange.getIn().getHeader("won.message"));
    }

    public static WonMessage getMessageRequired(Exchange exchange) {
        Objects.requireNonNull(exchange);
        return WonCamelHelper.getMessage(exchange).orElseThrow(WonCamelHelper.expectedHeader("won.message"));
    }

    public static void putResponse(Exchange exchange, WonMessage response) {
        Objects.requireNonNull(exchange);
        Objects.requireNonNull(response);
        exchange.getIn().setHeader("won.responseMessage", (Object)response);
    }

    public static Optional<WonMessage> getResponse(Exchange exchange) {
        Objects.requireNonNull(exchange);
        return Optional.ofNullable((WonMessage)exchange.getIn().getHeader("won.responseMessage"));
    }

    public static WonMessage getResponseRequired(Exchange exchange) {
        Objects.requireNonNull(exchange);
        return WonCamelHelper.getResponse(exchange).orElseThrow(WonCamelHelper.expectedHeader("won.responseMessage"));
    }

    public static void removeResponse(Exchange exchange) {
        Objects.requireNonNull(exchange);
        exchange.getIn().removeHeader("won.responseMessage");
    }

    public static void putMessageToSend(Exchange exchange, WonMessage response) {
        Objects.requireNonNull(exchange);
        Objects.requireNonNull(response);
        exchange.getIn().setHeader("won.messageToSend", (Object)response);
    }

    public static Optional<WonMessage> getMessageToSend(Exchange exchange) {
        Objects.requireNonNull(exchange);
        return Optional.ofNullable((WonMessage)exchange.getIn().getHeader("won.messageToSend"));
    }

    public static WonMessage getMessageToSendRequired(Exchange exchange) {
        Objects.requireNonNull(exchange);
        return WonCamelHelper.getMessageToSend(exchange).orElseThrow(WonCamelHelper.expectedHeader("won.messageToSend"));
    }

    public static void removeMessageToSend(Exchange exchange) {
        Objects.requireNonNull(exchange);
        exchange.getIn().removeHeader("won.messageToSend");
    }

    public static Optional<WonMessageDirection> getDirection(Exchange exchange) {
        Objects.requireNonNull(exchange);
        URI uri = (URI)exchange.getIn().getHeader("won.direction");
        if (uri == null) {
            return Optional.empty();
        }
        WonMessageDirection direction = WonMessageDirection.getWonMessageDirection((URI)uri);
        return Optional.ofNullable(direction);
    }

    public static WonMessageDirection getDirectionRequired(Exchange exchange) {
        Objects.requireNonNull(exchange);
        return WonCamelHelper.getDirection(exchange).orElseThrow(WonCamelHelper.expectedHeader("won.direction"));
    }

    public static void putDirection(Exchange exchange, WonMessageDirection direction) {
        Objects.requireNonNull(direction);
        Objects.requireNonNull(exchange);
        exchange.getIn().setHeader("won.direction", (Object)URI.create(direction.getResource().toString()));
    }

    public static Optional<WonMessageType> getMessageType(Exchange exchange) {
        Objects.requireNonNull(exchange);
        URI uri = (URI)exchange.getIn().getHeader("won.messageType");
        if (uri == null) {
            return Optional.empty();
        }
        WonMessageType type = WonMessageType.getWonMessageType((URI)uri);
        return Optional.ofNullable(type);
    }

    public static WonMessageType getMessageTypeRequired(Exchange exchange) {
        Objects.requireNonNull(exchange);
        return WonCamelHelper.getMessageType(exchange).orElseThrow(WonCamelHelper.expectedHeader("won.messageType"));
    }

    public static void putMessageType(Exchange exchange, WonMessageType type) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(exchange);
        exchange.getIn().setHeader("won.messageType", (Object)URI.create(type.getResource().toString()));
    }

    public static void putConnectionURI(Exchange exchange, URI connectionURI) {
        Objects.requireNonNull(connectionURI);
        Objects.requireNonNull(exchange);
        exchange.getIn().setHeader("won.connectionURI", (Object)connectionURI);
    }

    public static Optional<URI> getConnectionURI(Exchange exchange) {
        Objects.requireNonNull(exchange);
        return Optional.ofNullable((URI)exchange.getIn().getHeader("won.connectionURI"));
    }

    public static URI getConnectionURIRequired(Exchange exchange) {
        Objects.requireNonNull(exchange);
        return WonCamelHelper.getConnectionURI(exchange).orElseThrow(WonCamelHelper.expectedHeader("won.connectionURI"));
    }

    public static void putSocketTypeURI(Exchange exchange, URI socketTypeURI) {
        Objects.requireNonNull(socketTypeURI);
        Objects.requireNonNull(exchange);
        exchange.getIn().setHeader("won.socketType", (Object)socketTypeURI);
    }

    public static Optional<URI> getSocketTypeURI(Exchange exchange) {
        Objects.requireNonNull(exchange);
        return Optional.ofNullable((URI)exchange.getIn().getHeader("won.socketType"));
    }

    public static URI getSocketTypeURIRequired(Exchange exchange) {
        Objects.requireNonNull(exchange);
        return WonCamelHelper.getSocketTypeURI(exchange).orElseThrow(WonCamelHelper.expectedHeader("won.socketType"));
    }

    public static void putSenderNodeURI(Exchange exchange, URI message) {
        Objects.requireNonNull(exchange);
        Objects.requireNonNull(message);
        exchange.getIn().setHeader("won.senderNodeUri", (Object)message);
    }

    public static Optional<URI> getSenderNodeURI(Exchange exchange) {
        Objects.requireNonNull(exchange);
        return Optional.ofNullable((URI)exchange.getIn().getHeader("won.senderNodeUri"));
    }

    public static URI getSenderNodeURIRequired(Exchange exchange) {
        Objects.requireNonNull(exchange);
        return WonCamelHelper.getSenderNodeURI(exchange).orElseThrow(WonCamelHelper.expectedHeader("won.senderNodeUri"));
    }

    public static void putRecipientNodeURI(Exchange exchange, URI message) {
        Objects.requireNonNull(exchange);
        Objects.requireNonNull(message);
        exchange.getIn().setHeader("won.recipientNodeUri", (Object)message);
    }

    public static Optional<URI> getRecipientNodeURI(Exchange exchange) {
        Objects.requireNonNull(exchange);
        return Optional.ofNullable((URI)exchange.getIn().getHeader("won.recipientNodeUri"));
    }

    public static URI getRecipientNodeURIRequired(Exchange exchange) {
        Objects.requireNonNull(exchange);
        return WonCamelHelper.getRecipientNodeURI(exchange).orElseThrow(WonCamelHelper.expectedHeader("won.recipientNodeUri"));
    }

    public static void putRecipientAtomURI(Exchange exchange, URI message) {
        Objects.requireNonNull(exchange);
        Objects.requireNonNull(message);
        exchange.getIn().setHeader("won.recipientAtomUri", (Object)message);
    }

    public static Optional<URI> getRecipientAtomURI(Exchange exchange) {
        Objects.requireNonNull(exchange);
        return Optional.ofNullable((URI)exchange.getIn().getHeader("won.recipientAtomUri"));
    }

    public static URI getRecipientAtomURIRequired(Exchange exchange) {
        Objects.requireNonNull(exchange);
        return WonCamelHelper.getRecipientAtomURI(exchange).orElseThrow(WonCamelHelper.expectedHeader("won.recipientAtomUri"));
    }

    public static void suppressMessageToNode(Exchange exchange) {
        Objects.requireNonNull(exchange);
        exchange.getIn().setHeader("won.suppressMessageToNode", (Object)true);
    }

    public static void suppressMessageToOwner(Exchange exchange) {
        Objects.requireNonNull(exchange);
        exchange.getIn().setHeader("won.suppressMessageToOwner", (Object)true);
    }

    public static void putParentURI(Exchange exchange, URI parentURI) {
        Objects.requireNonNull(parentURI);
        Objects.requireNonNull(exchange);
        exchange.getIn().setHeader("won.ParentUri", (Object)parentURI);
    }

    public static Optional<URI> getParentURI(Exchange exchange) {
        Objects.requireNonNull(exchange);
        return Optional.ofNullable((URI)exchange.getIn().getHeader("won.ParentUri"));
    }

    public static URI getParentURIRequired(Exchange exchange) {
        Objects.requireNonNull(exchange);
        return WonCamelHelper.getParentURI(exchange).orElseThrow(WonCamelHelper.expectedHeader("won.ParentUri"));
    }

    public static void removeParentURI(Exchange exchange) {
        Objects.requireNonNull(exchange);
        exchange.getIn().removeHeader("won.ParentUri");
    }

    public static Optional<String> getOwnerApplicationId(Exchange exchange) {
        Objects.requireNonNull(exchange);
        return Optional.ofNullable((String)exchange.getIn().getHeader("won.ownerApplicationId"));
    }

    public static String getOwnerApplicationIdRequired(Exchange exchange) {
        Objects.requireNonNull(exchange);
        return WonCamelHelper.getOwnerApplicationId(exchange).orElseThrow(WonCamelHelper.expectedHeader("won.ownerApplicationId"));
    }

    public static Optional<WonMessage> getMessageFromBody(Exchange exchange) {
        Objects.requireNonNull(exchange);
        String datasetAsString = (String)exchange.getIn().getBody();
        if (datasetAsString == null || datasetAsString.trim().length() == 0) {
            return Optional.empty();
        }
        return Optional.of(WonMessage.of((Dataset)RdfUtils.readDatasetFromString((String)datasetAsString, (Lang)WonCamelConstants.RDF_LANGUAGE_FOR_MESSAGE)));
    }

    public static void putMessageIntoBody(Exchange exchange, WonMessage message) {
        Objects.requireNonNull(exchange);
        Objects.requireNonNull(message);
        exchange.getIn().setBody((Object)WonMessageEncoder.encode((WonMessage)message, (Lang)WonCamelConstants.RDF_LANGUAGE_FOR_MESSAGE));
    }

    public static WonMessage getMessageFromBodyRequired(Exchange exchange) {
        Objects.requireNonNull(exchange);
        return WonCamelHelper.getMessageFromBody(exchange).orElseThrow(() -> new IllegalStateException("Expected to find a serialized WonMessage in the body of the camel exchange's In message"));
    }

    public static void stopExchange(Exchange exchange) {
        exchange.setProperty("CamelRouteStop", (Object)Boolean.TRUE);
    }

    public static Optional<Connection> getConnection(Exchange exchange, ConnectionService connectionService) {
        Objects.requireNonNull(exchange);
        Objects.requireNonNull(connectionService);
        Connection con = (Connection)exchange.getIn().getHeader("won.connection");
        if (con != null) {
            return Optional.of(con);
        }
        Optional<WonMessage> msg = WonCamelHelper.getMessage(exchange);
        Optional<WonMessageDirection> direction = WonCamelHelper.getDirection(exchange);
        if (msg.isPresent() && direction.isPresent()) {
            return connectionService.getConnectionForMessage(msg.get(), direction.get());
        }
        return Optional.empty();
    }

    public static Connection getConnectionRequired(Exchange exchange, ConnectionService connectionService) {
        Objects.requireNonNull(exchange);
        Objects.requireNonNull(connectionService);
        Connection con = (Connection)exchange.getIn().getHeader("won.connection");
        if (con != null) {
            return con;
        }
        return connectionService.getConnectionForMessageRequired(WonCamelHelper.getMessageRequired(exchange), WonCamelHelper.getDirectionRequired(exchange));
    }

    private static Supplier<RuntimeException> expectedHeader(String header) {
        Objects.requireNonNull(header);
        return () -> new IllegalStateException("Expected to find a '" + header + "' header in camel exchange");
    }
}

