/*
 * Decompiled with CFR 0.152.
 */
package won.node.maintenance;

import java.lang.invoke.MethodHandles;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.PeriodicTrigger;
import org.springframework.stereotype.Component;
import won.node.service.nodebehaviour.AtomManagementService;
import won.protocol.repository.AtomRepository;

@Component
public class AtomInactivityChecker
implements InitializingBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Trigger trigger;
    private TaskScheduler taskScheduler;
    private int inactivityCheckInterval = -1;
    private int warnTimeout = -1;
    private int deactivateTimeout = -1;
    private int deactivateTimeoutDespiteEstablishedConnections = -1;
    private InactivityCheckTask inactivityCheckTask = null;
    @Autowired
    private AtomRepository atomRepository;
    @Autowired
    private AtomManagementService atomManagementService;

    public void afterPropertiesSet() throws Exception {
        if (this.taskScheduler == null) {
            throw new IllegalStateException("taskScheduler must be set");
        }
        if (this.inactivityCheckInterval <= 0) {
            return;
        }
        PeriodicTrigger periodicTrigger = new PeriodicTrigger((long)this.inactivityCheckInterval, TimeUnit.SECONDS);
        periodicTrigger.setInitialDelay((long)this.inactivityCheckInterval);
        this.trigger = periodicTrigger;
        this.inactivityCheckTask = new InactivityCheckTask();
        this.taskScheduler.schedule((Runnable)this.inactivityCheckTask, this.trigger);
        if (logger.isDebugEnabled()) {
            logger.debug("setting up inactivity checker to check inactivity every {} seconds, warn after {} seconds and deactivate after {} seconds", new Object[]{this.inactivityCheckInterval, this.warnTimeout, this.deactivateTimeout});
        }
    }

    public void destroy() throws Exception {
        if (this.inactivityCheckTask != null) {
            this.inactivityCheckTask.cancel();
        }
    }

    public void setInactivityCheckInterval(int inactivityCheckInterval) {
        this.inactivityCheckInterval = inactivityCheckInterval;
    }

    public void setWarnTimeout(int warnTimeout) {
        this.warnTimeout = warnTimeout;
    }

    public void setDeactivateTimeoutDespiteEstablishedConnections(int deactivateTimeoutDespiteEstablishedConnections) {
        this.deactivateTimeoutDespiteEstablishedConnections = deactivateTimeoutDespiteEstablishedConnections;
    }

    public void setDeactivateTimeout(int deactivateTimeout) {
        this.deactivateTimeout = deactivateTimeout;
    }

    public void setTaskScheduler(TaskScheduler taskScheduler) {
        this.taskScheduler = taskScheduler;
    }

    private class InactivityCheckTask
    implements Runnable {
        private AtomicBoolean cancelled = new AtomicBoolean(false);

        private InactivityCheckTask() {
        }

        @Override
        public void run() {
            try {
                Pageable pageable;
                logger.debug("starting inactivity check");
                Date now = new Date();
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(now);
                calendar.add(13, -AtomInactivityChecker.this.warnTimeout);
                Date startWarningThreshold = calendar.getTime();
                calendar.add(13, AtomInactivityChecker.this.inactivityCheckInterval);
                Date stopWarningThreshold = calendar.getTime();
                calendar.setTime(now);
                calendar.add(13, -AtomInactivityChecker.this.deactivateTimeout);
                Date deactivateThreshold = calendar.getTime();
                calendar.setTime(now);
                calendar.add(13, -AtomInactivityChecker.this.deactivateTimeoutDespiteEstablishedConnections);
                Date deactivateThresholdDespiteEstablishedConnections = calendar.getTime();
                PageRequest firstPage = new PageRequest(0, 100);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
                logger.debug("warn start-date: {}, warn end-date: {}, deactivate cut-off date {}", new Object[]{simpleDateFormat.format(startWarningThreshold), simpleDateFormat.format(stopWarningThreshold), simpleDateFormat.format(deactivateThreshold)});
                String warningMessage = "This posting does not have active connections, nor has it seen any activity from your side in the last " + this.getTimeString(AtomInactivityChecker.this.warnTimeout) + ". It will be deactivated if there continues to be no activity for more than " + this.getTimeString(AtomInactivityChecker.this.deactivateTimeout - AtomInactivityChecker.this.warnTimeout) + ". Automatic deactivation is done to clean up abandoned postings. You can reactivate your posting at any time.";
                String deactivateMessage = "This posting is deactivated because it has no active connections, nor has there been any activity from your side in the last " + this.getTimeString(AtomInactivityChecker.this.deactivateTimeout) + ". Automatic deactivation is done to clean up abandoned postings. You can reactivate your posting at any time.";
                String deactivateDespiteEstablishedConnectionsMessage = "This posting is deactivated because there has not been any activity from your side in the last " + this.getTimeString(AtomInactivityChecker.this.deactivateTimeoutDespiteEstablishedConnections) + ". Automatic deactivation is done to clean up abandoned postings. You can reactivate your posting at any time.";
                AtomicInteger warned = new AtomicInteger(0);
                AtomicInteger deactivated = new AtomicInteger(0);
                Slice atomsToWarn = AtomInactivityChecker.this.atomRepository.findAtomsInactiveBetweenAndNotConnected(startWarningThreshold, stopWarningThreshold, (Pageable)firstPage);
                do {
                    if (this.cancelled.get()) {
                        return;
                    }
                    atomsToWarn.forEach(atom -> {
                        try {
                            if (this.cancelled.get()) {
                                return;
                            }
                            warned.incrementAndGet();
                            logger.debug("Sending warning to atom {} ", (Object)atom.getAtomURI());
                            AtomInactivityChecker.this.atomManagementService.sendTextMessageToOwner(atom.getAtomURI(), warningMessage);
                        }
                        catch (Exception e) {
                            logger.warn("Caught and swallowed exception during warning an inactive atom", (Throwable)e);
                        }
                    });
                    if (this.cancelled.get()) {
                        return;
                    }
                    if (atomsToWarn.hasNext()) {
                        Pageable pageable2 = atomsToWarn.nextPageable();
                        atomsToWarn = AtomInactivityChecker.this.atomRepository.findAtomsInactiveBetweenAndNotConnected(startWarningThreshold, stopWarningThreshold, pageable2);
                        continue;
                    }
                    atomsToWarn = null;
                } while (atomsToWarn != null && atomsToWarn.hasContent());
                Slice atomsToDeactivate = AtomInactivityChecker.this.atomRepository.findAtomsInactiveSinceAndNotConnected(deactivateThreshold, (Pageable)firstPage);
                do {
                    if (this.cancelled.get()) {
                        return;
                    }
                    atomsToDeactivate.forEach(atom -> {
                        try {
                            if (this.cancelled.get()) {
                                return;
                            }
                            deactivated.incrementAndGet();
                            logger.debug("Deactivating atom {} ", (Object)atom.getAtomURI());
                            AtomInactivityChecker.this.atomManagementService.deactivateAtom(atom.getAtomURI(), deactivateMessage);
                        }
                        catch (Exception e) {
                            logger.warn("Caught and swallowed exception during deactivating an inactive atom", (Throwable)e);
                        }
                    });
                    if (this.cancelled.get()) {
                        return;
                    }
                    if (atomsToDeactivate.hasNext()) {
                        pageable = atomsToDeactivate.nextPageable();
                        atomsToDeactivate = AtomInactivityChecker.this.atomRepository.findAtomsInactiveSinceAndNotConnected(deactivateThreshold, pageable);
                        continue;
                    }
                    atomsToDeactivate = null;
                } while (atomsToDeactivate != null && atomsToDeactivate.hasContent());
                atomsToDeactivate = AtomInactivityChecker.this.atomRepository.findAtomsInactiveSince(deactivateThresholdDespiteEstablishedConnections, (Pageable)firstPage);
                do {
                    if (this.cancelled.get()) {
                        return;
                    }
                    atomsToDeactivate.forEach(atom -> {
                        try {
                            if (this.cancelled.get()) {
                                return;
                            }
                            deactivated.incrementAndGet();
                            logger.debug("Deactivating atom {} ", (Object)atom.getAtomURI());
                            AtomInactivityChecker.this.atomManagementService.deactivateAtom(atom.getAtomURI(), deactivateDespiteEstablishedConnectionsMessage);
                        }
                        catch (Exception e) {
                            logger.warn("Caught and swallowed exception during deactivating an inactive atom", (Throwable)e);
                        }
                    });
                    if (this.cancelled.get()) {
                        return;
                    }
                    if (atomsToDeactivate.hasNext()) {
                        pageable = atomsToDeactivate.nextPageable();
                        atomsToDeactivate = AtomInactivityChecker.this.atomRepository.findAtomsInactiveSince(deactivateThresholdDespiteEstablishedConnections, pageable);
                        continue;
                    }
                    atomsToDeactivate = null;
                } while (atomsToDeactivate != null && atomsToDeactivate.hasContent());
                logger.info("Inactivity check finished. Sent warning to {} atoms, deactivated {} atoms", (Object)warned.get(), (Object)deactivated.get());
            }
            catch (Throwable t) {
                logger.warn("Caught an error during the inactivity check, which may have aborted the complete procedure, not just an individual check", t);
            }
        }

        public void cancel() {
            this.cancelled.set(true);
        }

        private String getTimeString(int seconds) {
            Duration duration = Duration.ofSeconds(seconds);
            if (seconds <= 0) {
                return "bogus time";
            }
            if (seconds < 60) {
                return this.singularOrPlural(seconds, "second", "seconds");
            }
            if (seconds < 3600) {
                return this.singularOrPlural(duration.toMinutes(), "minute", "minutes");
            }
            if (seconds < 86400) {
                return this.singularOrPlural(duration.toHours(), "hour", "hours");
            }
            return this.singularOrPlural(duration.toDays(), "day", "days");
        }

        private String singularOrPlural(long value, String singular, String plural) {
            return value == 1L ? singular : value + " " + plural;
        }
    }
}

