/*
 * Decompiled with CFR 0.152.
 */
package won.node.protocol.impl;

import java.net.URI;
import java.util.HashMap;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.Lang;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import won.node.protocol.MatcherProtocolMatcherServiceClientSide;
import won.node.service.nodeconfig.URIService;
import won.protocol.jms.MessagingService;
import won.protocol.message.WonMessage;
import won.protocol.message.WonMessageEncoder;

public class MatcherProtocolMatcherClientImplJMSBased
implements MatcherProtocolMatcherServiceClientSide {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MessagingService messagingService;
    @Autowired
    private URIService uriService;

    @Override
    public void matcherRegistered(URI wonNodeURI, WonMessage wonMessage) {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("wonNodeURI", wonNodeURI.toString());
        headerMap.put("protocol", "MatcherProtocol");
        headerMap.put("methodName", "matcherRegistered");
        this.messagingService.sendInOnlyMessage(null, headerMap, (Object)WonMessageEncoder.encode((WonMessage)wonMessage, (Lang)Lang.TRIG), "seda:MatcherProtocolOut");
    }

    @Override
    public void atomCreated(URI atomURI, Model content, WonMessage wonMessage) {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("atomURI", atomURI.toString());
        headerMap.put("methodName", "atomCreated");
        headerMap.put("wonNodeURI", this.uriService.getGeneralURIPrefix() + "/resource");
        this.messagingService.sendInOnlyMessage(null, headerMap, (Object)WonMessageEncoder.encode((WonMessage)wonMessage, (Lang)Lang.TRIG), "seda:MatcherProtocolOut");
    }

    @Override
    public void atomModified(URI atomURI, WonMessage wonMessage) {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("atomURI", atomURI.toString());
        headerMap.put("methodName", "atomModified");
        headerMap.put("wonNodeURI", this.uriService.getGeneralURIPrefix() + "/resource");
        this.messagingService.sendInOnlyMessage(null, headerMap, (Object)WonMessageEncoder.encode((WonMessage)wonMessage, (Lang)Lang.TRIG), "seda:MatcherProtocolOut");
    }

    @Override
    public void atomActivated(URI atomURI, WonMessage wonMessage) {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("atomURI", atomURI.toString());
        headerMap.put("methodName", "atomActivated");
        headerMap.put("wonNodeURI", this.uriService.getGeneralURIPrefix() + "/resource");
        this.messagingService.sendInOnlyMessage(null, headerMap, (Object)WonMessageEncoder.encode((WonMessage)wonMessage, (Lang)Lang.TRIG), "seda:MatcherProtocolOut");
    }

    @Override
    public void atomDeactivated(URI atomURI, WonMessage wonMessage) {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("atomURI", atomURI.toString());
        headerMap.put("methodName", "atomDeactivated");
        headerMap.put("wonNodeURI", this.uriService.getGeneralURIPrefix() + "/resource");
        this.messagingService.sendInOnlyMessage(null, headerMap, (Object)WonMessageEncoder.encode((WonMessage)wonMessage, (Lang)Lang.TRIG), "seda:MatcherProtocolOut");
    }

    @Override
    public void atomDeleted(URI atomURI, WonMessage wonMessage) {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("atomURI", atomURI.toString());
        headerMap.put("methodName", "atomDeleted");
        headerMap.put("wonNodeURI", this.uriService.getGeneralURIPrefix() + "/resource");
        this.messagingService.sendInOnlyMessage(null, headerMap, (Object)WonMessageEncoder.encode((WonMessage)wonMessage, (Lang)Lang.TRIG), "seda:MatcherProtocolOut");
    }
}

