/*
 * Decompiled with CFR 0.152.
 */
package won.node.service.linkeddata.generate;

import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.NoSuchMessageException;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.SliceImpl;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import won.cryptography.rdfsign.WonKeysReaderWriter;
import won.cryptography.service.CryptographyService;
import won.node.service.linkeddata.generate.LinkedDataService;
import won.node.service.nodeconfig.URIService;
import won.node.service.persistence.AtomInformationService;
import won.protocol.exception.NoSuchAtomException;
import won.protocol.exception.NoSuchConnectionException;
import won.protocol.message.WonMessageType;
import won.protocol.model.Atom;
import won.protocol.model.AtomModelMapper;
import won.protocol.model.AtomState;
import won.protocol.model.Connection;
import won.protocol.model.ConnectionModelMapper;
import won.protocol.model.ConnectionState;
import won.protocol.model.DataWithEtag;
import won.protocol.model.DatasetHolder;
import won.protocol.model.DatasetHolderAggregator;
import won.protocol.model.MessageEvent;
import won.protocol.model.unread.UnreadMessageInfo;
import won.protocol.model.unread.UnreadMessageInfoForAtom;
import won.protocol.repository.AtomRepository;
import won.protocol.repository.DatasetHolderRepository;
import won.protocol.repository.MessageContainerRepository;
import won.protocol.repository.MessageEventRepository;
import won.protocol.service.impl.UnreadInformationService;
import won.protocol.util.DefaultAtomModelWrapper;
import won.protocol.util.DefaultPrefixUtils;
import won.protocol.util.RdfUtils;
import won.protocol.vocabulary.RDFG;
import won.protocol.vocabulary.WON;

@Component(value="linkedDataService")
public class LinkedDataServiceImpl
implements LinkedDataService,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String atomResourceURIPrefix;
    private String connectionResourceURIPrefix;
    private String eventResourceURIPrefix;
    @Value(value="${uri.prefix.resource}")
    private String resourceURIPrefix;
    @Autowired
    private MessageEventRepository messageEventRepository;
    @Autowired
    private MessageContainerRepository messageContainerRepository;
    @Autowired
    private AtomRepository atomRepository;
    @Autowired
    private DatasetHolderRepository datasetHolderRepository;
    @Autowired
    private URIService uriService;
    private AtomModelMapper atomModelMapper = new AtomModelMapper();
    private ConnectionModelMapper connectionModelMapper = new ConnectionModelMapper();
    @Autowired
    private CryptographyService cryptographyService;
    @Autowired
    private UnreadInformationService unreadInformationService;
    @Autowired
    private AtomInformationService atomInformationService;
    @Value(value="${uri.protocol.activemq}")
    private String activeMqEndpoint;
    @Value(value="${activemq.queuename.atom.incoming}")
    private String activeMqAtomProtcolQueueName;
    @Value(value="${activemq.queuename.owner.incoming}")
    private String activeMqOwnerProtcolQueueName;
    @Value(value="${activemq.queuename.matcher.incoming}")
    private String activeMqMatcherPrtotocolQueueName;
    @Value(value="${activemq.matcher.outgoing.topicname.atom.created}")
    private String activeMqMatcherProtocolTopicNameAtomCreated;
    @Value(value="${activemq.matcher.outgoing.topicname.atom.activated}")
    private String activeMqMatcherProtocolTopicNameAtomActivated;
    @Value(value="${activemq.matcher.outgoing.topicname.atom.deactivated}")
    private String activeMqMatcherProtocolTopicNameAtomDeactivated;
    @Value(value="${activemq.matcher.outgoing.topicname.atom.deleted}")
    private String activeMqMatcherProtocolTopicNameAtomDeleted;

    public void afterPropertiesSet() throws Exception {
        this.atomResourceURIPrefix = this.resourceURIPrefix + "/atom";
        this.connectionResourceURIPrefix = this.resourceURIPrefix + "/connection";
        this.eventResourceURIPrefix = this.resourceURIPrefix + "/msg";
        logger.info("setting prefixes: atom: {}, connection: {}, event: {}", new Object[]{this.atomResourceURIPrefix, this.connectionResourceURIPrefix, this.eventResourceURIPrefix});
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, isolation=Isolation.READ_COMMITTED, readOnly=true)
    public Dataset listAtomURIs() {
        return this.listAtomURIs(null);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, isolation=Isolation.READ_COMMITTED, readOnly=true)
    public Dataset listAtomURIs(AtomState atomState) {
        return this.listAtomURIs(atomState, null, null);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, isolation=Isolation.READ_COMMITTED, readOnly=true)
    public Dataset listAtomURIs(AtomState atomState, URI filterSocketTypeUri, URI filterAtomTypeUri) {
        Model model = ModelFactory.createDefaultModel();
        this.setNsPrefixes(model);
        Collection<URI> uris = this.atomInformationService.listAtomURIs(atomState);
        return this.getFilteredAtomURIListDataset(model, uris, filterSocketTypeUri, filterAtomTypeUri);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, isolation=Isolation.READ_COMMITTED, readOnly=true)
    public AtomInformationService.PagedResource<Dataset, URI> listPagedAtomURIs(int pageNum) {
        return this.listPagedAtomURIs(pageNum, null, null);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, isolation=Isolation.READ_COMMITTED, readOnly=true)
    public AtomInformationService.PagedResource<Dataset, URI> listPagedAtomURIsBefore(URI atom) {
        return this.listPagedAtomURIsBefore(atom, null, null);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, isolation=Isolation.READ_COMMITTED, readOnly=true)
    public AtomInformationService.PagedResource<Dataset, URI> listPagedAtomURIsAfter(URI atom) {
        return this.listPagedAtomURIsAfter(atom, null, null);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, isolation=Isolation.READ_COMMITTED, readOnly=true)
    public AtomInformationService.PagedResource<Dataset, URI> listPagedAtomURIs(int pageNum, Integer preferedSize, AtomState atomState) {
        Slice<URI> slice = this.atomInformationService.listPagedAtomURIs(pageNum, preferedSize, atomState);
        return this.toContainerPage(this.atomResourceURIPrefix + "/", slice);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, isolation=Isolation.READ_COMMITTED, readOnly=true)
    public AtomInformationService.PagedResource<Dataset, URI> listPagedAtomURIsBefore(URI atom, Integer preferedSize, AtomState atomState) {
        Slice<URI> slice = this.atomInformationService.listPagedAtomURIsBefore(atom, preferedSize, atomState);
        return this.toContainerPage(this.atomResourceURIPrefix + "/", slice);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, isolation=Isolation.READ_COMMITTED, readOnly=true)
    public AtomInformationService.PagedResource<Dataset, URI> listPagedAtomURIsAfter(URI atom, Integer preferedSize, AtomState atomState) {
        Slice<URI> slice = this.atomInformationService.listPagedAtomURIsAfter(atom, preferedSize, atomState);
        return this.toContainerPage(this.atomResourceURIPrefix + "/", slice);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, isolation=Isolation.READ_COMMITTED, readOnly=true)
    public Dataset listAtomURIsModifiedAfter(Date modifiedDate, AtomState atomState, URI filterSocketTypeUri, URI filterAtomTypeUri) {
        Model model = ModelFactory.createDefaultModel();
        this.setNsPrefixes(model);
        Collection<URI> uris = this.atomInformationService.listAtomURIsModifiedAfter(modifiedDate, atomState);
        return this.getFilteredAtomURIListDataset(model, uris, filterSocketTypeUri, filterAtomTypeUri);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, isolation=Isolation.READ_COMMITTED, readOnly=true)
    public Dataset listAtomURIsCreatedAfter(Date createdDate, AtomState atomState, URI filterSocketTypeUri, URI filterAtomTypeUri) {
        Model model = ModelFactory.createDefaultModel();
        this.setNsPrefixes(model);
        Collection<URI> uris = this.atomInformationService.listAtomURIsCreatedAfter(createdDate, atomState);
        return this.getFilteredAtomURIListDataset(model, uris, filterSocketTypeUri, filterAtomTypeUri);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, isolation=Isolation.READ_COMMITTED, readOnly=true)
    public DataWithEtag<Dataset> getAtomDataset(URI atomUri, String etag) {
        DataWithEtag<Atom> atomDataWithEtag;
        Instant start = logger.isDebugEnabled() ? Instant.now() : null;
        try {
            atomDataWithEtag = this.atomInformationService.readAtom(atomUri, etag);
        }
        catch (NoSuchAtomException e) {
            if (logger.isDebugEnabled() && start != null) {
                Instant finish = Instant.now();
                logger.debug("getAtomDataset({}) took {}ms", (Object)atomUri, (Object)Duration.between(start, finish).toMillis());
            }
            return DataWithEtag.dataNotFound();
        }
        if (atomDataWithEtag.isNotFound()) {
            if (logger.isDebugEnabled() && start != null) {
                Instant finish = Instant.now();
                logger.debug("getAtomDataset({}) took {}ms", (Object)atomUri, (Object)Duration.between(start, finish).toMillis());
            }
            return DataWithEtag.dataNotFound();
        }
        if (!atomDataWithEtag.isChanged()) {
            if (logger.isDebugEnabled() && start != null) {
                Instant finish = Instant.now();
                logger.debug("getAtomDataset({}) took {}ms", (Object)atomUri, (Object)Duration.between(start, finish).toMillis());
            }
            return DataWithEtag.dataNotChanged(atomDataWithEtag);
        }
        Atom atom = (Atom)atomDataWithEtag.getData();
        String newEtag = atomDataWithEtag.getEtag();
        boolean isDeleted = atom.getState() == AtomState.DELETED;
        Dataset dataset = isDeleted ? DatasetFactory.createGeneral() : atom.getDatatsetHolder().getDataset();
        Model metaModel = this.atomModelMapper.toModel(atom);
        Resource atomResource = metaModel.getResource(atomUri.toString());
        String atomMetaInformationURI = this.uriService.createAtomSysInfoGraphURI(atomUri).toString();
        Resource atomMetaInformationResource = metaModel.getResource(atomMetaInformationURI);
        atomMetaInformationResource.addProperty(RDFG.SUBGRAPH_OF, (RDFNode)atomResource);
        Resource connectionsContainer = metaModel.createResource(atom.getAtomURI().toString() + "/c");
        metaModel.add(metaModel.createStatement(atomResource, WON.connections, (RDFNode)connectionsContainer));
        Resource atomMessageContainer = metaModel.createResource(atom.getAtomURI().toString() + "#msg", WON.MessageContainer);
        metaModel.add(metaModel.createStatement(atomResource, WON.messageContainer, (RDFNode)atomMessageContainer));
        List messageEvents = this.messageEventRepository.findByParentURI(atomUri);
        for (MessageEvent messageEvent : messageEvents) {
            metaModel.add(metaModel.createStatement(atomMessageContainer, RDFS.member, (RDFNode)metaModel.getResource(messageEvent.getMessageURI().toString())));
        }
        atomResource.addProperty(WON.wonNode, (RDFNode)metaModel.createResource(this.resourceURIPrefix));
        Iterator namesIt = dataset.listNames();
        while (namesIt.hasNext()) {
            String name = (String)namesIt.next();
            Resource atomGraphResource = metaModel.getResource(name);
            atomResource.addProperty(WON.contentGraph, (RDFNode)atomGraphResource);
        }
        dataset.addNamedModel(atomMetaInformationURI, metaModel);
        this.addBaseUriAndDefaultPrefixes(dataset);
        if (logger.isDebugEnabled() && start != null) {
            Instant finish = Instant.now();
            logger.debug("getAtomDataset({}) took {}ms", (Object)atomUri, (Object)Duration.between(start, finish).toMillis());
        }
        return new DataWithEtag((Object)dataset, newEtag, etag, isDeleted);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, isolation=Isolation.READ_COMMITTED, readOnly=true)
    public Dataset getAtomDataset(URI atomUri, boolean deep, Integer deepLayerSize) throws NoSuchAtomException, NoSuchConnectionException, NoSuchMessageException {
        Atom atom;
        Dataset dataset = (Dataset)this.getAtomDataset(atomUri, null).getData();
        if (deep && (atom = this.atomInformationService.readAtom(atomUri)).getState() == AtomState.ACTIVE) {
            Slice<URI> slice = this.atomInformationService.listConnectionURIs(atomUri, 1, deepLayerSize, null, null);
            AtomInformationService.PagedResource<Dataset, URI> connectionsResource = this.toContainerPage(this.uriService.createConnectionsURIForAtom(atomUri).toString(), slice);
            this.addDeepConnectionData(connectionsResource.getContent(), slice.getContent());
            RdfUtils.addDatasetToDataset((Dataset)dataset, (Dataset)connectionsResource.getContent());
            for (URI connectionUri : slice.getContent()) {
                AtomInformationService.PagedResource<Dataset, URI> eventsResource = this.listConnectionEventURIs(connectionUri, 1, deepLayerSize, null, true);
                RdfUtils.addDatasetToDataset((Dataset)dataset, (Dataset)eventsResource.getContent());
            }
        }
        return dataset;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, isolation=Isolation.READ_COMMITTED, readOnly=true)
    public Model getUnreadInformationForAtom(URI atomURI, Collection<URI> lastSeenMessageURIs) {
        UnreadMessageInfoForAtom unreadInfo = this.unreadInformationService.getUnreadInformation(atomURI, lastSeenMessageURIs);
        Model ret = ModelFactory.createDefaultModel();
        Resource atomRes = ret.createResource(atomURI.toString());
        this.addUnreadInfoWithProperty(ret, atomRes, WON.unreadSuggested, (UnreadMessageInfo)unreadInfo.getUnreadInfoByConnectionState().get(ConnectionState.SUGGESTED));
        this.addUnreadInfoWithProperty(ret, atomRes, WON.unreadConnected, (UnreadMessageInfo)unreadInfo.getUnreadInfoByConnectionState().get(ConnectionState.CONNECTED));
        this.addUnreadInfoWithProperty(ret, atomRes, WON.unreadRequestSent, (UnreadMessageInfo)unreadInfo.getUnreadInfoByConnectionState().get(ConnectionState.REQUEST_SENT));
        this.addUnreadInfoWithProperty(ret, atomRes, WON.unreadRequestReceived, (UnreadMessageInfo)unreadInfo.getUnreadInfoByConnectionState().get(ConnectionState.REQUEST_RECEIVED));
        this.addUnreadInfoWithProperty(ret, atomRes, WON.unreadClosed, (UnreadMessageInfo)unreadInfo.getUnreadInfoByConnectionState().get(ConnectionState.CLOSED));
        unreadInfo.getUnreadMessageInfoForConnections().forEach(info -> {
            Resource connRes = ret.createResource(info.getConnectionURI().toString());
            this.addUnreadInfoWithProperty(ret, connRes, null, info.getUnreadInformation());
        });
        return ret;
    }

    private void addUnreadInfoWithProperty(Model ret, Resource subject, Property property, UnreadMessageInfo info) {
        if (info != null) {
            if (property != null) {
                Resource node = ret.createResource();
                subject.addProperty(property, (RDFNode)node);
                subject = node;
            }
            subject.addLiteral(WON.unreadCount, info.getCount());
            subject.addLiteral(WON.unreadOldestTimestamp, info.getOldestTimestamp().getTime());
            subject.addLiteral(WON.unreadNewestTimestamp, info.getNewestTimestamp().getTime());
        }
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, isolation=Isolation.READ_COMMITTED, readOnly=true)
    public Dataset getNodeDataset() {
        Model model = ModelFactory.createDefaultModel();
        this.setNsPrefixes(model);
        Resource showNodePageResource = model.createResource(this.resourceURIPrefix);
        this.addAtomList(model, showNodePageResource);
        this.addProtocolEndpoints(model, showNodePageResource);
        Dataset ret = this.newDatasetWithNamedModel(this.createDataGraphUriFromResource(showNodePageResource), model);
        this.addBaseUriAndDefaultPrefixes(ret);
        this.addPublicKey(model, showNodePageResource);
        return ret;
    }

    private void addAtomList(Model model, Resource res) {
        res.addProperty(WON.atomList, (RDFNode)model.createResource(this.atomResourceURIPrefix));
    }

    private void addPublicKey(Model model, Resource res) {
        WonKeysReaderWriter keyWriter = new WonKeysReaderWriter();
        try {
            keyWriter.writeToModel(model, res, this.cryptographyService.getPublicKey(res.getURI()));
        }
        catch (Exception e) {
            logger.warn("No public key could be added to RDF for " + res.getURI());
        }
    }

    private void addProtocolEndpoints(Model model, Resource res) {
        Resource blankNodeActiveMq = model.createResource();
        res.addProperty(WON.supportsWonProtocolImpl, (RDFNode)blankNodeActiveMq);
        blankNodeActiveMq.addProperty(RDF.type, (RDFNode)WON.WonOverActiveMq).addProperty(WON.brokerUri, (RDFNode)model.createResource(this.activeMqEndpoint)).addProperty(WON.ownerQueue, this.activeMqOwnerProtcolQueueName, (RDFDatatype)XSDDatatype.XSDstring).addProperty(WON.nodeQueue, this.activeMqAtomProtcolQueueName, (RDFDatatype)XSDDatatype.XSDstring).addProperty(WON.matcherQueue, this.activeMqMatcherPrtotocolQueueName, (RDFDatatype)XSDDatatype.XSDstring).addProperty(WON.atomActivatedTopic, this.activeMqMatcherProtocolTopicNameAtomActivated, (RDFDatatype)XSDDatatype.XSDstring).addProperty(WON.atomDeactivatedTopic, this.activeMqMatcherProtocolTopicNameAtomDeactivated, (RDFDatatype)XSDDatatype.XSDstring).addProperty(WON.atomDeletedTopic, this.activeMqMatcherProtocolTopicNameAtomDeleted, (RDFDatatype)XSDDatatype.XSDstring).addProperty(WON.atomCreatedTopic, this.activeMqMatcherProtocolTopicNameAtomCreated, (RDFDatatype)XSDDatatype.XSDstring);
        Resource blankNodeUriSpec = model.createResource();
        res.addProperty(WON.uriPrefixSpecification, (RDFNode)blankNodeUriSpec);
        blankNodeUriSpec.addProperty(WON.atomUriPrefix, (RDFNode)model.createLiteral(this.atomResourceURIPrefix));
        blankNodeUriSpec.addProperty(WON.connectionUriPrefix, (RDFNode)model.createLiteral(this.connectionResourceURIPrefix));
        blankNodeUriSpec.addProperty(WON.eventUriPrefix, (RDFNode)model.createLiteral(this.eventResourceURIPrefix));
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, isolation=Isolation.READ_COMMITTED, readOnly=true)
    public DataWithEtag<Dataset> getConnectionDataset(URI connectionUri, boolean includeMessageContainer, String etag) {
        DataWithEtag<Connection> data = this.atomInformationService.readConnection(connectionUri, etag);
        if (data.isNotFound()) {
            return DataWithEtag.dataNotFound();
        }
        if (!data.isChanged()) {
            return DataWithEtag.dataNotChanged(data);
        }
        Connection connection = (Connection)data.getData();
        if (connection == null) {
            return DataWithEtag.dataNotFound();
        }
        String newEtag = data.getEtag();
        Model model = this.connectionModelMapper.toModel(connection);
        Model additionalData = connection.getDatasetHolder() == null ? null : connection.getDatasetHolder().getDataset().getDefaultModel();
        this.setNsPrefixes(model);
        if (additionalData != null) {
            model.add(additionalData);
        }
        Resource connectionResource = model.getResource(connection.getConnectionURI().toString());
        connectionResource.addProperty(WON.wonNode, (RDFNode)model.createResource(this.resourceURIPrefix));
        if (includeMessageContainer) {
            Resource messageContainer = model.createResource(connection.getConnectionURI().toString() + "/msg");
            connectionResource.addProperty(WON.messageContainer, (RDFNode)messageContainer);
            messageContainer.addProperty(RDF.type, (RDFNode)WON.MessageContainer);
            DatasetHolder datasetHolder = connection.getDatasetHolder();
            if (datasetHolder != null) {
                this.addAdditionalData(model, datasetHolder.getDataset().getDefaultModel(), connectionResource);
            }
        }
        Dataset connectionDataset = this.addBaseUriAndDefaultPrefixes(this.newDatasetWithNamedModel(this.createDataGraphUriFromResource(connectionResource), model));
        return new DataWithEtag((Object)connectionDataset, newEtag, etag);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, isolation=Isolation.READ_COMMITTED, readOnly=true)
    public Dataset listConnection(URI socketUri, URI targetSocketUri, boolean deep) throws NoSuchConnectionException {
        Optional<Connection> con = this.atomInformationService.getConnection(socketUri, targetSocketUri);
        Dataset data = this.makeConnectionContainer(this.connectionResourceURIPrefix + "/", Arrays.asList(con.get()));
        if (deep) {
            this.addDeepConnectionData(data, Arrays.asList(con.get().getConnectionURI()));
        }
        return data;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, isolation=Isolation.READ_COMMITTED, readOnly=true)
    public AtomInformationService.PagedResource<Dataset, Connection> listConnections(boolean deep) throws NoSuchConnectionException {
        ArrayList<Connection> connections = new ArrayList<Connection>(this.atomInformationService.listConnections());
        AtomInformationService.PagedResource<Dataset, Connection> connectionsContainerPage = this.toConnectionsContainerPage(this.connectionResourceURIPrefix + "/", (Slice<Connection>)new SliceImpl(connections));
        if (deep) {
            List<URI> uris = connections.stream().map(Connection::getConnectionURI).collect(Collectors.toList());
            this.addDeepConnectionData(connectionsContainerPage.getContent(), uris);
        }
        return connectionsContainerPage;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, isolation=Isolation.READ_COMMITTED, readOnly=true)
    public AtomInformationService.PagedResource<Dataset, Connection> listModifiedConnectionsAfter(Date modifiedAfter, boolean deep) throws NoSuchConnectionException {
        ArrayList<Connection> connections = new ArrayList<Connection>(this.atomInformationService.listModifiedConnectionsAfter(modifiedAfter));
        AtomInformationService.PagedResource<Dataset, Connection> connectionsContainerPage = this.toConnectionsContainerPage(this.connectionResourceURIPrefix + "/", (Slice<Connection>)new SliceImpl(connections));
        if (deep) {
            List<URI> uris = connections.stream().map(Connection::getConnectionURI).collect(Collectors.toList());
            this.addDeepConnectionData(connectionsContainerPage.getContent(), uris);
        }
        return connectionsContainerPage;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, isolation=Isolation.READ_COMMITTED, readOnly=true)
    public AtomInformationService.PagedResource<Dataset, Connection> listConnections(int page, Integer preferredSize, Date timeSpot, boolean deep) throws NoSuchConnectionException {
        Slice<Connection> slice = this.atomInformationService.listConnections(page, preferredSize, timeSpot);
        AtomInformationService.PagedResource<Dataset, Connection> connectionsContainerPage = this.toConnectionsContainerPage(this.connectionResourceURIPrefix + "/", slice);
        if (deep) {
            List<URI> uris = slice.getContent().stream().map(Connection::getConnectionURI).collect(Collectors.toList());
            this.addDeepConnectionData(connectionsContainerPage.getContent(), uris);
        }
        return connectionsContainerPage;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, isolation=Isolation.READ_COMMITTED, readOnly=true)
    public AtomInformationService.PagedResource<Dataset, Connection> listConnectionsBefore(URI beforeConnURI, Integer preferredSize, Date timeSpot, boolean deep) throws NoSuchConnectionException {
        Slice<Connection> slice = this.atomInformationService.listConnectionsBefore(beforeConnURI, preferredSize, timeSpot);
        AtomInformationService.PagedResource<Dataset, Connection> connectionsContainerPage = this.toConnectionsContainerPage(this.connectionResourceURIPrefix + "/", slice);
        if (deep) {
            List<URI> uris = slice.getContent().stream().map(Connection::getConnectionURI).collect(Collectors.toList());
            this.addDeepConnectionData(connectionsContainerPage.getContent(), uris);
        }
        return connectionsContainerPage;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, isolation=Isolation.READ_COMMITTED, readOnly=true)
    public AtomInformationService.PagedResource<Dataset, Connection> listConnectionsAfter(URI afterConnURI, Integer preferredSize, Date timeSpot, boolean deep) throws NoSuchConnectionException {
        Slice<Connection> slice = this.atomInformationService.listConnectionsAfter(afterConnURI, preferredSize, timeSpot);
        AtomInformationService.PagedResource<Dataset, Connection> connectionsContainerPage = this.toConnectionsContainerPage(this.connectionResourceURIPrefix + "/", slice);
        if (deep) {
            List<URI> uris = slice.getContent().stream().map(Connection::getConnectionURI).collect(Collectors.toList());
            this.addDeepConnectionData(connectionsContainerPage.getContent(), uris);
        }
        return connectionsContainerPage;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, isolation=Isolation.READ_COMMITTED, readOnly=true)
    public AtomInformationService.PagedResource<Dataset, Connection> listConnections(URI atomURI, boolean deep, boolean addMetadata) throws NoSuchAtomException, NoSuchConnectionException {
        ArrayList<Connection> connections = new ArrayList<Connection>(this.atomInformationService.listConnections(atomURI));
        URI connectionsUri = this.uriService.createConnectionsURIForAtom(atomURI);
        AtomInformationService.PagedResource<Dataset, Connection> connectionsContainerPage = this.toConnectionsContainerPage(connectionsUri.toString(), (Slice<Connection>)new SliceImpl(connections));
        if (deep) {
            List<URI> uris = connections.stream().map(Connection::getConnectionURI).collect(Collectors.toList());
            this.addDeepConnectionData(connectionsContainerPage.getContent(), uris);
        }
        if (addMetadata) {
            this.addConnectionMetadata(connectionsContainerPage.getContent(), atomURI, connectionsUri);
        }
        return connectionsContainerPage;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, isolation=Isolation.READ_COMMITTED, readOnly=true)
    public AtomInformationService.PagedResource<Dataset, Connection> listConnections(int page, URI atomURI, Integer preferredSize, WonMessageType messageType, Date timeSpot, boolean deep, boolean addMetadata) throws NoSuchAtomException, NoSuchConnectionException {
        Slice<Connection> slice = this.atomInformationService.listConnections(atomURI, page, preferredSize, messageType, timeSpot);
        URI connectionsUri = this.uriService.createConnectionsURIForAtom(atomURI);
        AtomInformationService.PagedResource<Dataset, Connection> connectionsContainerPage = this.toConnectionsContainerPage(connectionsUri.toString(), slice);
        if (deep) {
            List<URI> uris = slice.getContent().stream().map(Connection::getConnectionURI).collect(Collectors.toList());
            this.addDeepConnectionData(connectionsContainerPage.getContent(), uris);
        }
        if (addMetadata) {
            this.addConnectionMetadata(connectionsContainerPage.getContent(), atomURI, connectionsUri);
        }
        return connectionsContainerPage;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, isolation=Isolation.READ_COMMITTED, readOnly=true)
    public AtomInformationService.PagedResource<Dataset, Connection> listConnectionsBefore(URI atomURI, URI beforeEventURI, Integer preferredSize, WonMessageType messageType, Date timeSpot, boolean deep, boolean addMetadata) throws NoSuchAtomException, NoSuchConnectionException {
        Slice slice = this.atomInformationService.listConnectionsBefore(atomURI, beforeEventURI, preferredSize, messageType, timeSpot);
        URI connectionsUri = this.uriService.createConnectionsURIForAtom(atomURI);
        AtomInformationService.PagedResource<Dataset, Connection> connectionsContainerPage = this.toConnectionsContainerPage(connectionsUri.toString(), (Slice<Connection>)slice);
        if (deep) {
            List<URI> uris = slice.getContent().stream().map(Connection::getConnectionURI).collect(Collectors.toList());
            this.addDeepConnectionData(connectionsContainerPage.getContent(), uris);
        }
        if (addMetadata) {
            this.addConnectionMetadata(connectionsContainerPage.getContent(), atomURI, connectionsUri);
        }
        return connectionsContainerPage;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, isolation=Isolation.READ_COMMITTED, readOnly=true)
    public AtomInformationService.PagedResource<Dataset, Connection> listConnectionsAfter(URI atomURI, URI resumeConnURI, Integer preferredSize, WonMessageType messageType, Date timeSpot, boolean deep, boolean addMetadata) throws NoSuchAtomException, NoSuchConnectionException {
        Slice slice = this.atomInformationService.listConnectionsAfter(atomURI, resumeConnURI, preferredSize, messageType, timeSpot);
        URI connectionsUri = this.uriService.createConnectionsURIForAtom(atomURI);
        AtomInformationService.PagedResource<Dataset, Connection> connectionsContainerPage = this.toConnectionsContainerPage(connectionsUri.toString(), (Slice<Connection>)slice);
        if (deep) {
            List<URI> uris = slice.getContent().stream().map(Connection::getConnectionURI).collect(Collectors.toList());
            this.addDeepConnectionData(connectionsContainerPage.getContent(), uris);
        }
        if (addMetadata) {
            this.addConnectionMetadata(connectionsContainerPage.getContent(), atomURI, connectionsUri);
        }
        return connectionsContainerPage;
    }

    private void addConnectionMetadata(Dataset content, URI atomURI, URI containerURI) {
        Model model = content.getNamedModel(this.createDataGraphUriFromUri(containerURI));
        List connectionCountsPerState = this.atomRepository.getCountsPerConnectionState(atomURI);
        Resource containerResource = model.getResource(containerURI.toString());
        for (Object[] countForState : connectionCountsPerState) {
            ConnectionState stateName = (ConnectionState)countForState[0];
            Long count = (Long)countForState[1];
            Property countProperty = this.getRdfPropertyForState(stateName);
            if (countProperty == null) {
                logger.warn("did not recognize connection state " + stateName);
                continue;
            }
            containerResource.addProperty(countProperty, Integer.toString(count.intValue()), (RDFDatatype)XSDDatatype.XSDint);
        }
    }

    private Property getRdfPropertyForState(ConnectionState state) {
        switch (state) {
            case SUGGESTED: {
                return WON.suggestedCount;
            }
            case REQUEST_RECEIVED: {
                return WON.requestReceivedCount;
            }
            case REQUEST_SENT: {
                return WON.requestSentCount;
            }
            case CONNECTED: {
                return WON.connectedCount;
            }
            case CLOSED: {
                return WON.closedCount;
            }
            case DELETED: {
                return WON.deletedCount;
            }
        }
        return null;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, isolation=Isolation.READ_COMMITTED, readOnly=true)
    public Dataset listConnectionEventURIs(URI connectionUri, boolean deep) throws NoSuchConnectionException {
        Model model = ModelFactory.createDefaultModel();
        this.setNsPrefixes(model);
        Connection connection = this.atomInformationService.readConnection(connectionUri);
        Resource messageContainer = model.createResource(connection.getConnectionURI().toString() + "/msg", WON.MessageContainer);
        List connectionEvents = this.messageEventRepository.findByParentURI(connectionUri);
        Dataset eventsContainerDataset = this.newDatasetWithNamedModel(this.createDataGraphUriFromResource(messageContainer), model);
        this.addBaseUriAndDefaultPrefixes(eventsContainerDataset);
        for (MessageEvent event : connectionEvents) {
            model.add(model.createStatement(messageContainer, RDFS.member, (RDFNode)model.getResource(event.getMessageURI().toString())));
            if (!deep) continue;
            Dataset eventDataset = event.getDatasetHolder().getDataset();
            RdfUtils.addDatasetToDataset((Dataset)eventsContainerDataset, (Dataset)eventDataset);
        }
        return eventsContainerDataset;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, isolation=Isolation.READ_COMMITTED, readOnly=true)
    public AtomInformationService.PagedResource<Dataset, URI> listConnectionEventURIs(URI connectionUri, int pageNum, Integer preferedSize, WonMessageType msgType, boolean deep) throws NoSuchConnectionException {
        Slice<MessageEvent> slice = this.atomInformationService.listConnectionEvents(connectionUri, pageNum, preferedSize, msgType);
        return this.eventsToContainerPage(this.uriService.createEventsURIForConnection(connectionUri).toString(), slice, deep);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, isolation=Isolation.READ_COMMITTED, readOnly=true)
    public AtomInformationService.PagedResource<Dataset, URI> listConnectionEventURIsAfter(URI connectionUri, URI msgURI, Integer preferedSize, WonMessageType msgType, boolean deep) throws NoSuchConnectionException {
        Slice<MessageEvent> slice = this.atomInformationService.listConnectionEventsAfter(connectionUri, msgURI, preferedSize, msgType);
        return this.eventsToContainerPage(this.uriService.createEventsURIForConnection(connectionUri).toString(), slice, deep);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, isolation=Isolation.READ_COMMITTED, readOnly=true)
    public AtomInformationService.PagedResource<Dataset, URI> listConnectionEventURIsBefore(URI connectionUri, URI msgURI, Integer preferedSize, WonMessageType msgType, boolean deep) throws NoSuchConnectionException {
        Slice<MessageEvent> slice = this.atomInformationService.listConnectionEventsBefore(connectionUri, msgURI, preferedSize, msgType);
        return this.eventsToContainerPage(this.uriService.createEventsURIForConnection(connectionUri).toString(), slice, deep);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, isolation=Isolation.READ_COMMITTED, readOnly=true)
    public DataWithEtag<Dataset> getDatasetForUri(URI datasetUri, String etag) {
        Integer version = etag == null ? -1 : Integer.valueOf(etag);
        Optional datasetHolder = this.datasetHolderRepository.findOneByUri(datasetUri);
        if (!datasetHolder.isPresent()) {
            return DataWithEtag.dataNotFound();
        }
        if (version.intValue() == ((DatasetHolder)datasetHolder.get()).getVersion()) {
            return DataWithEtag.dataNotChanged((String)etag);
        }
        Dataset dataset = ((DatasetHolder)datasetHolder.get()).getDataset();
        DefaultPrefixUtils.setDefaultPrefixes((Model)dataset.getDefaultModel());
        this.addBaseUriAndDefaultPrefixes(dataset);
        return new DataWithEtag((Object)dataset, Integer.toString(((DatasetHolder)datasetHolder.get()).getVersion()), etag);
    }

    private String createDataGraphUriFromResource(Resource atomListPageResource) {
        URI uri = URI.create(atomListPageResource.getURI());
        return this.createDataGraphUriFromUri(uri);
    }

    private String createDataGraphUriFromUri(URI uri) {
        try {
            URI ret = new URI(uri.getScheme(), uri.getHost(), uri.getPath(), uri.getQuery(), "data");
            return ret.toString();
        }
        catch (URISyntaxException e) {
            return uri.toString() + "#data";
        }
    }

    private Dataset newDatasetWithNamedModel(String graphUri, Model model) {
        Dataset dataset = DatasetFactory.createGeneral();
        dataset.addNamedModel(graphUri, model);
        return dataset;
    }

    private void addAdditionalData(Model targetModel, Model fromModel, Resource targetResource) {
        if (fromModel != null && fromModel.size() > 0L) {
            Resource additionalData = fromModel.createResource();
            targetModel.add(targetModel.createStatement(targetResource, WON.additionalData, (RDFNode)additionalData));
            targetModel.add(fromModel);
        }
    }

    private void setNsPrefixes(Model model) {
        DefaultPrefixUtils.setDefaultPrefixes((Model)model);
    }

    private Dataset addBaseUriAndDefaultPrefixes(Dataset dataset) {
        this.setNsPrefixes(dataset.getDefaultModel());
        this.addPrefixForSpecialResources(dataset, "local", this.resourceURIPrefix);
        this.addPrefixForSpecialResources(dataset, "atom", this.atomResourceURIPrefix);
        this.addPrefixForSpecialResources(dataset, "event", this.eventResourceURIPrefix);
        this.addPrefixForSpecialResources(dataset, "conn", this.connectionResourceURIPrefix);
        return dataset;
    }

    private void addPrefixForSpecialResources(Dataset dataset, String prefix, String uri) {
        if (uri == null) {
            return;
        }
        if (!uri.endsWith("/") && !uri.endsWith("#")) {
            uri = uri + "/";
        }
        dataset.getDefaultModel().getGraph().getPrefixMapping().setNsPrefix(prefix, uri);
    }

    private AtomInformationService.PagedResource<Dataset, URI> toContainerPage(String containerUri, Slice<URI> slice) {
        Iterator sortOrders;
        List uris = slice.getContent();
        URI resumeBefore = null;
        URI resumeAfter = null;
        if (slice.getSort() != null && !uris.isEmpty() && (sortOrders = slice.getSort().iterator()).hasNext()) {
            Sort.Order sortOrder = (Sort.Order)sortOrders.next();
            if (sortOrder.getDirection() == Sort.Direction.ASC) {
                resumeBefore = (URI)uris.get(0);
                resumeAfter = (URI)uris.get(uris.size() - 1);
            } else {
                resumeBefore = (URI)uris.get(uris.size() - 1);
                resumeAfter = (URI)uris.get(0);
            }
        }
        Model model = ModelFactory.createDefaultModel();
        this.setNsPrefixes(model);
        Resource atomListPageResource = model.createResource(containerUri);
        for (URI atomURI : uris) {
            model.add(model.createStatement(atomListPageResource, RDFS.member, (RDFNode)model.createResource(atomURI.toString())));
        }
        Dataset dataset = this.newDatasetWithNamedModel(this.createDataGraphUriFromResource(atomListPageResource), model);
        this.addBaseUriAndDefaultPrefixes(dataset);
        return new AtomInformationService.PagedResource<Dataset, URI>(dataset, resumeBefore, resumeAfter);
    }

    private AtomInformationService.PagedResource<Dataset, Connection> toConnectionsContainerPage(String containerUri, Slice<Connection> slice) {
        Iterator sortOrders;
        List connections = slice.getContent();
        Connection resumeBefore = null;
        Connection resumeAfter = null;
        if (slice.getSort() != null && !connections.isEmpty() && (sortOrders = slice.getSort().iterator()).hasNext()) {
            Sort.Order sortOrder = (Sort.Order)sortOrders.next();
            if (sortOrder.getDirection() == Sort.Direction.ASC) {
                resumeBefore = (Connection)connections.get(0);
                resumeAfter = (Connection)connections.get(connections.size() - 1);
            } else {
                resumeBefore = (Connection)connections.get(connections.size() - 1);
                resumeAfter = (Connection)connections.get(0);
            }
        }
        Dataset dataset = this.makeConnectionContainer(containerUri, connections);
        this.addBaseUriAndDefaultPrefixes(dataset);
        return new AtomInformationService.PagedResource<Dataset, Object>(dataset, resumeBefore, resumeAfter);
    }

    @Transactional(propagation=Propagation.REQUIRED, isolation=Isolation.READ_COMMITTED, readOnly=true)
    public Dataset makeConnectionContainer(String containerUri, List<Connection> connections) {
        Model model = ModelFactory.createDefaultModel();
        this.setNsPrefixes(model);
        Resource atomListPageResource = model.createResource(containerUri);
        for (Connection conn : connections) {
            model.add(model.createStatement(atomListPageResource, RDFS.member, (RDFNode)model.createResource(conn.getConnectionURI().toString())));
            model.add(this.connectionModelMapper.toModel(conn));
        }
        Dataset dataset = this.newDatasetWithNamedModel(this.createDataGraphUriFromResource(atomListPageResource), model);
        return dataset;
    }

    private AtomInformationService.PagedResource<Dataset, URI> eventsToContainerPage(String containerUri, Slice<MessageEvent> slice, boolean deep) {
        Iterator sortOrders;
        List events = slice.getContent();
        URI resumeBefore = null;
        URI resumeAfter = null;
        if (slice.getSort() != null && !events.isEmpty() && (sortOrders = slice.getSort().iterator()).hasNext()) {
            Sort.Order sortOrder = (Sort.Order)sortOrders.next();
            if (sortOrder.getDirection() == Sort.Direction.ASC) {
                resumeBefore = ((MessageEvent)events.get(0)).getMessageURI();
                resumeAfter = ((MessageEvent)events.get(events.size() - 1)).getMessageURI();
            } else {
                resumeBefore = ((MessageEvent)events.get(events.size() - 1)).getMessageURI();
                resumeAfter = ((MessageEvent)events.get(0)).getMessageURI();
            }
        }
        Model model = ModelFactory.createDefaultModel();
        this.setNsPrefixes(model);
        Resource atomListPageResource = model.createResource(containerUri);
        DatasetHolderAggregator aggregator = new DatasetHolderAggregator();
        for (MessageEvent event : events) {
            model.add(model.createStatement(atomListPageResource, RDFS.member, (RDFNode)model.createResource(event.getMessageURI().toString())));
            if (!deep) continue;
            aggregator.appendDataset(event.getDatasetHolder());
        }
        Dataset dataset = aggregator.aggregate();
        dataset.addNamedModel(this.createDataGraphUriFromResource(atomListPageResource), model);
        this.addBaseUriAndDefaultPrefixes(dataset);
        return new AtomInformationService.PagedResource<Dataset, URI>(dataset, resumeBefore, resumeAfter);
    }

    private void addDeepConnectionData(Dataset dataset, List<URI> connectionURIs) {
        for (URI connectionURI : connectionURIs) {
            DataWithEtag<Dataset> connectionDataset = this.getConnectionDataset(connectionURI, true, null);
            RdfUtils.addDatasetToDataset((Dataset)dataset, (Dataset)((Dataset)connectionDataset.getData()));
        }
    }

    public void setAtomResourceURIPrefix(String atomResourceURIPrefix) {
        this.atomResourceURIPrefix = atomResourceURIPrefix;
    }

    public void setConnectionResourceURIPrefix(String connectionResourceURIPrefix) {
        this.connectionResourceURIPrefix = connectionResourceURIPrefix;
    }

    public void setEventResourceURIPrefix(String eventResourceURIPrefix) {
        this.eventResourceURIPrefix = eventResourceURIPrefix;
    }

    public void setResourceURIPrefix(String resourceURIPrefix) {
        this.resourceURIPrefix = resourceURIPrefix;
    }

    public void setAtomInformationService(AtomInformationService atomInformationService) {
        this.atomInformationService = atomInformationService;
    }

    public void setUriService(URIService uriService) {
        this.uriService = uriService;
    }

    public void setActiveMqOwnerProtcolQueueName(String activeMqOwnerProtcolQueueName) {
        this.activeMqOwnerProtcolQueueName = activeMqOwnerProtcolQueueName;
    }

    public void setActiveMqAtomProtcolQueueName(String activeMqAtomProtcolQueueName) {
        this.activeMqAtomProtcolQueueName = activeMqAtomProtcolQueueName;
    }

    public void setActiveMqMatcherPrtotocolQueueName(String activeMqMatcherPrtotocolQueueName) {
        this.activeMqMatcherPrtotocolQueueName = activeMqMatcherPrtotocolQueueName;
    }

    public void setActiveMqEndpoint(String activeMqEndpoint) {
        this.activeMqEndpoint = activeMqEndpoint;
    }

    public void setActiveMqMatcherProtocolTopicNameAtomCreated(String activeMqMatcherProtocolTopicNameAtomCreated) {
        this.activeMqMatcherProtocolTopicNameAtomCreated = activeMqMatcherProtocolTopicNameAtomCreated;
    }

    public void setActiveMqMatcherProtocolTopicNameAtomActivated(String activeMqMatcherProtocolTopicNameAtomActivated) {
        this.activeMqMatcherProtocolTopicNameAtomActivated = activeMqMatcherProtocolTopicNameAtomActivated;
    }

    public void setActiveMqMatcherProtocolTopicNameAtomDeactivated(String activeMqMatcherProtocolTopicNameAtomDeactivated) {
        this.activeMqMatcherProtocolTopicNameAtomDeactivated = activeMqMatcherProtocolTopicNameAtomDeactivated;
    }

    public void setActiveMqMatcherProtocolTopicNameAtomDeleted(String activeMqMatcherProtocolTopicNameAtomDeleted) {
        this.activeMqMatcherProtocolTopicNameAtomDeleted = activeMqMatcherProtocolTopicNameAtomDeleted;
    }

    private Dataset getFilteredAtomURIListDataset(Model model, Collection<URI> uris, URI filterSocketTypeUri, URI filterAtomTypeUri) {
        Instant start;
        Resource atomListPageResource = model.createResource(this.atomResourceURIPrefix + "/");
        Instant instant = start = logger.isDebugEnabled() ? Instant.now() : null;
        if (filterSocketTypeUri == null && filterAtomTypeUri == null) {
            uris.forEach(atomURI -> model.add(model.createStatement(atomListPageResource, RDFS.member, (RDFNode)model.createResource(atomURI.toString()))));
        } else {
            uris.forEach(atomURI -> {
                Dataset atomDataset = this.getAtomDatasetForFilter((URI)atomURI);
                DefaultAtomModelWrapper atomModelWrapper = new DefaultAtomModelWrapper(atomDataset);
                if ((filterSocketTypeUri == null || atomModelWrapper.getSocketTypeUriMap().containsValue(filterSocketTypeUri)) && (filterAtomTypeUri == null || atomModelWrapper.getContentTypes().contains(filterAtomTypeUri))) {
                    model.add(model.createStatement(atomListPageResource, RDFS.member, (RDFNode)model.createResource(atomURI.toString())));
                }
            });
        }
        Dataset ret = this.newDatasetWithNamedModel(this.createDataGraphUriFromResource(atomListPageResource), model);
        this.addBaseUriAndDefaultPrefixes(ret);
        if (logger.isDebugEnabled() && start != null) {
            Instant finish = Instant.now();
            logger.debug("getFilteredAtomURIListDataset for {} Uris took {}ms", (Object)uris.size(), (Object)Duration.between(start, finish).toMillis());
        }
        return ret;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, isolation=Isolation.READ_COMMITTED, readOnly=true)
    public Dataset getAtomDatasetForFilter(URI atomUri) {
        DataWithEtag<Atom> atomDataWithEtag;
        Instant start = logger.isDebugEnabled() ? Instant.now() : null;
        try {
            atomDataWithEtag = this.atomInformationService.readAtom(atomUri, null);
        }
        catch (NoSuchAtomException e) {
            if (logger.isDebugEnabled() && start != null) {
                Instant finish = Instant.now();
                logger.debug("getAtomDatasetForfilter({}) took {}ms", (Object)atomUri, (Object)Duration.between(start, finish).toMillis());
            }
            return null;
        }
        if (atomDataWithEtag.isNotFound()) {
            if (logger.isDebugEnabled() && start != null) {
                Instant finish = Instant.now();
                logger.debug("getAtomDatasetForfilter({}) took {}ms", (Object)atomUri, (Object)Duration.between(start, finish).toMillis());
            }
            return null;
        }
        Atom atom = (Atom)atomDataWithEtag.getData();
        boolean isDeleted = atom.getState() == AtomState.DELETED;
        Dataset dataset = isDeleted ? DatasetFactory.createGeneral() : atom.getDatatsetHolder().getDataset();
        Model metaModel = this.atomModelMapper.toModel(atom);
        Resource atomResource = metaModel.getResource(atomUri.toString());
        String atomMetaInformationURI = this.uriService.createAtomSysInfoGraphURI(atomUri).toString();
        Resource atomMetaInformationResource = metaModel.getResource(atomMetaInformationURI);
        atomMetaInformationResource.addProperty(RDFG.SUBGRAPH_OF, (RDFNode)atomResource);
        atomResource.addProperty(WON.wonNode, (RDFNode)metaModel.createResource(this.resourceURIPrefix));
        Iterator namesIt = dataset.listNames();
        while (namesIt.hasNext()) {
            String name = (String)namesIt.next();
            Resource atomGraphResource = metaModel.getResource(name);
            atomResource.addProperty(WON.contentGraph, (RDFNode)atomGraphResource);
        }
        dataset.addNamedModel(atomMetaInformationURI, metaModel);
        this.addBaseUriAndDefaultPrefixes(dataset);
        if (logger.isDebugEnabled() && start != null) {
            Instant finish = Instant.now();
            logger.debug("getAtomDatasetForfilter({}) took {}ms", (Object)atomUri, (Object)Duration.between(start, finish).toMillis());
        }
        return dataset;
    }
}

