/*
 * Decompiled with CFR 0.152.
 */
package won.node.service.linkeddata.lookup;

import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import won.node.service.linkeddata.lookup.SocketLookup;
import won.protocol.model.SocketDefinition;
import won.protocol.util.linkeddata.LinkedDataSource;
import won.protocol.util.linkeddata.WonLinkedDataUtils;

@Component
public class SocketLookupFromLinkedData
implements SocketLookup {
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().getClass());
    @Autowired
    LinkedDataSource linkedDataSource;

    @Override
    public Optional<URI> lookupDefaultSocket(URI atomURI) {
        return WonLinkedDataUtils.getDefaultSocket((URI)atomURI, (boolean)true, (LinkedDataSource)this.linkedDataSource);
    }

    @Override
    public Optional<SocketDefinition> getSocketConfig(URI socket) {
        try {
            return WonLinkedDataUtils.getSocketDefinitionOfSocket((LinkedDataSource)this.linkedDataSource, (URI)socket);
        }
        catch (Exception e) {
            this.logger.info("Failed to load configuation for socket type " + socket, (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    public Optional<SocketDefinition> getSocketConfigOfType(URI socketType) {
        try {
            return WonLinkedDataUtils.getSocketDefinition((LinkedDataSource)this.linkedDataSource, (URI)socketType);
        }
        catch (Exception e) {
            this.logger.info("Failed to load configuation for socket type " + socketType, (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    public Optional<URI> getSocketType(URI socketURI) {
        return WonLinkedDataUtils.getTypeOfSocket((URI)socketURI, (LinkedDataSource)this.linkedDataSource);
    }

    @Override
    public Optional<Integer> getCapacity(URI socket) {
        Optional<SocketDefinition> localConfig = this.getSocketConfig(socket);
        if (!localConfig.isPresent() && localConfig.get().getCapacity().isPresent()) {
            return localConfig.get().getCapacity();
        }
        return Optional.empty();
    }

    @Override
    public Optional<Integer> getCapacityOfType(URI socketType) {
        Optional<SocketDefinition> localConfig = this.getSocketConfigOfType(socketType);
        if (!localConfig.isPresent() && localConfig.get().getCapacity().isPresent()) {
            return localConfig.get().getCapacity();
        }
        return Optional.empty();
    }

    @Override
    public boolean isCompatible(URI localSocket, URI targetSocket) {
        Optional<SocketDefinition> localConfig = this.getSocketConfig(localSocket);
        Optional<SocketDefinition> targetConfig = this.getSocketConfig(targetSocket);
        if (localConfig.isPresent() && targetConfig.isPresent()) {
            return localConfig.get().isCompatibleWith(targetConfig.get());
        }
        return false;
    }

    @Override
    public boolean isCompatibleSocketTypes(URI localSocketDefinition, URI targetSocketDefinition) {
        Optional<SocketDefinition> localConfig = this.getSocketConfigOfType(localSocketDefinition);
        Optional<SocketDefinition> targetConfig = this.getSocketConfigOfType(targetSocketDefinition);
        if (localConfig.isPresent() && targetConfig.isPresent()) {
            return localConfig.get().isCompatibleWith(targetConfig.get());
        }
        return false;
    }

    @Override
    public boolean isAutoOpenSocketType(URI socketDefinition) {
        Optional<SocketDefinition> socketConfig = this.getSocketConfigOfType(socketDefinition);
        if (socketConfig.isPresent()) {
            return socketConfig.get().isAutoOpen();
        }
        return false;
    }

    @Override
    public boolean isAutoOpen(URI localSocket) {
        Optional<SocketDefinition> socketConfig = this.getSocketConfig(localSocket);
        if (socketConfig.isPresent()) {
            return socketConfig.get().isAutoOpen();
        }
        return false;
    }
}

