/*
 * Decompiled with CFR 0.152.
 */
package won.node.service.nodebehaviour;

import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import won.node.service.persistence.AtomService;
import won.protocol.jms.MessagingService;
import won.protocol.message.WonMessage;
import won.protocol.message.builder.AtomMessageBuilder;
import won.protocol.message.builder.DeactivateBuilder;
import won.protocol.message.builder.WonMessageBuilder;
import won.protocol.model.Atom;
import won.protocol.service.WonNodeInformationService;

@Component
public class AtomManagementService {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Autowired
    private MessagingService messagingService;
    @Autowired
    private WonNodeInformationService wonNodeInformationService;
    @Autowired
    private AtomService atomService;

    public void sendTextMessageToOwner(URI atomURI, String message) {
        if (atomURI == null) {
            logger.warn("sendTextMessageToOwner called but atomUri is null - doing nothing");
            return;
        }
        if (message == null || message.trim().length() == 0) {
            logger.warn("sendTextMessageToOwner called for atom {}, but message is null or empty - doing nothing", (Object)atomURI);
            return;
        }
        logger.debug("Sending FromSystem text message to atom {}", (Object)atomURI);
        Atom atom = this.atomService.getAtomRequired(atomURI);
        if (atom == null) {
            logger.debug("deactivateAtom called for atom {} but that atom was not found in the repository - doing nothing", (Object)atomURI);
            return;
        }
        URI wonNodeURI = this.wonNodeInformationService.getWonNodeUri(atomURI);
        if (wonNodeURI == null) {
            logger.debug("deactivateAtom called for atom {} but we could not find a WonNodeURI for that atom - doing nothing", (Object)atomURI);
            return;
        }
        WonMessage msg = ((AtomMessageBuilder)((AtomMessageBuilder)WonMessageBuilder.atomMessage().atom(atomURI)).content().text(message)).build();
        this.sendSystemMessage(msg);
    }

    public void deactivateAtom(URI atomURI, String optionalMessage) {
        if (atomURI == null) {
            logger.warn("deactivateAtom called but atomUri is null - doing nothing");
            return;
        }
        logger.debug("Deactivating atom {}", (Object)atomURI);
        Atom atom = this.atomService.getAtomRequired(atomURI);
        if (atom == null) {
            logger.debug("deactivateAtom called for atom {} but that atom was not found in the repository - doing nothing", (Object)atomURI);
            return;
        }
        URI wonNodeURI = this.wonNodeInformationService.getWonNodeUri(atomURI);
        if (wonNodeURI == null) {
            logger.debug("deactivateAtom called for atom {} but we could not find a WonNodeURI for that atom - doing nothing", (Object)atomURI);
            return;
        }
        WonMessage msg = ((DeactivateBuilder)((DeactivateBuilder)((DeactivateBuilder)WonMessageBuilder.deactivate().atom(atomURI)).content().text(optionalMessage)).direction().fromSystem()).build();
        this.sendSystemMessage(msg);
    }

    protected void sendSystemMessage(WonMessage message) {
        HashMap<String, WonMessage> headerMap = new HashMap<String, WonMessage>();
        headerMap.put("won.message", message);
        this.messagingService.sendInOnlyMessage(null, headerMap, null, "seda:SystemMessageIn");
    }
}

