/*
 * Decompiled with CFR 0.152.
 */
package won.node.service.nodebehaviour;

import java.util.Objects;
import java.util.Optional;
import won.protocol.model.ConnectionState;

public class ConnectionStateChange {
    private Optional<ConnectionState> oldState = Optional.empty();
    private ConnectionState newState;

    public ConnectionStateChange(ConnectionState oldState, ConnectionState newState) {
        Objects.nonNull(oldState);
        Objects.nonNull(newState);
        this.oldState = Optional.of(oldState);
        this.newState = newState;
    }

    public ConnectionStateChange(ConnectionState newState) {
        Objects.nonNull(newState);
        this.newState = newState;
    }

    public boolean isConnect() {
        return this.newState.equals((Object)ConnectionState.CONNECTED) && this.newState != this.oldState.orElse(null);
    }

    public boolean isDisconnect() {
        return this.oldState.isPresent() && this.oldState.get() == ConnectionState.CONNECTED && this.newState != this.oldState.orElse(null);
    }

    public Optional<ConnectionState> getOldState() {
        return this.oldState;
    }

    public ConnectionState getNewState() {
        return this.newState;
    }
}

