/*
 * Decompiled with CFR 0.152.
 */
package won.node.service.nodebehaviour;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import won.node.service.linkeddata.lookup.SocketLookup;
import won.node.service.nodebehaviour.ConnectionStateChange;
import won.protocol.model.Atom;
import won.protocol.model.Connection;
import won.protocol.model.SocketDefinition;
import won.protocol.repository.AtomRepository;

@Component
public class DataDerivationService {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    AtomRepository atomRepository;
    @Autowired
    SocketLookup socketLookup;
    Map<URI, SocketDefinition> knownSockets = new HashMap<URI, SocketDefinition>();

    public boolean deriveDataForStateChange(ConnectionStateChange stateChange, Atom atom, Connection con) {
        if (stateChange.isConnect() || stateChange.isDisconnect()) {
            this.logger.info("performing data derivation for connection {}", (Object)con.getConnectionURI());
            Dataset atomDataset = atom.getDatatsetHolder().getDataset();
            Model derivationModel = atomDataset.getNamedModel(atom.getAtomURI() + "#derivedData");
            if (derivationModel == null) {
                derivationModel = ModelFactory.createDefaultModel();
                atomDataset.addNamedModel(atom.getAtomURI() + "#derivedData", derivationModel);
            }
            Model modelToManipulate = derivationModel;
            Optional<SocketDefinition> socketConfig = this.socketLookup.getSocketConfig(con.getSocketURI());
            if (socketConfig.isPresent()) {
                Resource atomRes = derivationModel.getResource(atom.getAtomURI().toString());
                Resource targetAtomRes = derivationModel.getResource(con.getTargetAtomURI().toString());
                if (stateChange.isConnect()) {
                    this.logger.info("adding data for connection {}", (Object)con.getConnectionURI());
                    socketConfig.get().getDerivationProperties().stream().map(u -> modelToManipulate.createProperty(u.toString())).forEach(p -> modelToManipulate.add(atomRes, p, (RDFNode)targetAtomRes));
                    socketConfig.get().getInverseDerivationProperties().stream().map(u -> modelToManipulate.createProperty(u.toString())).forEach(p -> modelToManipulate.add(targetAtomRes, p, (RDFNode)atomRes));
                } else {
                    this.logger.info("removing data for connection {}", (Object)con.getConnectionURI());
                    socketConfig.get().getDerivationProperties().stream().map(u -> modelToManipulate.createProperty(u.toString())).forEach(p -> modelToManipulate.remove(atomRes, p, (RDFNode)targetAtomRes));
                    socketConfig.get().getInverseDerivationProperties().stream().map(u -> modelToManipulate.createProperty(u.toString())).forEach(p -> modelToManipulate.remove(targetAtomRes, p, (RDFNode)atomRes));
                }
            }
            atom.incrementVersion();
            atom.getDatatsetHolder().setDataset(atomDataset);
            this.atomRepository.save((Object)atom);
            return true;
        }
        return false;
    }
}

