/*
 * Decompiled with CFR 0.152.
 */
package won.node.service.nodeconfig;

import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;
import won.protocol.util.WonMessageUriHelper;
import won.protocol.util.WonUriCheckHelper;

@Component
public class URIService
implements InitializingBean {
    private String generalURIPrefix;
    private String atomResourceURIPrefix;
    private String connectionResourceURIPrefix;
    private String eventResourceURIPrefix;
    private String attachmentResourceURIPrefix;
    private String dataURIPrefix;
    private String resourceURIPrefix;
    private String pageURIPrefix;
    private Pattern connectionEventsPattern;
    private Pattern connectionUriPattern;
    private Pattern atomEventsPattern;
    private Pattern atomUnreadPattern;
    private Pattern atomUriPattern;

    public void afterPropertiesSet() throws Exception {
        this.atomResourceURIPrefix = this.resourceURIPrefix + "/atom";
        this.connectionResourceURIPrefix = this.resourceURIPrefix + "/connection";
        this.eventResourceURIPrefix = this.resourceURIPrefix + "/msg";
        this.attachmentResourceURIPrefix = this.resourceURIPrefix + "/attachment";
        this.connectionEventsPattern = Pattern.compile(this.atomResourceURIPrefix + "/[a-zA-Z0-9]+/c/[a-zA-Z0-9]+/msg");
        this.connectionUriPattern = Pattern.compile(this.atomResourceURIPrefix + "/[a-zA-Z0-9]+/c/[a-zA-Z0-9]+");
        this.atomEventsPattern = Pattern.compile(this.atomResourceURIPrefix + "/[a-zA-Z0-9]+/msg");
        this.atomUnreadPattern = Pattern.compile(this.atomResourceURIPrefix + "/[a-zA-Z0-9]+/unread");
        this.atomUriPattern = Pattern.compile(this.atomResourceURIPrefix + "/[a-zA-Z0-9]+");
    }

    public boolean isEventURI(URI toCheck) {
        if (toCheck == null) {
            return false;
        }
        return toCheck.toString().startsWith(this.eventResourceURIPrefix);
    }

    public boolean isAtomURI(URI toCheck) {
        if (toCheck == null) {
            return false;
        }
        return toCheck.toString().startsWith(this.atomResourceURIPrefix);
    }

    public boolean isConnectionURI(URI toCheck) {
        if (toCheck == null) {
            return false;
        }
        return WonUriCheckHelper.isValidConnectionURI((String)this.atomResourceURIPrefix, (String)toCheck.toString());
    }

    public boolean isAtomEventsURI(URI toCheck) {
        if (toCheck == null) {
            return false;
        }
        Matcher m = this.atomEventsPattern.matcher(toCheck.toString());
        return m.lookingAt();
    }

    public boolean isAtomUnreadURI(URI toCheck) {
        if (toCheck == null) {
            return false;
        }
        Matcher m = this.atomUnreadPattern.matcher(toCheck.toString());
        return m.lookingAt();
    }

    public boolean isConnectionEventsURI(URI toCheck) {
        if (toCheck == null) {
            return false;
        }
        Matcher m = this.connectionEventsPattern.matcher(toCheck.toString());
        return m.lookingAt();
    }

    public URI getConnectionURIofConnectionEventsURI(URI connectionEventsURI) {
        if (connectionEventsURI == null) {
            return null;
        }
        Matcher m = this.connectionUriPattern.matcher(connectionEventsURI.toString());
        m.find();
        return URI.create(m.group());
    }

    public URI getAtomURIofAtomEventsURI(URI atomEventsURI) {
        if (atomEventsURI == null) {
            return null;
        }
        Matcher m = this.atomUriPattern.matcher(atomEventsURI.toString());
        m.find();
        return URI.create(m.group());
    }

    public URI getAtomURIofAtomUnreadURI(URI atomUnreadURI) {
        if (atomUnreadURI == null) {
            return null;
        }
        Matcher m = this.atomUriPattern.matcher(atomUnreadURI.toString());
        m.find();
        return URI.create(m.group());
    }

    public URI toDataURIIfPossible(URI pageOrResourceURI) {
        String fromURI = this.resolveAgainstGeneralURIPrefix(pageOrResourceURI);
        if (fromURI.startsWith(this.pageURIPrefix)) {
            return URI.create(fromURI.replaceFirst(this.pageURIPrefix, this.dataURIPrefix));
        }
        if (fromURI.startsWith(this.resourceURIPrefix)) {
            return URI.create(fromURI.replaceFirst(this.resourceURIPrefix, this.dataURIPrefix));
        }
        return pageOrResourceURI;
    }

    public URI toPageURIIfPossible(URI dataOrResourceURI) {
        String fromURI = this.resolveAgainstGeneralURIPrefix(dataOrResourceURI);
        if (fromURI.startsWith(this.dataURIPrefix)) {
            return URI.create(fromURI.replaceFirst(this.dataURIPrefix, this.pageURIPrefix));
        }
        if (fromURI.startsWith(this.resourceURIPrefix)) {
            return URI.create(fromURI.replaceFirst(this.resourceURIPrefix, this.pageURIPrefix));
        }
        return dataOrResourceURI;
    }

    public URI toResourceURIIfPossible(URI pageOrDataURI) {
        String fromURI = this.resolveAgainstGeneralURIPrefix(pageOrDataURI);
        if (fromURI.startsWith(this.dataURIPrefix)) {
            return URI.create(fromURI.replaceFirst(this.dataURIPrefix, this.resourceURIPrefix));
        }
        if (fromURI.startsWith(this.pageURIPrefix)) {
            return URI.create(fromURI.replaceFirst(this.pageURIPrefix, this.resourceURIPrefix));
        }
        return pageOrDataURI;
    }

    private String resolveAgainstGeneralURIPrefix(URI uri) {
        if (uri.isAbsolute()) {
            return uri.toString();
        }
        return URI.create(this.generalURIPrefix).resolve(uri).toString();
    }

    public URI createAtomURIForId(String id) {
        return URI.create(this.atomResourceURIPrefix + "/" + id);
    }

    public URI createConnectionURIForId(String atomId, String connectionId) {
        return URI.create(this.atomResourceURIPrefix + "/" + atomId + "/c/" + connectionId);
    }

    public URI createConnectionsURIForAtom(URI atomURI) {
        return URI.create(atomURI.toString() + "/c");
    }

    public URI createEventsURIForConnection(URI connURI) {
        return URI.create(connURI.toString() + "/msg");
    }

    public URI createEventURIForId(String id) {
        return WonMessageUriHelper.createMessageURIForId((String)id);
    }

    public URI createAttachmentURIForId(String id) {
        return URI.create(this.attachmentResourceURIPrefix + "/" + id);
    }

    public String getAtomResourceURIPrefix() {
        return this.atomResourceURIPrefix;
    }

    public String getEventResourceURIPrefix() {
        return this.eventResourceURIPrefix;
    }

    public void setDataURIPrefix(String dataURIPrefix) {
        this.dataURIPrefix = dataURIPrefix;
    }

    public void setResourceURIPrefix(String resourceURIPrefix) {
        this.resourceURIPrefix = resourceURIPrefix;
    }

    public String getResourceURIPrefix() {
        return this.resourceURIPrefix;
    }

    public void setPageURIPrefix(String pageURIPrefix) {
        this.pageURIPrefix = pageURIPrefix;
    }

    public void setGeneralURIPrefix(String generalURIPrefix) {
        this.generalURIPrefix = generalURIPrefix;
    }

    public URI createAtomSysInfoGraphURI(URI atomURI) {
        return URI.create(atomURI.toString() + "#sysinfo");
    }

    public Long getEventIdFromEventURI(URI eventURI) {
        String path = eventURI.getPath();
        return new Long(path.substring(path.lastIndexOf("/") + 1));
    }

    public String getGeneralURIPrefix() {
        return this.generalURIPrefix;
    }

    public URI toLocalMessageURI(URI messageURI) {
        return WonMessageUriHelper.toLocalMessageURI((URI)messageURI, (String)this.eventResourceURIPrefix);
    }

    public URI toGenericMessageURI(URI localMessageURI) {
        return WonMessageUriHelper.toGenericMessageURI((URI)localMessageURI, (String)this.eventResourceURIPrefix);
    }
}

