/*
 * Decompiled with CFR 0.152.
 */
package won.node.service.persistence;

import java.net.URI;
import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;
import won.node.service.nodeconfig.URIService;
import won.node.service.persistence.AtomInformationService;
import won.protocol.exception.NoSuchAtomException;
import won.protocol.exception.NoSuchConnectionException;
import won.protocol.exception.NoSuchMessageException;
import won.protocol.message.WonMessageType;
import won.protocol.model.Atom;
import won.protocol.model.AtomState;
import won.protocol.model.Connection;
import won.protocol.model.DataWithEtag;
import won.protocol.model.MessageEvent;
import won.protocol.repository.AtomRepository;
import won.protocol.repository.ConnectionRepository;
import won.protocol.repository.MessageEventRepository;
import won.protocol.util.DataAccessUtils;

@Component
public class AtomInformationServiceImpl
implements AtomInformationService {
    @Autowired
    private AtomRepository atomRepository;
    @Autowired
    private ConnectionRepository connectionRepository;
    @Autowired
    private MessageEventRepository messageEventRepository;
    @Autowired
    private URIService uriService;
    private static final int DEFAULT_PAGE_SIZE = 500;
    private int pageSize = 500;

    @Override
    public Collection<URI> listAtomURIs() {
        return this.atomRepository.getAllAtomURIs(null);
    }

    @Override
    public Collection<URI> listAtomURIs(AtomState atomState) {
        return this.atomRepository.getAllAtomURIs(atomState);
    }

    @Override
    public Slice<URI> listPagedAtomURIs(int page, Integer preferedPageSize, AtomState atomState) {
        int pageSize = this.pageSize;
        int pageNum = page - 1;
        if (preferedPageSize != null && preferedPageSize < this.pageSize) {
            pageSize = preferedPageSize;
        }
        return this.atomRepository.getAllAtomURIs(atomState, (Pageable)new PageRequest(pageNum, pageSize, Sort.Direction.DESC, new String[]{"creationDate"}));
    }

    @Override
    public Slice<URI> listPagedAtomURIsBefore(URI atomURI, Integer preferedPageSize, AtomState atomState) {
        Atom referenceAtom = (Atom)this.atomRepository.findOneByAtomURI(atomURI).orElseThrow(() -> new NoSuchAtomException(atomURI));
        Date referenceDate = referenceAtom.getCreationDate();
        int pageSize = this.pageSize;
        if (preferedPageSize != null && preferedPageSize < this.pageSize) {
            pageSize = preferedPageSize;
        }
        Slice slice = null;
        slice = atomState == null ? this.atomRepository.getAtomURIsBefore(referenceDate, (Pageable)new PageRequest(0, pageSize, Sort.Direction.DESC, new String[]{"creationDate"})) : this.atomRepository.getAtomURIsBefore(referenceDate, atomState, (Pageable)new PageRequest(0, pageSize, Sort.Direction.DESC, new String[]{"creationDate"}));
        return slice;
    }

    @Override
    public Collection<URI> listAtomURIsModifiedAfter(Date modifiedAfter, AtomState atomState) {
        return this.atomRepository.getAllAtomURIsModifiedAfter(modifiedAfter, atomState);
    }

    @Override
    public Collection<URI> listAtomURIsCreatedAfter(Date createdAfter, AtomState atomState) {
        return this.atomRepository.getAllAtomURIsCreatedAfter(createdAfter, atomState);
    }

    @Override
    public Slice<URI> listPagedAtomURIsAfter(URI atomURI, Integer preferedPageSize, AtomState atomState) {
        Atom referenceAtom = (Atom)this.atomRepository.findOneByAtomURI(atomURI).orElseThrow(() -> new NoSuchAtomException(atomURI));
        Date referenceDate = referenceAtom.getCreationDate();
        int pageSize = this.pageSize;
        if (preferedPageSize != null && preferedPageSize < this.pageSize) {
            pageSize = preferedPageSize;
        }
        Slice slice = null;
        slice = atomState == null ? this.atomRepository.getAtomURIsAfter(referenceDate, (Pageable)new PageRequest(0, pageSize, Sort.Direction.ASC, new String[]{"creationDate"})) : this.atomRepository.getAtomURIsAfter(referenceDate, atomState, (Pageable)new PageRequest(0, pageSize, Sort.Direction.ASC, new String[]{"creationDate"}));
        return slice;
    }

    @Override
    public Collection<URI> listConnectionURIs() {
        return this.connectionRepository.getAllConnectionURIs();
    }

    @Override
    public Optional<Connection> getConnection(URI socket, URI targetSocket) {
        return this.connectionRepository.findOneBySocketURIAndTargetSocketURI(socket, targetSocket);
    }

    @Override
    public Collection<Connection> listConnections() {
        return this.connectionRepository.getAllConnections();
    }

    @Override
    public Collection<Connection> listModifiedConnectionsAfter(Date modifiedAfter) {
        return this.connectionRepository.findModifiedConnectionsAfter(modifiedAfter);
    }

    @Override
    @Deprecated
    public Slice<URI> listConnectionURIs(int page, Integer preferedPageSize, Date timeSpot) {
        int pageSize = this.getPageSize(preferedPageSize);
        int pageNum = page - 1;
        Slice slice = timeSpot == null ? this.connectionRepository.getConnectionURIByActivityDate((Pageable)new PageRequest(pageNum, pageSize, Sort.Direction.DESC, new String[]{"min(msg.creationDate)"})) : this.connectionRepository.getConnectionURIByActivityDate(timeSpot, (Pageable)new PageRequest(pageNum, pageSize, Sort.Direction.DESC, new String[]{"min(msg.creationDate)"}));
        return slice;
    }

    @Override
    public Slice<Connection> listConnections(int page, Integer preferedPageSize, Date timeSpot) {
        int pageSize = this.getPageSize(preferedPageSize);
        int pageNum = page - 1;
        Slice slice = timeSpot == null ? this.connectionRepository.getConnectionsByActivityDate((Pageable)new PageRequest(pageNum, pageSize, Sort.Direction.DESC, new String[]{"min(msg.creationDate)"})) : this.connectionRepository.getConnectionsByActivityDate(timeSpot, (Pageable)new PageRequest(pageNum, pageSize, Sort.Direction.DESC, new String[]{"min(msg.creationDate)"}));
        return slice;
    }

    @Override
    public Slice<Connection> listConnectionsBefore(URI resumeConnURI, Integer preferredPageSize, Date timeSpot) {
        Date resume = this.messageEventRepository.findMaxActivityDateOfParentAtTime(resumeConnURI, timeSpot);
        int pageSize = this.getPageSize(preferredPageSize);
        Slice slice = this.connectionRepository.getConnectionsBeforeByActivityDate(resume, timeSpot, (Pageable)new PageRequest(0, pageSize, Sort.Direction.DESC, new String[]{"min(msg.creationDate)"}));
        return slice;
    }

    @Override
    public Slice<Connection> listConnectionsAfter(URI resumeConnURI, Integer preferredPageSize, Date timeSpot) {
        Date resume = this.messageEventRepository.findMaxActivityDateOfParentAtTime(resumeConnURI, timeSpot);
        int pageSize = this.getPageSize(preferredPageSize);
        Slice slice = this.connectionRepository.getConnectionsAfterByActivityDate(resume, timeSpot, (Pageable)new PageRequest(0, pageSize, Sort.Direction.ASC, new String[]{"min(msg.creationDate)"}));
        return slice;
    }

    @Override
    @Deprecated
    public Collection<URI> listConnectionURIs(URI atomURI) throws NoSuchAtomException {
        return this.connectionRepository.getAllConnectionURIsForAtomURI(atomURI);
    }

    @Override
    public Collection<Connection> listConnections(URI atomURI) throws NoSuchAtomException {
        return this.connectionRepository.findByAtomURI(atomURI);
    }

    @Override
    @Deprecated
    public Slice<URI> listConnectionURIs(URI atomURI, int page, Integer preferedPageSize, WonMessageType messageType, Date timeSpot) {
        Slice slice = null;
        int pageSize = this.getPageSize(preferedPageSize);
        int pageNum = page - 1;
        PageRequest pageRequest = new PageRequest(pageNum, pageSize, Sort.Direction.DESC, new String[]{"min(msg.creationDate)"});
        slice = messageType == null ? (timeSpot == null ? this.connectionRepository.getConnectionURIByActivityDate(atomURI, (Pageable)pageRequest) : this.connectionRepository.getConnectionURIByActivityDate(atomURI, timeSpot, (Pageable)pageRequest)) : (timeSpot == null ? this.connectionRepository.getConnectionURIByActivityDate(atomURI, messageType, (Pageable)pageRequest) : this.connectionRepository.getConnectionURIByActivityDate(atomURI, messageType, timeSpot, (Pageable)pageRequest));
        return slice;
    }

    @Override
    public Slice<Connection> listConnections(URI atomURI, int page, Integer preferedPageSize, WonMessageType messageType, Date timeSpot) {
        Slice slice = null;
        int pageSize = this.getPageSize(preferedPageSize);
        int pageNum = page - 1;
        PageRequest pageRequest = new PageRequest(pageNum, pageSize, Sort.Direction.DESC, new String[]{"min(msg.creationDate)"});
        slice = messageType == null ? (timeSpot == null ? this.connectionRepository.getConnectionsByActivityDate(atomURI, (Pageable)pageRequest) : this.connectionRepository.getConnectionsByActivityDate(atomURI, timeSpot, (Pageable)pageRequest)) : (timeSpot == null ? this.connectionRepository.getConnectionsByActivityDate(atomURI, messageType, (Pageable)pageRequest) : this.connectionRepository.getConnectionsByActivityDate(atomURI, messageType, timeSpot, (Pageable)pageRequest));
        return slice;
    }

    public Slice<Connection> listConnectionsBefore(URI atomURI, URI resumeConnURI, Integer preferredPageSize, WonMessageType messageType, Date timeSpot) {
        Slice slice;
        int pageSize = this.getPageSize(preferredPageSize);
        if (messageType == null) {
            Date resume = this.messageEventRepository.findMaxActivityDateOfParentAtTime(resumeConnURI, timeSpot);
            slice = this.connectionRepository.getConnectionsBeforeByActivityDate(atomURI, resume, timeSpot, (Pageable)new PageRequest(0, pageSize, Sort.Direction.DESC, new String[]{"min(msg.creationDate)"}));
        } else {
            Date resume = this.messageEventRepository.findMaxActivityDateOfParentAtTime(resumeConnURI, messageType, timeSpot);
            slice = this.connectionRepository.getConnectionsBeforeByActivityDate(atomURI, resume, messageType, timeSpot, (Pageable)new PageRequest(0, pageSize, Sort.Direction.DESC, new String[]{"min(msg.creationDate)"}));
        }
        return slice;
    }

    public Slice<Connection> listConnectionsAfter(URI atomURI, URI resumeConnURI, Integer preferredPageSize, WonMessageType messageType, Date timeSpot) {
        Slice slice;
        int pageSize = this.getPageSize(preferredPageSize);
        if (messageType == null) {
            Date resume = this.messageEventRepository.findMaxActivityDateOfParentAtTime(resumeConnURI, timeSpot);
            slice = this.connectionRepository.getConnectionsAfterByActivityDate(atomURI, resume, timeSpot, (Pageable)new PageRequest(0, pageSize, Sort.Direction.ASC, new String[]{"min(msg.creationDate)"}));
        } else {
            Date resume = this.messageEventRepository.findMaxActivityDateOfParentAtTime(resumeConnURI, messageType, timeSpot);
            slice = this.connectionRepository.getConnectionsAfterByActivityDate(atomURI, resume, messageType, timeSpot, (Pageable)new PageRequest(0, pageSize, Sort.Direction.ASC, new String[]{"min(msg.creationDate)"}));
        }
        return slice;
    }

    @Override
    public Atom readAtom(URI atomURI) throws NoSuchAtomException {
        if (atomURI == null) {
            throw new IllegalArgumentException("atomURI is not set");
        }
        return DataAccessUtils.loadAtom((AtomRepository)this.atomRepository, (URI)atomURI);
    }

    @Override
    public DataWithEtag<Atom> readAtom(URI atomURI, String etag) throws NoSuchAtomException {
        if (atomURI == null) {
            throw new IllegalArgumentException("atomURI is not set");
        }
        Atom atom = null;
        if (etag == null) {
            atom = DataAccessUtils.loadAtom((AtomRepository)this.atomRepository, (URI)atomURI);
        } else {
            Integer version = Integer.valueOf(etag);
            atom = this.atomRepository.findOneByAtomURIAndVersionNot(atomURI, version.intValue());
        }
        boolean isDeleted = atom != null && atom.getState() == AtomState.DELETED;
        return new DataWithEtag((Object)atom, atom == null ? etag : Integer.toString(atom.getVersion()), etag, isDeleted);
    }

    @Override
    public Model readAtomContent(URI atomURI) throws NoSuchAtomException {
        if (atomURI == null) {
            throw new IllegalArgumentException("atomURI is not set");
        }
        Atom atom = DataAccessUtils.loadAtom((AtomRepository)this.atomRepository, (URI)atomURI);
        return atom == null || atom.getState() == AtomState.DELETED ? ModelFactory.createDefaultModel() : atom.getDatatsetHolder().getDataset().getDefaultModel();
    }

    @Override
    public Connection readConnection(URI connectionURI) throws NoSuchConnectionException {
        if (connectionURI == null) {
            throw new IllegalArgumentException("connectionURI is not set");
        }
        return DataAccessUtils.loadConnection((ConnectionRepository)this.connectionRepository, (URI)connectionURI);
    }

    @Override
    public DataWithEtag<Connection> readConnection(URI connectionURI, String etag) {
        if (connectionURI == null) {
            throw new IllegalArgumentException("connectionURI is not set");
        }
        Connection con = null;
        if (etag == null) {
            con = (Connection)this.connectionRepository.findOneByConnectionURI(connectionURI).orElseThrow(() -> new NoSuchConnectionException(connectionURI));
        } else {
            Integer version = Integer.valueOf(etag);
            con = this.connectionRepository.findOneByConnectionURIAndVersionNot(connectionURI, version.intValue());
        }
        return new DataWithEtag((Object)con, con == null ? etag : Integer.toString(con.getVersion()), etag);
    }

    @Override
    public Model readConnectionContent(URI connectionURI) throws NoSuchConnectionException {
        return null;
    }

    @Override
    public Slice<MessageEvent> listConnectionEvents(URI connectionUri, int page, Integer preferedPageSize, WonMessageType messageType) {
        int pageSize = this.getPageSize(preferedPageSize);
        int pageNum = page - 1;
        Slice slice = null;
        slice = messageType == null ? this.messageEventRepository.findByParentURI(connectionUri, (Pageable)new PageRequest(pageNum, pageSize, Sort.Direction.DESC, new String[]{"creationDate"})) : this.messageEventRepository.findByParentURIAndType(connectionUri, messageType, (Pageable)new PageRequest(pageNum, pageSize, Sort.Direction.DESC, new String[]{"creationDate"}));
        return slice;
    }

    @Override
    public Slice<MessageEvent> listConnectionEventsAfter(URI connectionUri, URI msgURI, Integer preferredPageSize, WonMessageType msgType) {
        MessageEvent referenceMsg = (MessageEvent)this.messageEventRepository.findFirstByMessageURIAndParentURI(msgURI, connectionUri).orElseThrow(() -> new NoSuchMessageException(msgURI));
        Date referenceDate = referenceMsg.getCreationDate();
        int pageSize = this.getPageSize(preferredPageSize);
        Slice slice = null;
        slice = msgType == null ? this.messageEventRepository.findByParentURIAfter(connectionUri, referenceDate, (Pageable)new PageRequest(0, pageSize, Sort.Direction.ASC, new String[]{"creationDate"})) : this.messageEventRepository.findByParentURIAndTypeAfter(connectionUri, referenceDate, msgType, (Pageable)new PageRequest(0, pageSize, Sort.Direction.ASC, new String[]{"creationDate"}));
        return slice;
    }

    @Override
    public Slice<MessageEvent> listConnectionEventsBefore(URI connectionUri, URI msgURI, Integer preferredPageSize, WonMessageType msgType) {
        int pageSize = this.getPageSize(preferredPageSize);
        Slice slice = null;
        slice = msgType == null ? this.messageEventRepository.findByParentURIBeforeFetchDatasetEagerly(connectionUri, msgURI, (Pageable)new PageRequest(0, pageSize, Sort.Direction.DESC, new String[]{"creationDate"})) : this.messageEventRepository.findByParentURIAndTypeBeforeFetchDatasetEagerly(connectionUri, msgURI, msgType, (Pageable)new PageRequest(0, pageSize, Sort.Direction.DESC, new String[]{"creationDate"}));
        return slice;
    }

    private int getPageSize(Integer preferredPageSize) {
        int pageSize = this.pageSize;
        if (preferredPageSize != null && preferredPageSize < this.pageSize) {
            pageSize = preferredPageSize;
        }
        return pageSize;
    }

    public void setAtomRepository(AtomRepository atomRepository) {
        this.atomRepository = atomRepository;
    }

    public void setConnectionRepository(ConnectionRepository connectionRepository) {
        this.connectionRepository = connectionRepository;
    }

    private boolean isAtomActive(Atom atom) {
        return AtomState.ACTIVE == atom.getState();
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }
}

