/*
 * Decompiled with CFR 0.152.
 */
package won.node.service.persistence;

import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.javasimon.SimonManager;
import org.javasimon.Split;
import org.javasimon.Stopwatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import won.node.service.nodeconfig.URIService;
import won.node.service.persistence.ConnectionService;
import won.node.service.persistence.MessageService;
import won.protocol.exception.IllegalAtomContentException;
import won.protocol.exception.IllegalAtomURIException;
import won.protocol.exception.IllegalSocketModificationException;
import won.protocol.exception.MissingMessagePropertyException;
import won.protocol.exception.NoSuchAtomException;
import won.protocol.exception.UriAlreadyInUseException;
import won.protocol.exception.WonMessageProcessingException;
import won.protocol.exception.WrongAddressingInformationException;
import won.protocol.message.WonMessage;
import won.protocol.message.WonMessageDirection;
import won.protocol.message.WonMessageType;
import won.protocol.message.WonMessageUtils;
import won.protocol.model.Atom;
import won.protocol.model.AtomMessageContainer;
import won.protocol.model.AtomState;
import won.protocol.model.ConnectionContainer;
import won.protocol.model.ConnectionState;
import won.protocol.model.DatasetHolder;
import won.protocol.model.OwnerApplication;
import won.protocol.model.Socket;
import won.protocol.repository.AtomMessageContainerRepository;
import won.protocol.repository.AtomRepository;
import won.protocol.repository.ConnectionContainerRepository;
import won.protocol.repository.MessageEventRepository;
import won.protocol.repository.OwnerApplicationRepository;
import won.protocol.repository.SocketRepository;
import won.protocol.util.AtomModelWrapper;
import won.protocol.util.RdfUtils;
import won.protocol.vocabulary.WONMSG;

@Component
public class AtomService {
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Autowired
    AtomMessageContainerRepository atomMessageContainerRepository;
    @Autowired
    ConnectionContainerRepository connectionContainerRepository;
    @Autowired
    AtomRepository atomRepository;
    @Autowired
    SocketRepository socketRepository;
    @Autowired
    OwnerApplicationRepository ownerApplicationRepository;
    @Autowired
    MessageEventRepository messageEventRepository;
    @Autowired
    MessageService messageService;
    @Autowired
    URIService uriService;
    @Autowired
    ConnectionService connectionService;
    @Autowired
    EntityManager entityManager;

    public Optional<Atom> getAtomForUpdate(URI atomURI) {
        Optional atom = this.atomRepository.findOneByAtomURIForUpdate(atomURI);
        this.entityManager.refresh(atom.get());
        return atom;
    }

    public Optional<Atom> getAtom(URI atomURI) {
        return this.atomRepository.findOneByAtomURI(atomURI);
    }

    public Optional<Atom> lockAtom(URI atomURI) {
        Optional atom = this.atomRepository.findOneByAtomURIForUpdate(atomURI);
        this.entityManager.refresh(atom.get());
        return atom;
    }

    public Atom lockAtomRequired(URI atomURI) {
        return (Atom)this.atomRepository.findOneByAtomURIForUpdate(atomURI).orElseThrow(() -> new NoSuchAtomException(atomURI));
    }

    public Atom getAtomRequired(URI atomURI) {
        return this.getAtom(atomURI).orElseThrow(() -> new NoSuchAtomException(atomURI));
    }

    public Optional<Atom> getAtomForMessage(WonMessage msg, WonMessageDirection direction) {
        URI socketURI = null;
        URI atomURI = null;
        if (msg.getMessageTypeRequired().isConnectionSpecificMessage()) {
            socketURI = direction.isFromExternal() ? msg.getRecipientSocketURI() : msg.getSenderSocketURI();
            if (socketURI == null) {
                return Optional.empty();
            }
            atomURI = WonMessageUtils.stripFragment((URI)socketURI);
        } else {
            atomURI = msg.getRecipientAtomURI();
        }
        if (atomURI == null) {
            atomURI = msg.getSenderAtomURI();
        }
        if (atomURI != null) {
            return this.getAtom(atomURI);
        }
        return Optional.empty();
    }

    public Atom getAtomForMessageRequired(WonMessage msg, WonMessageDirection direction) {
        URI socketURI = null;
        URI atomURI = null;
        if (msg.getMessageTypeRequired().isConnectionSpecificMessage()) {
            socketURI = direction.isFromExternal() ? msg.getRecipientSocketURIRequired() : msg.getSenderSocketURIRequired();
            atomURI = WonMessageUtils.stripFragment((URI)socketURI);
        } else {
            atomURI = msg.getRecipientAtomURI();
        }
        if (atomURI == null) {
            atomURI = msg.getSenderAtomURI();
        }
        if (atomURI != null) {
            return this.getAtomRequired(atomURI);
        }
        throw new WonMessageProcessingException("Could not obtain atom URI from messsage " + msg.getMessageURI());
    }

    public Atom createAtom(WonMessage wonMessage) {
        wonMessage.getMessageType().requireType(WonMessageType.CREATE_ATOM);
        Dataset atomContent = wonMessage.getMessageContent();
        List attachmentHolders = wonMessage.getAttachments();
        this.removeAttachmentsFromAtomContent(atomContent, attachmentHolders);
        URI messageURI = wonMessage.getMessageURI();
        AtomModelWrapper atomModelWrapper = new AtomModelWrapper(atomContent);
        URI atomURI = this.getAtomURIAndCheck(atomModelWrapper);
        Collection<String> sockets = this.getSocketsAndCheck(atomModelWrapper, atomURI);
        Optional<String> defaultSocket = this.getDefaultSocketAndCheck(atomModelWrapper, sockets);
        Set<Socket> socketEntities = sockets.stream().map(socketUri -> {
            Optional<String> socketType = this.getSocketTypeAndCheck(atomModelWrapper, (String)socketUri);
            Socket f = new Socket();
            f.setAtomURI(atomURI);
            f.setSocketURI(URI.create(socketUri));
            f.setTypeURI(URI.create(socketType.get()));
            if (defaultSocket.isPresent() && socketUri.equals(defaultSocket.get())) {
                f.setDefaultSocket(true);
            }
            return f;
        }).collect(Collectors.toSet());
        this.checkResourcesInAtomContent(atomModelWrapper);
        this.checkCanThisMessageCreateOrModifyThisAtom(wonMessage, atomURI);
        Atom atom = new Atom();
        atom.setState(AtomState.ACTIVE);
        atom.setAtomURI(atomURI);
        atom.setWonNodeURI(URI.create(this.uriService.getResourceURIPrefix()));
        ConnectionContainer connectionContainer = new ConnectionContainer(atom);
        atom.setConnectionContainer(connectionContainer);
        AtomMessageContainer atomMessageContainer = this.atomMessageContainerRepository.findOneByParentUri(atomURI);
        if (atomMessageContainer != null) {
            throw new UriAlreadyInUseException("Found an AtomMessageContainer for the atom we're about to create (" + atomURI + ") - aborting");
        }
        atomMessageContainer = new AtomMessageContainer(atom, atom.getAtomURI());
        atom.setMessageContainer(atomMessageContainer);
        atomModelWrapper.renameResourceWithPrefix(messageURI.toString(), atomURI.toString());
        DatasetHolder datasetHolder = new DatasetHolder(atomURI, atomModelWrapper.getDataset());
        ArrayList<DatasetHolder> attachments = new ArrayList<DatasetHolder>(attachmentHolders.size());
        for (WonMessage.AttachmentHolder attachmentHolder : attachmentHolders) {
            datasetHolder = new DatasetHolder(attachmentHolder.getDestinationUri(), attachmentHolder.getAttachmentDataset());
            attachments.add(datasetHolder);
        }
        atom.setDatatsetHolder(datasetHolder);
        atom.setAttachmentDatasetHolders(attachments);
        atom = (Atom)this.atomRepository.save((Object)atom);
        this.connectionContainerRepository.save((Object)connectionContainer);
        socketEntities.forEach(socket -> {
            Socket cfr_ignored_0 = (Socket)this.socketRepository.save(socket);
        });
        return atom;
    }

    public Atom replaceAtom(WonMessage wonMessage) throws NoSuchAtomException {
        Dataset atomContent = wonMessage.getMessageContent();
        List attachmentHolders = wonMessage.getAttachments();
        this.removeAttachmentsFromAtomContent(atomContent, attachmentHolders);
        AtomModelWrapper atomModelWrapper = new AtomModelWrapper(atomContent);
        URI atomURI = this.getAtomURIAndCheck(atomModelWrapper);
        this.checkCanThisMessageCreateOrModifyThisAtom(wonMessage, atomURI);
        this.checkResourcesInAtomContent(atomModelWrapper);
        Collection<String> sockets = this.getSocketsAndCheck(atomModelWrapper, atomURI);
        this.getDefaultSocketAndCheck(atomModelWrapper, sockets);
        Atom atom = this.getAtomRequired(atomURI);
        URI messageURI = wonMessage.getMessageURI();
        DatasetHolder datasetHolder = atom.getDatatsetHolder();
        Dataset atomDataset = atom.getDatatsetHolder().getDataset();
        Optional<Model> derivationModel = Optional.ofNullable(atomDataset.getNamedModel(atom.getAtomURI() + "#derivedData"));
        ArrayList<DatasetHolder> attachments = new ArrayList<DatasetHolder>(attachmentHolders.size());
        for (WonMessage.AttachmentHolder attachmentHolder : attachmentHolders) {
            datasetHolder = new DatasetHolder(attachmentHolder.getDestinationUri(), attachmentHolder.getAttachmentDataset());
            attachments.add(datasetHolder);
        }
        atomModelWrapper.renameResourceWithPrefix(messageURI.toString(), atomURI.toString());
        List existingSockets = this.socketRepository.findByAtomURI(atomURI);
        Set<Socket> newSocketEntities = this.determineNewSockets(atomURI, existingSockets, atomModelWrapper);
        Set<Socket> removedSockets = this.determineRemovedSockets(atomURI, existingSockets, atomModelWrapper);
        Set<Socket> changedSockets = this.determineAndModifyChangedSockets(atomURI, existingSockets, atomModelWrapper);
        removedSockets.stream().filter(socket -> this.connectionService.existOpenConnections(atomURI, socket.getSocketURI())).findFirst().ifPresent(socket -> new IllegalSocketModificationException("Cannot remove socket " + socket.getSocketURI() + ": socket has connections in state " + ConnectionState.CONNECTED));
        changedSockets.stream().filter(socket -> this.connectionService.existOpenConnections(atomURI, socket.getSocketURI())).findFirst().ifPresent(socket -> new IllegalSocketModificationException("Cannot change socket " + socket.getSocketURI() + ": socket has connections in state " + ConnectionState.CONNECTED));
        this.socketRepository.save(newSocketEntities);
        this.socketRepository.save(changedSockets);
        this.socketRepository.delete(removedSockets);
        if (derivationModel.isPresent()) {
            atomContent.addNamedModel(atom.getAtomURI().toString() + "#derivedData", derivationModel.get());
        }
        datasetHolder.setDataset(atomContent);
        atom.setDatatsetHolder(datasetHolder);
        atom.setAttachmentDatasetHolders(attachments);
        return (Atom)this.atomRepository.save((Object)atom);
    }

    private Set<Socket> determineNewSockets(URI atomURI, List<Socket> existingSockets, AtomModelWrapper atomModelWrapper) {
        Collection sockets = atomModelWrapper.getSocketUris();
        Optional defaultSocket = atomModelWrapper.getDefaultSocket();
        if (sockets.size() == 0) {
            throw new IllegalAtomContentException("at least one property won:socket required ");
        }
        Set<Socket> newSocketEntities = sockets.stream().filter(socketUri -> !existingSockets.stream().anyMatch(socket -> socket.getSocketURI().toString().equals(socketUri))).map(socketUri -> {
            Optional socketType = atomModelWrapper.getSocketType(socketUri);
            if (!socketType.isPresent()) {
                throw new IllegalAtomContentException("cannot determine type of socket " + socketUri);
            }
            Socket f = new Socket();
            f.setAtomURI(atomURI);
            f.setSocketURI(URI.create(socketUri));
            f.setTypeURI(URI.create((String)socketType.get()));
            if (defaultSocket.isPresent() && socketUri.equals(defaultSocket.get())) {
                f.setDefaultSocket(true);
            }
            return f;
        }).collect(Collectors.toSet());
        return newSocketEntities;
    }

    private Set<Socket> determineRemovedSockets(URI atomURI, List<Socket> existingSockets, AtomModelWrapper atomModelWrapper) {
        Collection sockets = atomModelWrapper.getSocketUris();
        return existingSockets.stream().filter(socket -> !sockets.contains(socket.getSocketURI().toString())).collect(Collectors.toSet());
    }

    private Set<Socket> determineAndModifyChangedSockets(URI atomURI, List<Socket> existingSockets, AtomModelWrapper atomModelWrapper) {
        Collection sockets = atomModelWrapper.getSocketUris();
        Optional<URI> defaultSocket = atomModelWrapper.getDefaultSocket().map(f -> URI.create(f));
        return existingSockets.stream().filter(socket -> {
            Optional<URI> newSocketType;
            boolean typeChanged;
            boolean isNowDefaultSocket;
            if (!sockets.contains(socket.getSocketURI().toString())) {
                return false;
            }
            boolean changed = false;
            boolean bl = isNowDefaultSocket = defaultSocket.isPresent() && ((URI)defaultSocket.get()).equals(socket.getSocketURI());
            if (isNowDefaultSocket != socket.isDefaultSocket()) {
                changed = true;
                socket.setDefaultSocket(isNowDefaultSocket);
            }
            boolean bl2 = typeChanged = (newSocketType = atomModelWrapper.getSocketType(socket.getSocketURI().toString()).map(f -> URI.create(f))).isPresent() && !newSocketType.get().equals(socket.getTypeURI());
            if (typeChanged) {
                socket.setTypeURI(newSocketType.get());
                changed = true;
            }
            return changed;
        }).collect(Collectors.toSet());
    }

    private void checkResourcesInAtomContent(AtomModelWrapper atomModelWrapper) {
        String atomURI = atomModelWrapper.getAtomUri();
        String illegalPrefix = atomURI + "/";
        if (RdfUtils.toURIStream((Dataset)atomModelWrapper.getDataset(), (boolean)true).anyMatch(uri -> uri.startsWith(illegalPrefix))) {
            throw new IllegalAtomContentException("URIs in atom content cannot be a sub-paths of the atom URI (i.e., they cannot start with '" + illegalPrefix + "'). If you need URIs for resources in your content, use fragments of the atom URI (i.e., URIs that start with '" + atomURI + "#')");
        }
    }

    private void checkCanThisMessageCreateOrModifyThisAtom(WonMessage wonMessage, URI atomURI) {
        if (!atomURI.equals(wonMessage.getAtomURI())) {
            throw new WrongAddressingInformationException("atomURI of the message (" + wonMessage.getAtomURI() + ") and AtomURI of the content (" + atomURI + ") are not equal", wonMessage.getMessageURI(), new Property[]{WONMSG.atom});
        }
        if (!this.uriService.isAtomURI(atomURI)) {
            throw new IllegalAtomURIException("Atom URI " + atomURI + "does not match this node's prefix " + this.uriService.getAtomResourceURIPrefix());
        }
    }

    private Optional<String> getSocketTypeAndCheck(AtomModelWrapper atomModelWrapper, String socketUri) {
        Optional socketType = atomModelWrapper.getSocketType(socketUri);
        if (!socketType.isPresent()) {
            throw new IllegalAtomContentException("Missing SocketDefinition for socket " + socketUri + ". Add a '[socket] won:socketDefinition [SocketDefinition]' triple!");
        }
        return socketType;
    }

    private Optional<String> getDefaultSocketAndCheck(AtomModelWrapper atomModelWrapper, Collection<String> sockets) {
        Optional defaultSocket = atomModelWrapper.getDefaultSocket();
        if (defaultSocket.isPresent() && !sockets.contains(defaultSocket.get())) {
            throw new IllegalAtomContentException("DefaultSocket must be one of the sockets defined in the atom. This one is not: " + (String)defaultSocket.get());
        }
        return defaultSocket;
    }

    private Collection<String> getSocketsAndCheck(AtomModelWrapper atomModelWrapper, URI atomURI) {
        Collection sockets = atomModelWrapper.getSocketUris();
        sockets.parallelStream().forEach(socketUri -> {
            if (!socketUri.toString().startsWith(atomURI.toString() + "#")) {
                throw new IllegalAtomContentException("Socket URIs must be fragments of atom URIs (i.e. [socketURI] = [atomURI] + '#' + [id]). This rule is violated for atom '" + atomURI + "' and socket '" + socketUri + "'");
            }
            this.getSocketTypeAndCheck(atomModelWrapper, (String)socketUri);
        });
        if (sockets.size() == 0) {
            throw new IllegalAtomContentException("at least one property won:socket required ");
        }
        return sockets;
    }

    private URI getAtomURIAndCheck(AtomModelWrapper atomModelWrapper) {
        URI atomURI;
        String atomURIString = atomModelWrapper.getAtomUri();
        if (atomURIString == null) {
            throw new IllegalAtomContentException("No '[subj] rdf:type won:Atom' triple found in atom content");
        }
        try {
            atomURI = new URI(atomURIString);
        }
        catch (URISyntaxException e) {
            throw new IllegalAtomURIException("Not a valid atom URI: " + atomModelWrapper.getAtomUri());
        }
        if (atomURI.getRawFragment() != null) {
            throw new IllegalAtomURIException("Atom URI must not be a fragment URI (i.e., no trailing '#' + [fragment-id] allowed). This is not allowed: " + atomURI);
        }
        return atomURI;
    }

    public Atom authorizeOwnerApplicationForAtom(String ownerApplicationID, Atom atom) {
        String stopwatchName = this.getClass().getName() + ".authorizeOwnerApplicationForAtom";
        Stopwatch stopwatch = SimonManager.getStopwatch((String)(stopwatchName + "_phase1"));
        Split split = stopwatch.start();
        Optional ownerApplications = this.ownerApplicationRepository.findOneByOwnerApplicationId(ownerApplicationID);
        split.stop();
        stopwatch = SimonManager.getStopwatch((String)(stopwatchName + "_phase2"));
        split = stopwatch.start();
        if (ownerApplications.isPresent()) {
            this.logger.debug("owner application is already known");
            OwnerApplication ownerApplication = (OwnerApplication)ownerApplications.get();
            ArrayList<OwnerApplication> authorizedApplications = atom.getAuthorizedApplications();
            if (authorizedApplications == null) {
                authorizedApplications = new ArrayList<OwnerApplication>(1);
            }
            authorizedApplications.add(ownerApplication);
            atom.setAuthorizedApplications(authorizedApplications);
        } else {
            this.logger.debug("owner application is new - creating");
            ArrayList<OwnerApplication> ownerApplicationList = new ArrayList<OwnerApplication>(1);
            OwnerApplication ownerApplication = new OwnerApplication();
            ownerApplication.setOwnerApplicationId(ownerApplicationID);
            ownerApplication = (OwnerApplication)this.ownerApplicationRepository.save((Object)ownerApplication);
            ownerApplicationList.add(ownerApplication);
            atom.setAuthorizedApplications(ownerApplicationList);
            this.logger.debug("setting OwnerApp ID: " + ownerApplicationList.get(0));
        }
        split.stop();
        stopwatch = SimonManager.getStopwatch((String)(stopwatchName + "_phase3"));
        split = stopwatch.start();
        atom = (Atom)this.atomRepository.save((Object)atom);
        split.stop();
        return atom;
    }

    public void activate(WonMessage wonMessage) throws NoSuchAtomException {
        URI messageURI = wonMessage.getMessageURI();
        URI recipientAtomURI = wonMessage.getRecipientAtomURI();
        wonMessage.getMessageType().requireType(WonMessageType.ACTIVATE);
        this.activate(recipientAtomURI, messageURI);
    }

    public void activate(URI atomURI, URI messageURI) throws NoSuchAtomException {
        this.logger.debug("ACTIVATING atom. atomURI:{}", (Object)atomURI);
        Objects.requireNonNull(atomURI);
        Objects.requireNonNull(messageURI);
        Atom atom = this.getAtomRequired(atomURI);
        this.logger.debug("atom State: " + atom.getState());
        atom.setState(AtomState.ACTIVE);
        this.atomRepository.save((Object)atom);
        this.logger.debug("atom State: " + atom.getState());
    }

    public void deactivate(WonMessage wonMessage) {
        wonMessage.getMessageType().requireType(WonMessageType.DEACTIVATE);
        URI atomURI = wonMessage.getAtomURI();
        URI messageURI = wonMessage.getMessageURI();
        if (atomURI == null) {
            throw new MissingMessagePropertyException(URI.create(WONMSG.atom.toString()));
        }
        this.deactivate(atomURI, messageURI);
    }

    public void deactivate(URI atomURI, URI messageURI) {
        this.logger.debug("DEACTIVATING atom. atomURI:{}", (Object)atomURI);
        Objects.requireNonNull(atomURI);
        Objects.requireNonNull(messageURI);
        Optional<Atom> atom = this.getAtomForUpdate(atomURI);
        this.logger.debug("atom State: " + atom.get().getState());
        atom.get().setState(AtomState.INACTIVE);
        this.atomRepository.save((Object)atom.get());
        this.logger.debug("atom State: " + atom.get().getState());
    }

    public void atomMessageFromSystem(WonMessage wonMessage) {
        URI atomURI = wonMessage.getAtomURI();
        if (atomURI == null) {
            throw new MissingMessagePropertyException(URI.create(WONMSG.atom.getURI()));
        }
    }

    private void removeAttachmentsFromAtomContent(Dataset atomContent, List<WonMessage.AttachmentHolder> attachmentHolders) {
        for (WonMessage.AttachmentHolder attachmentHolder : attachmentHolders) {
            Iterator it = attachmentHolder.getAttachmentDataset().listNames();
            while (it.hasNext()) {
                String modelName = (String)it.next();
                atomContent.removeNamedModel(modelName);
            }
        }
    }
}

