/*
 * Decompiled with CFR 0.152.
 */
package won.node.service.persistence;

import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.Optional;
import javax.persistence.EntityManager;
import org.apache.jena.graph.TripleBoundary;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelExtract;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.StatementBoundary;
import org.apache.jena.rdf.model.StatementTripleBoundary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import won.node.service.persistence.SocketService;
import won.protocol.exception.ConnectionAlreadyExistsException;
import won.protocol.exception.IllegalMessageForAtomStateException;
import won.protocol.exception.IllegalMessageForConnectionStateException;
import won.protocol.exception.IncompatibleSocketsException;
import won.protocol.exception.MissingMessagePropertyException;
import won.protocol.exception.NoSuchAtomException;
import won.protocol.exception.NoSuchConnectionException;
import won.protocol.exception.SocketCapacityException;
import won.protocol.exception.WrongAddressingInformationException;
import won.protocol.message.WonMessage;
import won.protocol.message.WonMessageDirection;
import won.protocol.message.WonMessageType;
import won.protocol.model.Atom;
import won.protocol.model.AtomState;
import won.protocol.model.Connection;
import won.protocol.model.ConnectionEventType;
import won.protocol.model.ConnectionMessageContainer;
import won.protocol.model.ConnectionState;
import won.protocol.model.DatasetHolder;
import won.protocol.model.Socket;
import won.protocol.repository.AtomRepository;
import won.protocol.repository.ConnectionContainerRepository;
import won.protocol.repository.ConnectionMessageContainerRepository;
import won.protocol.repository.ConnectionRepository;
import won.protocol.repository.DatasetHolderRepository;
import won.protocol.repository.MessageEventRepository;
import won.protocol.repository.SocketRepository;
import won.protocol.service.WonNodeInformationService;
import won.protocol.util.DataAccessUtils;
import won.protocol.util.RdfUtils;
import won.protocol.vocabulary.WONCON;
import won.protocol.vocabulary.WONMSG;

@Component
public class ConnectionService {
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Autowired
    ConnectionRepository connectionRepository;
    @Autowired
    SocketService socketService;
    @Autowired
    WonNodeInformationService wonNodeInformationService;
    @Autowired
    AtomRepository atomRepository;
    @Autowired
    SocketRepository socketRepository;
    @Autowired
    ConnectionContainerRepository connectionContainerRepository;
    @Autowired
    ConnectionMessageContainerRepository connectionMessageContainerRepository;
    @Autowired
    DatasetHolderRepository datasetHolderRepository;
    @Autowired
    MessageEventRepository messageEventRepository;
    @Autowired
    EntityManager entityManager;

    public Optional<Connection> getConnection(URI connectionURI) {
        return this.connectionRepository.findOneByConnectionURI(connectionURI);
    }

    public Optional<Connection> getConnection(URI socketURI, URI targetsSocketURI) {
        return this.connectionRepository.findOneBySocketURIAndTargetSocketURI(socketURI, targetsSocketURI);
    }

    public Connection getConnectionRequired(URI socketURI, URI targetSocketURI) {
        return (Connection)this.connectionRepository.findOneBySocketURIAndTargetSocketURI(socketURI, targetSocketURI).orElseThrow(() -> new NoSuchConnectionException(socketURI, targetSocketURI));
    }

    public Connection getConnectionRequired(URI connectionURI) {
        return this.getConnection(connectionURI).orElseThrow(() -> new NoSuchConnectionException(connectionURI));
    }

    public boolean existOpenConnections(URI atom, URI socket) {
        return this.connectionRepository.existsWithtomURIAndSocketURIAndState(atom, socket, ConnectionState.CONNECTED);
    }

    public Connection connectFromOwner(WonMessage wonMessage) throws NoSuchConnectionException, NoSuchAtomException, IllegalMessageForAtomStateException, ConnectionAlreadyExistsException, SocketCapacityException, IncompatibleSocketsException {
        wonMessage.getMessageType().requireType(WonMessageType.CONNECT);
        URI senderAtomURI = wonMessage.getSenderAtomURIRequired();
        URI senderNodeURI = wonMessage.getSenderNodeURIRequired();
        URI recipientAtomURI = wonMessage.getRecipientAtomURIRequired();
        URI senderSocketURI = wonMessage.getSenderSocketURIRequired();
        URI recipientSocketURI = wonMessage.getRecipientSocketURIRequired();
        this.failIfIsNotSocketOfAtom(Optional.of(senderSocketURI), Optional.of(senderAtomURI));
        this.failIfIsNotSocketOfAtom(Optional.of(recipientSocketURI), Optional.of(recipientAtomURI));
        this.logger.debug("connect from owner: processing message {}", (Object)wonMessage.getMessageURI());
        Connection con = this.connectFromOwner(senderAtomURI, senderSocketURI, senderNodeURI, recipientAtomURI, recipientSocketURI);
        return con;
    }

    public Connection connectFromOwner(URI senderAtomURI, URI senderSocketURI, URI senderNodeURI, URI recipientAtomURI, URI recipientSocketURI) throws NoSuchConnectionException, NoSuchAtomException, IllegalMessageForAtomStateException, ConnectionAlreadyExistsException, SocketCapacityException, IncompatibleSocketsException {
        Optional<Connection> con;
        Objects.requireNonNull(senderAtomURI);
        Objects.requireNonNull(senderNodeURI);
        Objects.requireNonNull(recipientAtomURI);
        Objects.requireNonNull(senderSocketURI);
        Objects.requireNonNull(recipientSocketURI);
        Socket actualSocket = this.socketService.getSocket(senderAtomURI, Optional.of(senderSocketURI));
        Optional<URI> actualSocketURI = Optional.of(actualSocket.getSocketURI());
        Optional<URI> actualTargetSocketURI = Optional.of(recipientSocketURI);
        this.failIfIsNotSocketOfAtom(Optional.of(recipientSocketURI), Optional.of(recipientAtomURI));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("connect from owner: loading connection {} - {}", (Object)actualSocketURI.get(), (Object)actualTargetSocketURI.get());
        }
        if (!(con = this.connectionRepository.findOneBySocketURIAndTargetSocketURIForUpdate(actualSocketURI.get(), actualTargetSocketURI.get())).isPresent()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("connect from owner: did not find an existing connection");
            }
            con = Optional.of(this.createConnection(senderAtomURI, recipientAtomURI, actualSocket.getSocketURI(), actualSocket.getTypeURI(), actualTargetSocketURI.get(), Optional.empty(), ConnectionState.REQUEST_SENT, ConnectionEventType.OWNER_CONNECT));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("connect from owner: created new connection {}", (Object)con.get().getConnectionURI());
            }
        } else {
            this.entityManager.refresh(con.get());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("connect from owner: found existing connection {} in state {}", (Object)((Connection)con.get()).getConnectionURI(), (Object)((Connection)con.get()).getState());
            }
        }
        this.failForExceededCapacity(((Connection)con.get()).getSocketURI());
        this.failForIncompatibleSockets(((Connection)con.get()).getSocketURI(), con.get().getTargetSocketURI());
        ConnectionState nextState = con.get().getState().transit(ConnectionEventType.OWNER_CONNECT);
        con.get().changeStateTo(nextState);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("connect from owner: set connection {} state to: {}", (Object)con.get().getConnectionURI(), (Object)con.get().getState());
        }
        return (Connection)this.connectionRepository.save((Object)con.get());
    }

    public Connection connectFromNode(WonMessage wonMessage) {
        wonMessage.getMessageTypeRequired().requireType(WonMessageType.CONNECT);
        URI recipientAtomUri = wonMessage.getRecipientAtomURIRequired();
        URI recipientSocketURI = wonMessage.getRecipientSocketURIRequired();
        URI wonNodeUriFromWonMessage = wonMessage.getRecipientNodeURIRequired();
        URI senderAtomUri = wonMessage.getSenderAtomURIRequired();
        URI senderSocketURI = wonMessage.getSenderSocketURIRequired();
        this.logger.debug("connect from node: processing message {}", (Object)wonMessage.getMessageURI());
        return this.connectFromNode(recipientAtomUri, recipientSocketURI, wonNodeUriFromWonMessage, senderAtomUri, senderSocketURI);
    }

    private Connection connectFromNode(URI recipientAtomUri, URI recipientSocketURI, URI wonNodeUriFromWonMessage, URI senderAtomUri, URI senderSocketURI) {
        Optional conOpt;
        Objects.requireNonNull(recipientAtomUri);
        Objects.requireNonNull(recipientSocketURI);
        Objects.requireNonNull(wonNodeUriFromWonMessage);
        Objects.requireNonNull(senderAtomUri);
        Objects.requireNonNull(senderSocketURI);
        this.failIfIsNotSocketOfAtom(Optional.of(recipientSocketURI), Optional.of(recipientAtomUri));
        Socket socket = this.socketService.getSocket(recipientAtomUri, Optional.of(recipientSocketURI));
        this.failIfIsNotSocketOfAtom(Optional.of(senderSocketURI), Optional.of(senderAtomUri));
        Connection con = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("connect from node: loading connection {} - {}", (Object)socket.getSocketURI(), (Object)senderSocketURI);
        }
        if ((conOpt = this.connectionRepository.findOneBySocketURIAndTargetSocketURIForUpdate(socket.getSocketURI(), senderSocketURI)).isPresent()) {
            this.entityManager.refresh(conOpt.get());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("connect from node: found existing connection {} in state {}", (Object)((Connection)conOpt.get()).getConnectionURI(), (Object)((Connection)conOpt.get()).getState());
            }
            con = (Connection)conOpt.get();
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("connect from node: did not find an existing connection");
        }
        this.failForExceededCapacity(socket.getSocketURI());
        this.failForIncompatibleSockets(socket.getSocketURI(), senderSocketURI);
        if (con == null) {
            con = this.createConnection(recipientAtomUri, senderAtomUri, socket.getSocketURI(), socket.getTypeURI(), senderSocketURI, Optional.empty(), ConnectionState.REQUEST_RECEIVED, ConnectionEventType.PARTNER_CONNECT);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("connect from node: created new connection {}", (Object)con.getConnectionURI());
            }
        }
        ConnectionState nextState = con.getState().transit(ConnectionEventType.PARTNER_CONNECT);
        con.changeStateTo(nextState);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("connect from node: set connection {} state to: {}", (Object)con.getConnectionURI(), (Object)con.getState());
        }
        return (Connection)this.connectionRepository.save((Object)con);
    }

    public Connection socketHint(WonMessage wonMessage) {
        URI recipientAtomURI = wonMessage.getRecipientAtomURIRequired();
        URI recipientWoNNodeURI = wonMessage.getRecipientNodeURIRequired();
        URI targetSocketURI = wonMessage.getHintTargetSocketURIRequired();
        URI recipientSocketURI = wonMessage.getRecipientSocketURIRequired();
        Double score = wonMessage.getHintScore();
        if (targetSocketURI == null) {
            throw new MissingMessagePropertyException(WONMSG.hintTargetSocket);
        }
        if (wonMessage.getHintTargetAtomURI() != null) {
            throw new WrongAddressingInformationException("A SocketHintMessage must not have a msg:hintTargetAtom property", wonMessage.getMessageURI(), new Property[]{WONMSG.hintTargetAtom});
        }
        if (score < 0.0 || score > 1.0) {
            throw new WrongAddressingInformationException("score is not in [0,1]", wonMessage.getMessageURI(), new Property[]{WONMSG.hintScore});
        }
        if (recipientSocketURI == null) {
            throw new MissingMessagePropertyException(WONMSG.recipientSocket);
        }
        if (!this.socketService.isCompatible(recipientSocketURI, targetSocketURI)) {
            throw new IncompatibleSocketsException(recipientSocketURI, targetSocketURI);
        }
        Socket socket = this.socketService.getSocket(recipientAtomURI, Optional.ofNullable(recipientSocketURI));
        URI targetAtomURI = this.socketService.getAtomOfSocketRequired(targetSocketURI);
        Optional con = this.connectionRepository.findOneBySocketURIAndTargetSocketURIForUpdate(socket.getSocketURI(), targetSocketURI);
        if (con.isPresent()) {
            this.entityManager.refresh((Object)con);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("socket hint: connection {} - {} already exists", (Object)((Connection)con.get()).getSocketURI(), (Object)((Connection)con.get()).getTargetSocketURI());
            }
            return (Connection)con.get();
        }
        Connection newCon = this.createConnection(recipientAtomURI, targetAtomURI, recipientSocketURI, socket.getTypeURI(), targetSocketURI, Optional.empty(), ConnectionState.SUGGESTED, ConnectionEventType.MATCHER_HINT);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("socket hint: created connection {}", (Object)newCon.getConnectionURI());
        }
        return newCon;
    }

    public Connection createConnection(URI atomURI, URI otherAtomURI, URI socketURI, URI socketTypeURI, URI targetSocketURI, Optional<URI> targetConnectionURI, ConnectionState connectionState, ConnectionEventType connectionEventType) throws NoSuchAtomException, IllegalMessageForAtomStateException, ConnectionAlreadyExistsException {
        if (atomURI == null) {
            throw new IllegalArgumentException("atomURI is not set");
        }
        if (otherAtomURI == null) {
            throw new IllegalArgumentException("otherAtomURI is not set");
        }
        if (atomURI.equals(otherAtomURI)) {
            throw new IllegalArgumentException("atomURI and otherAtomURI are the same");
        }
        if (socketURI == null) {
            throw new IllegalArgumentException("socketURI is not set");
        }
        if (socketTypeURI == null) {
            throw new IllegalArgumentException("socketTypeURI is not set");
        }
        Optional atom = this.atomRepository.findOneByAtomURIForUpdate(atomURI);
        if (atom.isPresent()) {
            this.entityManager.refresh(atom.get());
        }
        if (((Atom)atom.get()).getState() != AtomState.ACTIVE) {
            throw new IllegalMessageForAtomStateException(atomURI, connectionEventType.name(), ((Atom)atom.get()).getState());
        }
        if (this.socketRepository.findByAtomURIAndTypeURI(atomURI, socketTypeURI).isEmpty()) {
            throw new RuntimeException("Socket '" + socketTypeURI + "' is not supported by Atom: '" + atomURI + "'");
        }
        URI connectionUri = this.wonNodeInformationService.generateConnectionURI(atomURI);
        Connection con = new Connection();
        con.setConnectionURI(connectionUri);
        if (targetConnectionURI.isPresent()) {
            con.setTargetConnectionURI(targetConnectionURI.get());
        }
        con.setAtomURI(atomURI);
        con.setState(connectionState);
        con.setTargetAtomURI(otherAtomURI);
        con.setTypeURI(socketTypeURI);
        con.setSocketURI(socketURI);
        if (targetSocketURI != null) {
            con.setTargetSocketURI(targetSocketURI);
        }
        ConnectionMessageContainer connectionMessageContainer = new ConnectionMessageContainer(con, connectionUri);
        try {
            con = (Connection)this.connectionRepository.save((Object)con);
            this.connectionMessageContainerRepository.save((Object)connectionMessageContainer);
        }
        catch (Exception e) {
            this.logger.warn("caught exception, assuming unique key constraint on atomURI, targetAtomURI, typeURI was violated. Throwing a ConnectionAlreadyExistsException. TODO: think about handling this exception separately", (Throwable)e);
            throw new ConnectionAlreadyExistsException(con.getConnectionURI(), atomURI, otherAtomURI);
        }
        return con;
    }

    public boolean shouldSendAutoOpenForConnect(WonMessage wonMessage) {
        URI recipientSocketURI = wonMessage.getRecipientSocketURIRequired();
        return this.socketService.isAutoOpen(recipientSocketURI);
    }

    public void grabRemoteConnectionURIFromRemoteResponse(WonMessage responseMessage) {
        responseMessage.getMessageType().requireType(WonMessageType.SUCCESS_RESPONSE);
        WonMessageType responseToType = responseMessage.getRespondingToMessageType();
        URI senderURI = responseMessage.getConnectionURIRequired();
        URI senderSocketURI = responseMessage.getSenderSocketURIRequired();
        URI recipientSocketURI = responseMessage.getRecipientSocketURIRequired();
        Optional con = this.connectionRepository.findOneBySocketURIAndTargetSocketURI(recipientSocketURI, senderSocketURI);
        if (con.isPresent() && senderURI != null) {
            ((Connection)con.get()).setTargetConnectionURI(senderURI);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Grabbed targetURI {} for connectionURI {} from success response {}", new Object[]{senderURI, ((Connection)con.get()).getConnectionURI(), responseMessage.getMessageURI()});
            }
            this.connectionRepository.save(con.get());
        }
    }

    public Connection closeFromOwner(WonMessage wonMessage) {
        wonMessage.getMessageType().requireType(WonMessageType.CLOSE);
        return this.close(wonMessage.getSenderSocketURIRequired(), wonMessage.getRecipientSocketURIRequired());
    }

    public Connection closeFromSystem(WonMessage wonMessage) {
        wonMessage.getMessageType().requireType(WonMessageType.CLOSE);
        return this.close(wonMessage.getSenderSocketURIRequired(), wonMessage.getRecipientSocketURIRequired());
    }

    private Connection close(URI socketURI, URI targetSocketURI) {
        Connection con = this.getConnectionRequired(socketURI, targetSocketURI);
        return this.nextConnectionState(con, ConnectionEventType.OWNER_CLOSE);
    }

    private Connection nextConnectionState(URI connectionURI, ConnectionEventType connectionEventType) throws NoSuchConnectionException, IllegalMessageForConnectionStateException {
        if (connectionURI == null) {
            throw new IllegalArgumentException("connectionURI is not set");
        }
        Connection con = DataAccessUtils.loadConnection((ConnectionRepository)this.connectionRepository, (URI)connectionURI);
        ConnectionState nextState = this.performStateTransit(con, connectionEventType);
        con.changeStateTo(nextState);
        return (Connection)this.connectionRepository.save((Object)con);
    }

    public Connection nextConnectionState(Connection con, ConnectionEventType connectionEventType) throws IllegalMessageForConnectionStateException {
        ConnectionState nextState = this.performStateTransit(con, connectionEventType);
        con.changeStateTo(nextState);
        return (Connection)this.connectionRepository.save((Object)con);
    }

    public Connection closeFromNode(WonMessage wonMessage) {
        wonMessage.getMessageType().requireType(WonMessageType.CLOSE);
        return this.close(wonMessage.getRecipientSocketURIRequired(), wonMessage.getSenderSocketURIRequired());
    }

    public void hintFeedbackFromOwner(WonMessage message) {
        message.getMessageType().requireType(WonMessageType.HINT_FEEDBACK_MESSAGE);
        Connection con = this.getConnectionRequired(message.getConnectionURIRequired());
        URI messageURI = message.getMessageURI();
        RdfUtils.visit((Dataset)message.getMessageContent(), model -> {
            Resource baseResource = model.getResource(messageURI.toString());
            if (baseResource.hasProperty(WONCON.feedback)) {
                this.processFeedback(con, (RDFNode)baseResource);
            }
            return null;
        });
    }

    public void processFeedback(Connection connection, RDFNode feedbackNode) {
        if (!feedbackNode.isResource()) {
            this.logger.warn("feedback node is not a resource, cannot process feedback for {}", (Object)connection.getConnectionURI());
            return;
        }
        Resource feedbackRes = (Resource)feedbackNode;
        if (!this.addFeedback(connection, feedbackRes)) {
            this.logger.warn("failed to add feedback to resource {}", (Object)connection.getConnectionURI());
        }
    }

    public boolean addFeedback(Connection connection, Resource feedback) {
        Dataset dataset;
        this.logger.debug("adding feedback to resource {}", (Object)connection);
        DatasetHolder datasetHolder = connection.getDatasetHolder();
        if (datasetHolder == null) {
            dataset = DatasetFactory.create();
            datasetHolder = new DatasetHolder(connection.getConnectionURI(), dataset);
            connection.setDatasetHolder(datasetHolder);
        } else {
            dataset = datasetHolder.getDataset();
        }
        Model model = dataset.getDefaultModel();
        Resource mainRes = model.getResource(connection.getConnectionURI().toString());
        if (mainRes == null) {
            this.logger.debug("could not add feedback to resource {}: resource not found/created in model", (Object)connection.getConnectionURI());
            return false;
        }
        mainRes.addProperty(WONCON.feedbackEvent, (RDFNode)feedback);
        ModelExtract extract = new ModelExtract((StatementBoundary)new StatementTripleBoundary(TripleBoundary.stopNowhere));
        model.add(extract.extract(feedback, feedback.getModel()));
        dataset.setDefaultModel(model);
        datasetHolder.setDataset(dataset);
        this.datasetHolderRepository.save((Object)datasetHolder);
        this.connectionRepository.save((Object)connection);
        this.logger.debug("done adding feedback for resource {}", (Object)connection);
        return true;
    }

    public void updateTargetConnectionURI(Connection con, URI targetConnectionURI) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("updating remote connection URI of con {} to {}", (Object)con, (Object)targetConnectionURI);
        }
        con.setTargetConnectionURI(targetConnectionURI);
        this.connectionRepository.save((Object)con);
    }

    public void failForExceededCapacity(URI socketURI) throws SocketCapacityException {
        Optional<Integer> capacity = this.socketService.getCapacity(socketURI);
        if (capacity.isPresent() && this.connectionRepository.countBySocketURIAndState(socketURI, ConnectionState.CONNECTED) >= (long)capacity.get().intValue()) {
            throw new SocketCapacityException("Connect would exceed socket " + socketURI + " capacity of " + capacity.get());
        }
    }

    public void failForIncompatibleSockets(URI socketURI, URI targetSocketURI) throws IncompatibleSocketsException {
        if (!this.socketService.isCompatible(socketURI, targetSocketURI)) {
            throw new IncompatibleSocketsException(socketURI, targetSocketURI);
        }
    }

    public void failIfIsNotSocketOfAtom(Optional<URI> socketURI, Optional<URI> atomURI) {
        if (socketURI.isPresent() && atomURI.isPresent() && !socketURI.get().toString().startsWith(atomURI.get().toString())) {
            throw new IllegalArgumentException("User-defined socket " + socketURI.get() + " is not a socket of atom " + atomURI.get());
        }
    }

    private ConnectionState performStateTransit(Connection con, ConnectionEventType msg) throws IllegalMessageForConnectionStateException {
        if (!msg.isMessageAllowed(con.getState())) {
            throw new IllegalMessageForConnectionStateException(con.getConnectionURI(), msg.name(), con.getState());
        }
        return con.getState().transit(msg);
    }

    public Connection getConnectionForMessageRequired(WonMessage message, WonMessageDirection direction) {
        return this.getConnectionForMessage(message, direction).orElseThrow(() -> new NoSuchConnectionException(MessageFormat.format("Did not find connection for message {0}, direction {1}", message.getMessageURI(), direction)));
    }

    public Optional<Connection> getConnectionForMessage(WonMessage originalMessage, WonMessageDirection direction) {
        URI socketURI = null;
        URI targetSocketURI = null;
        if (direction.isFromExternal()) {
            socketURI = originalMessage.getRecipientSocketURI();
            targetSocketURI = originalMessage.getSenderSocketURI();
        } else {
            socketURI = originalMessage.getSenderSocketURI();
            targetSocketURI = originalMessage.getRecipientSocketURI();
        }
        if (targetSocketURI != null && socketURI != null) {
            return this.connectionRepository.findOneBySocketURIAndTargetSocketURI(socketURI, targetSocketURI);
        }
        return Optional.empty();
    }
}

