/*
 * Decompiled with CFR 0.152.
 */
package won.node.service.persistence;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;
import won.protocol.exception.DuplicateResponseException;
import won.protocol.exception.IncoherentDatabaseStateException;
import won.protocol.exception.NoSuchMessageException;
import won.protocol.message.WonMessage;
import won.protocol.message.WonMessageDirection;
import won.protocol.message.WonMessageEncoder;
import won.protocol.message.WonMessageType;
import won.protocol.message.WonMessageUtils;
import won.protocol.model.AtomMessageContainer;
import won.protocol.model.Connection;
import won.protocol.model.ConnectionMessageContainer;
import won.protocol.model.DatasetHolder;
import won.protocol.model.MessageContainer;
import won.protocol.model.MessageEvent;
import won.protocol.repository.AtomMessageContainerRepository;
import won.protocol.repository.ConnectionContainerRepository;
import won.protocol.repository.ConnectionMessageContainerRepository;
import won.protocol.repository.ConnectionRepository;
import won.protocol.repository.DatasetHolderRepository;
import won.protocol.repository.MessageContainerRepository;
import won.protocol.repository.MessageEventRepository;

@Component
public class MessageService {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Autowired
    protected ConnectionContainerRepository connectionContainerRepository;
    @Autowired
    protected ConnectionRepository connectionRepository;
    @Autowired
    protected AtomMessageContainerRepository atomMessageContainerRepository;
    @Autowired
    protected MessageContainerRepository messageContainerRepository;
    @Autowired
    protected ConnectionMessageContainerRepository connectionMessageContainerRepository;
    @Autowired
    protected DatasetHolderRepository datasetHolderRepository;
    @Autowired
    private MessageEventRepository messageEventRepository;
    @Autowired
    private EntityManager entityManager;

    public Optional<MessageEvent> getMessage(URI messageURI, URI parentURI) {
        return this.messageEventRepository.findOneByMessageURIAndParentURI(messageURI, parentURI);
    }

    public MessageEvent getMessageRequired(URI messageURI, URI parentURI) {
        return this.getMessage(messageURI, parentURI).orElseThrow(() -> new NoSuchMessageException(messageURI));
    }

    public Optional<URI> getParentofMessage(WonMessage msg, WonMessageDirection direction) {
        WonMessageType type = msg.getMessageTypeRequired();
        Optional<Object> connectionFromResponse = Optional.empty();
        if (type.isResponseMessage()) {
            type = msg.getRespondingToMessageTypeRequired();
            connectionFromResponse = Optional.ofNullable(msg.getConnectionURI());
        }
        if (type.isAtomSpecificMessage()) {
            return WonMessageUtils.getParentAtomUri((WonMessage)msg, (WonMessageDirection)direction);
        }
        if (type.isConnectionSpecificMessage() && !type.isHintMessage()) {
            Optional<Object> ourSocket = Optional.empty();
            Optional<Object> theirSocket = Optional.empty();
            if (direction.isFromExternal()) {
                ourSocket = Optional.ofNullable(msg.getRecipientSocketURIRequired());
                theirSocket = Optional.ofNullable(msg.getSenderSocketURIRequired());
            } else {
                ourSocket = Optional.ofNullable(msg.getSenderSocketURIRequired());
                theirSocket = Optional.ofNullable(msg.getRecipientSocketURIRequired());
            }
            if (ourSocket.isPresent() && theirSocket.isPresent()) {
                Optional con = Optional.empty();
                con = Objects.equals(ourSocket.get(), theirSocket.get()) && connectionFromResponse.isPresent() ? this.connectionRepository.findOneByConnectionURI((URI)connectionFromResponse.get()) : this.connectionRepository.findOneBySocketURIAndTargetSocketURI((URI)ourSocket.get(), (URI)theirSocket.get());
                return con.map(Connection::getConnectionURI);
            }
        }
        return Optional.empty();
    }

    public Optional<URI> getAtomOfMessage(WonMessage message, WonMessageDirection direction) {
        return WonMessageUtils.getParentAtomUri((WonMessage)message, (WonMessageDirection)direction);
    }

    public Optional<URI> getConnectionofMessage(WonMessage msg, WonMessageDirection direction) {
        WonMessageType type = msg.getMessageTypeRequired();
        if (type.isResponseMessage()) {
            type = msg.getRespondingToMessageTypeRequired();
        }
        if (!type.isConnectionSpecificMessage()) {
            return Optional.empty();
        }
        Optional<Object> ourSocket = Optional.empty();
        Optional<Object> theirSocket = Optional.empty();
        if (type.isSocketHintMessage()) {
            ourSocket = Optional.ofNullable(msg.getRecipientSocketURIRequired());
            theirSocket = Optional.ofNullable(msg.getHintTargetSocketURIRequired());
        } else if (direction.isFromExternal()) {
            ourSocket = Optional.ofNullable(msg.getRecipientSocketURIRequired());
            theirSocket = Optional.ofNullable(msg.getSenderSocketURIRequired());
        } else {
            ourSocket = Optional.ofNullable(msg.getSenderSocketURIRequired());
            theirSocket = Optional.ofNullable(msg.getRecipientSocketURIRequired());
        }
        if (ourSocket.isPresent() && theirSocket.isPresent()) {
            return this.connectionRepository.findOneBySocketURIAndTargetSocketURI((URI)ourSocket.get(), (URI)theirSocket.get()).map(Connection::getConnectionURI);
        }
        return Optional.empty();
    }

    private void removeConfirmed(MessageContainer container, WonMessage message, URI parent) {
        StopWatch sw = new StopWatch();
        if (logger.isDebugEnabled()) {
            logger.debug("Checking if message {} confirms any unconfirmed messages in the message container of {}", (Object)message.toShortStringForDebug(), (Object)parent);
        }
        sw.start("get previous URIs from message");
        Set previous = message.getPreviousMessageURIs().stream().collect(Collectors.toSet());
        sw.stop();
        if (logger.isDebugEnabled()) {
            logger.debug("{} previous messages referenced by external response {} ", (Object)previous.size(), (Object)message.toShortStringForDebug());
            logger.debug("previous messages: {}", previous);
        }
        if (previous.isEmpty()) {
            logger.debug("no previous messages found, not removing any unconfirmed messages");
            return;
        }
        sw.start("load pending");
        Map pending = container.getPendingConfirmations();
        sw.stop();
        sw.start("determine confirmed");
        Set confirmed = pending.entrySet().stream().filter(e -> previous.contains(e.getKey())).flatMap(e -> ((Set)e.getValue()).stream()).collect(Collectors.toSet());
        sw.stop();
        if (logger.isDebugEnabled()) {
            logger.debug("{} unconfirmed for message container of {}, removing {} transitively confirmed", new Object[]{container.getUnconfirmedCount(), parent, confirmed.size()});
            logger.debug("unconfirmed: {}", (Object)container.peekAtUnconfirmed());
            logger.debug("transitively confirmed: {}", confirmed);
        }
        sw.start("remove unconfirmed");
        container.removeUnconfirmed(confirmed);
        sw.stop();
        sw.start("remove pending");
        container.removePendingConfirmations(previous);
        sw.stop();
        if (logger.isDebugEnabled()) {
            logger.debug("{} messages left in unconfirmed list of the message container of {}", new Object[]{container.getUnconfirmedCount(), parent});
        }
        logger.debug("removing confirmed took {} millis", (Object)sw.getLastTaskTimeMillis());
        if (logger.isDebugEnabled()) {
            logger.debug("Timinig info: \n{}", (Object)sw.prettyPrint());
        }
    }

    public void saveMessage(WonMessage messageOrDeliveryChain, URI parent) {
        StopWatch sw = new StopWatch();
        for (WonMessage wonMessage : messageOrDeliveryChain.getAllMessages()) {
            logger.debug("STORING {} message {} under parent {}", new Object[]{wonMessage.getMessageType(), wonMessage.getMessageURI(), parent});
            sw.start("get message container");
            MessageContainer container = this.loadOrCreateMessageContainer(parent, wonMessage.getMessageType());
            sw.stop();
            if (wonMessage.getMessageTypeRequired().isSuccessResponse()) {
                Optional duplicate;
                sw.start("check for duplicate response");
                URI respondingTo = wonMessage.getRespondingToMessageURIRequired();
                URI responseContainer = wonMessage.getAtomURI();
                if (responseContainer == null) {
                    responseContainer = wonMessage.getConnectionURIRequired();
                }
                if ((duplicate = this.messageEventRepository.findOneByParentURIAndRespondingToURIAndResponseContainerURI(parent, respondingTo, responseContainer)).isPresent()) {
                    logger.debug("Detected duplicate response to {} from container {} in container {}: {}", new Object[]{respondingTo, responseContainer, parent, wonMessage.toShortStringForDebug()});
                    throw new DuplicateResponseException(MessageFormat.format("Detected duplicate response to {0} from container {1} in container {2}: {3}", respondingTo, responseContainer, parent, wonMessage.toShortStringForDebug()));
                }
                sw.stop();
            }
            if (this.isExternalSuccessResponseInConnection(parent, wonMessage)) {
                sw.start("process external response in connection");
                if (logger.isDebugEnabled()) {
                    logger.debug("In connection, processing external response {} to {} in container {}", new Object[]{wonMessage.toShortStringForDebug(), wonMessage.getRespondingToMessageURI(), parent});
                }
                this.removeConfirmed(container, wonMessage, parent);
                if (logger.isDebugEnabled()) {
                    logger.debug("Adding as unconfirmed message: {} in container {}", (Object)wonMessage.getMessageURIRequired(), (Object)parent);
                }
                this.addUnconfirmed(container, wonMessage);
                sw.stop();
            } else if (this.isOwnSuccessResponseInConnection(parent, wonMessage)) {
                List previous;
                sw.start("process own response in connection's message container");
                if (logger.isDebugEnabled()) {
                    logger.debug("In connection, processing own response {} to {} in container {}", new Object[]{wonMessage.toShortStringForDebug(), wonMessage.getRespondingToMessageURI(), parent});
                }
                if (!(previous = wonMessage.getPreviousMessageURIs()).isEmpty()) {
                    container.addPendingConfirmation(wonMessage.getMessageURIRequired(), previous.stream().collect(Collectors.toSet()));
                }
                sw.stop();
            } else if (this.isOwnSuccessResponseInAtom(parent, wonMessage)) {
                sw.start("process own response in atom's message container");
                this.removeConfirmed(container, wonMessage, parent);
                if (logger.isDebugEnabled()) {
                    logger.debug("Adding as unconfirmed message: {} in container {}", (Object)wonMessage.getMessageURIRequired(), (Object)parent);
                }
                this.addUnconfirmed(container, wonMessage);
                sw.stop();
            }
            sw.start("create event");
            MessageEvent event = new MessageEvent(parent, wonMessage, container);
            sw.stop();
            sw.start("get event dataset id (if any)");
            Optional datasetHolderId = this.datasetHolderRepository.findIdByUri(wonMessage.getMessageURIRequired());
            sw.stop();
            sw.start("Add dataset to message");
            if (datasetHolderId.isPresent()) {
                DatasetHolder datasetHolder = (DatasetHolder)this.entityManager.getReference(DatasetHolder.class, datasetHolderId.get());
                event.setDatasetHolder(datasetHolder);
            } else {
                event.setDatasetHolder(new DatasetHolder(wonMessage.getMessageURI(), WonMessageEncoder.encodeAsDataset((WonMessage)wonMessage)));
            }
            sw.stop();
            sw.start("store message");
            event = (MessageEvent)this.messageEventRepository.save((Object)event);
            sw.stop();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Timing info:\n{}", (Object)sw.prettyPrint());
        }
    }

    private void addUnconfirmed(MessageContainer container, WonMessage toAdd) {
        container.addUnconfirmed(toAdd.getMessageURIRequired());
    }

    public boolean isOwnSuccessResponseInAtom(URI parent, WonMessage wonMessage) {
        return wonMessage.getAtomURI() != null && Objects.equals(parent, wonMessage.getAtomURI()) && wonMessage.getEnvelopeType().isFromSystem() && wonMessage.getMessageTypeRequired().isSuccessResponse() && wonMessage.getRespondingToMessageTypeRequired().isAtomSpecificMessage();
    }

    public boolean isExternalSuccessResponseInConnection(URI parent, WonMessage wonMessage) {
        return wonMessage.getConnectionURI() != null && !Objects.equals(parent, wonMessage.getConnectionURI()) && wonMessage.getEnvelopeType().isFromSystem() && wonMessage.getMessageTypeRequired().isSuccessResponse() && wonMessage.getRespondingToMessageTypeRequired().isConnectionSpecificMessage();
    }

    public boolean isOwnSuccessResponseInConnection(URI parent, WonMessage wonMessage) {
        return wonMessage.getConnectionURI() != null && Objects.equals(parent, wonMessage.getConnectionURI()) && wonMessage.getEnvelopeType().isFromSystem() && wonMessage.getMessageTypeRequired().isSuccessResponse() && wonMessage.getRespondingToMessageTypeRequired().isConnectionSpecificMessage();
    }

    public MessageContainer loadOrCreateMessageContainer(URI parent, WonMessageType messageType) {
        if (WonMessageType.CREATE_ATOM.equals((Object)messageType)) {
            AtomMessageContainer container = this.atomMessageContainerRepository.findOneByParentUri(parent);
            if (container != null) {
                return container;
            }
            AtomMessageContainer nec = new AtomMessageContainer(null, parent);
            nec = (AtomMessageContainer)this.atomMessageContainerRepository.save((Object)nec);
            return (MessageContainer)this.atomMessageContainerRepository.findOne((Serializable)nec.getId());
        }
        if (WonMessageType.CONNECT.equals((Object)messageType) || WonMessageType.SOCKET_HINT_MESSAGE.equals((Object)messageType)) {
            ConnectionMessageContainer container = this.connectionMessageContainerRepository.findOneByParentUri(parent);
            if (container != null) {
                return container;
            }
            ConnectionMessageContainer cec = new ConnectionMessageContainer(null, parent);
            cec = (ConnectionMessageContainer)this.connectionMessageContainerRepository.save((Object)cec);
            return (MessageContainer)this.connectionMessageContainerRepository.findOne((Serializable)cec.getId());
        }
        Optional mc = this.messageContainerRepository.findOneByParentUri(parent);
        return (MessageContainer)mc.orElseThrow(() -> new IncoherentDatabaseStateException("Cannot store '" + messageType + "' event: unable to find event container with parent URI '" + parent + "'"));
    }
}

