/*
 * Decompiled with CFR 0.152.
 */
package won.node.service.persistence;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import won.protocol.model.OwnerApplication;
import won.protocol.repository.OwnerApplicationRepository;
import won.protocol.service.ApplicationManagementService;

@Component
public class OwnerManagementService
implements ApplicationManagementService {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Autowired
    private OwnerApplicationRepository ownerApplicationRepository;

    public String registerOwnerApplication(String ownerApplicationId) {
        logger.debug("ownerApplicationId: " + ownerApplicationId.toString());
        if (!this.ownerApplicationRepository.findOneByOwnerApplicationId(ownerApplicationId).isPresent()) {
            logger.info("Registering owner application for the first time with id: {}", (Object)ownerApplicationId);
            OwnerApplication ownerApplication = new OwnerApplication();
            ownerApplication.setOwnerApplicationId(ownerApplicationId.toString());
            ownerApplication = (OwnerApplication)this.ownerApplicationRepository.save((Object)ownerApplication);
            List<String> queueNames = this.generateQueueNamesForOwnerApplication(ownerApplication);
            ownerApplication.setQueueNames(queueNames);
            ownerApplication = (OwnerApplication)this.ownerApplicationRepository.save((Object)ownerApplication);
            return ownerApplicationId;
        }
        logger.info("Registering already known owner application with id: {}", (Object)ownerApplicationId);
        return ownerApplicationId;
    }

    public List<String> generateQueueNamesForOwnerApplication(OwnerApplication ownerApplication) {
        logger.debug(ownerApplication.getOwnerApplicationId());
        ArrayList<String> queueNames = new ArrayList<String>();
        queueNames.add("activemq:queue:OwnerProtocol.Out." + ownerApplication.getOwnerApplicationId());
        ownerApplication.setQueueNames(queueNames);
        return ownerApplication.getQueueNames();
    }

    public String getEndpointForMessage(String methodName, String ownerApplicationID) {
        OwnerApplication ownerApplication = (OwnerApplication)this.ownerApplicationRepository.findOneByOwnerApplicationId(ownerApplicationID).get();
        List queueNames = ownerApplication.getQueueNames();
        String endpoint = "";
        for (int i = 0; i < queueNames.size(); ++i) {
            endpoint = (String)queueNames.get(i);
            if (((String)queueNames.get(i)).contains(methodName)) break;
        }
        return endpoint;
    }
}

