/*
 * Decompiled with CFR 0.152.
 */
package won.node.service.persistence;

import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import won.node.service.linkeddata.lookup.SocketLookup;
import won.protocol.exception.NoAtomForSocketFoundException;
import won.protocol.exception.NoDefaultSocketException;
import won.protocol.exception.NoSuchAtomException;
import won.protocol.exception.NoSuchSocketException;
import won.protocol.model.Socket;
import won.protocol.model.SocketDefinition;
import won.protocol.repository.AtomRepository;
import won.protocol.repository.SocketRepository;

@Component
public class SocketService {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    AtomRepository atomRepository;
    @Autowired
    SocketRepository socketRepository;
    Map<URI, SocketDefinition> knownSockets = new HashMap<URI, SocketDefinition>();
    @Autowired
    SocketLookup socketLookup;

    public Optional<Socket> getDefaultSocket(URI atomUri) throws NoSuchAtomException {
        List sockets = this.socketRepository.findByAtomURI(atomUri);
        for (Socket socket : sockets) {
            if (!socket.isDefaultSocket()) continue;
            return Optional.of(socket);
        }
        return sockets.stream().findFirst();
    }

    public Socket getSocket(URI atomUri, Optional<URI> socketUri) throws IllegalArgumentException, NoSuchAtomException {
        if (socketUri.isPresent()) {
            return (Socket)this.socketRepository.findOneBySocketURI(socketUri.get()).orElseThrow(() -> new NoSuchSocketException((URI)socketUri.get()));
        }
        return this.getDefaultSocket(atomUri).orElseThrow(() -> new NoDefaultSocketException(atomUri));
    }

    public Optional<URI> getAtomOfSocket(URI socketURI) {
        if (socketURI == null) {
            return Optional.empty();
        }
        String uri = socketURI.toString();
        String fragment = socketURI.getRawFragment();
        if (fragment == null) {
            return Optional.empty();
        }
        return Optional.of(URI.create(uri.substring(0, uri.length() - fragment.length() - 1)));
    }

    public URI getAtomOfSocketRequired(URI socketURI) {
        return this.getAtomOfSocket(socketURI).orElseThrow(() -> new NoAtomForSocketFoundException(socketURI));
    }

    public Optional<Socket> getSocket(URI socketURI) {
        return this.socketRepository.findOneBySocketURI(socketURI);
    }

    public Socket getSocketRequired(URI socketURI) {
        return this.getSocket(socketURI).orElseThrow(() -> new NoSuchSocketException(socketURI));
    }

    public Optional<SocketDefinition> getSocketConfig(URI socketType) {
        return this.socketLookup.getSocketConfig(socketType);
    }

    public Optional<Integer> getCapacity(URI localSocket) {
        Optional socket = this.socketRepository.findOneBySocketURI(localSocket);
        if (!socket.isPresent()) {
            throw new NoSuchSocketException(localSocket);
        }
        return this.socketLookup.getCapacityOfType(((Socket)socket.get()).getTypeURI());
    }

    public boolean isCompatible(URI localSocket, URI targetSocket) {
        Optional socket = this.socketRepository.findOneBySocketURI(localSocket);
        if (!socket.isPresent()) {
            throw new NoSuchSocketException(localSocket);
        }
        Optional target = this.socketRepository.findOneBySocketURI(targetSocket);
        Optional<Object> targetType = Optional.empty();
        targetType = target.isPresent() ? Optional.of(((Socket)target.get()).getTypeURI()) : this.socketLookup.getSocketType(targetSocket);
        if (targetType.isPresent()) {
            return this.socketLookup.isCompatibleSocketTypes(((Socket)socket.get()).getTypeURI(), (URI)targetType.get());
        }
        return false;
    }

    public boolean isAutoOpen(URI localSocket) {
        Optional socket = this.socketRepository.findOneBySocketURI(localSocket);
        if (!socket.isPresent()) {
            throw new NoSuchSocketException(localSocket);
        }
        return this.socketLookup.isAutoOpenSocketType(((Socket)socket.get()).getTypeURI());
    }

    public Optional<URI> getSocketType(URI socketURI) {
        return this.socketLookup.getSocketType(socketURI);
    }
}

