/*
 * Decompiled with CFR 0.152.
 */
package won.node.springsecurity;

import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import won.node.springsecurity.ClientCertificateNoWebIdUserDetails;

public class ClientCertificateNoWebIdUserDetailsService
implements AuthenticationUserDetailsService<PreAuthenticatedAuthenticationToken> {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public UserDetails loadUserDetails(PreAuthenticatedAuthenticationToken token) throws UsernameNotFoundException {
        String principal = (String)token.getPrincipal();
        Certificate certificate = (Certificate)token.getCredentials();
        logger.debug("Adding userDetails for '" + principal + "'");
        URI commonName = null;
        try {
            commonName = new URI(principal);
        }
        catch (URISyntaxException e) {
            throw new BadCredentialsException("Principal of X.509 Certificate must be a WebId URI. Actual value: '" + principal + "'");
        }
        ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>(3);
        authorities.add((GrantedAuthority)new SimpleGrantedAuthority("ROLE_CLIENT_CERTIFICATE_PRESENTED"));
        return new ClientCertificateNoWebIdUserDetails(commonName, authorities);
    }
}

