/*
 * Decompiled with CFR 0.152.
 */
package won.node.springsecurity;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.util.StopWatch;
import won.cryptography.webid.AccessControlRules;
import won.node.springsecurity.WebIdUserDetails;
import won.node.springsecurity.WonDefaultAccessControlRules;

public class DefaultWoNAccessDecisionVoter
implements AccessDecisionVoter {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Autowired
    AccessControlRules defaultAccessControlRules;

    public boolean supports(ConfigAttribute attribute) {
        return true;
    }

    public boolean supports(Class clazz) {
        return FilterInvocation.class.equals((Object)clazz);
    }

    public int vote(Authentication authentication, Object object, Collection collection) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        if (!(authentication instanceof PreAuthenticatedAuthenticationToken)) {
            return 0;
        }
        Object principal = authentication.getPrincipal();
        if (!(principal instanceof WebIdUserDetails)) {
            return 0;
        }
        WebIdUserDetails userDetails = (WebIdUserDetails)principal;
        if (!(object instanceof FilterInvocation)) {
            return 0;
        }
        String webId = userDetails.getUsername();
        String resource = ((FilterInvocation)object).getRequest().getRequestURL().toString();
        if (authentication.getAuthorities().stream().map(GrantedAuthority::getAuthority).filter(r -> "ROLE_WEBID".equals(r)).findAny().isPresent()) {
            ArrayList<String> webIDs = new ArrayList<String>(1);
            webIDs.add(webId);
            if (this.defaultAccessControlRules.isAccessPermitted(resource, webIDs)) {
                stopWatch.stop();
                logger.debug("access control check took " + stopWatch.getLastTaskTimeMillis() + " millis");
                return 1;
            }
            return -1;
        }
        return -1;
    }

    public void setDefaultAccessControlRules(WonDefaultAccessControlRules defaultAccessControlRules) {
        this.defaultAccessControlRules = defaultAccessControlRules;
    }
}

