/*
 * Decompiled with CFR 0.152.
 */
package won.node.springsecurity;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.authentication.preauth.x509.SubjectDnX509PrincipalExtractor;
import org.springframework.security.web.authentication.preauth.x509.X509PrincipalExtractor;

public class ReverseProxyCompatibleX509AuthenticationFilter
extends AbstractPreAuthenticatedProcessingFilter {
    private final boolean behindProxy;
    private X509PrincipalExtractor principalExtractor = new SubjectDnX509PrincipalExtractor();

    public ReverseProxyCompatibleX509AuthenticationFilter(boolean behindProxy) {
        this.behindProxy = behindProxy;
    }

    protected Object getPreAuthenticatedPrincipal(HttpServletRequest request) {
        X509Certificate cert = this.extractClientCertificate(request);
        if (cert == null) {
            return null;
        }
        return this.principalExtractor.extractPrincipal(cert);
    }

    protected Object getPreAuthenticatedCredentials(HttpServletRequest request) {
        return this.extractClientCertificate(request);
    }

    private X509Certificate extractClientCertificate(HttpServletRequest request) {
        X509Certificate[] certificateChainObj = null;
        if (this.behindProxy) {
            CertificateFactory certificateFactory = null;
            try {
                certificateFactory = CertificateFactory.getInstance("X.509");
            }
            catch (CertificateException e) {
                throw new InternalAuthenticationServiceException("could not extract certificate from request", (Throwable)e);
            }
            String certificateHeader = request.getHeader("X-Client-Certificate");
            if (certificateHeader == null) {
                throw new AuthenticationCredentialsNotFoundException("No HTTP header 'X-Client-Certificate' set that contains client authentication certificate! If property 'client.authentication.behind.proxy' is set to true, this header must be set by the reverse proxy!");
            }
            String certificateContent = certificateHeader.replaceAll("(?<!-----BEGIN|-----END)\\s+", System.lineSeparator()).replaceAll("\\t+", System.lineSeparator());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("found this certificate in the X-Client-Certificate header: " + certificateHeader));
                this.logger.debug((Object)("found this certificate in the X-Client-Certificate header (after whitespace replacement): " + certificateContent));
            }
            X509Certificate[] userCertificate = new X509Certificate[1];
            try {
                userCertificate[0] = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(certificateContent.getBytes("ISO-8859-11")));
            }
            catch (CertificateException e) {
                throw new AuthenticationCredentialsNotFoundException("could not extract certificate from request", (Throwable)e);
            }
            catch (UnsupportedEncodingException e) {
                throw new AuthenticationCredentialsNotFoundException("could not extract certificate from request with encoding ISO-8859-11", (Throwable)e);
            }
            certificateChainObj = userCertificate;
        } else {
            certificateChainObj = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
            if (certificateChainObj == null) {
                throw new AuthenticationCredentialsNotFoundException("Client certificate attribute is null! Check if you are behind a proxy server that takes care about the client authentication already. If so, set the property 'client.authentication.behind.proxy' to true and make sure the proxy sets the HTTP header 'X-Client-Certificate' appropriately to the sent client certificate");
            }
        }
        return certificateChainObj[0];
    }

    public void setPrincipalExtractor(X509PrincipalExtractor principalExtractor) {
        this.principalExtractor = principalExtractor;
    }
}

