/*
 * Decompiled with CFR 0.152.
 */
package won.node.springsecurity;

import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.util.StopWatch;
import won.cryptography.webid.WebIDVerificationAgent;
import won.node.springsecurity.WebIdUserDetails;

public class WebIdUserDetailsService
implements AuthenticationUserDetailsService<PreAuthenticatedAuthenticationToken> {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Autowired
    private WebIDVerificationAgent webIDVerificationAgent;

    public UserDetails loadUserDetails(PreAuthenticatedAuthenticationToken token) throws UsernameNotFoundException {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        String principal = (String)token.getPrincipal();
        Certificate certificate = (Certificate)token.getCredentials();
        logger.debug("Adding userDetails for '" + principal + "'");
        URI webID = null;
        try {
            webID = new URI(principal);
        }
        catch (URISyntaxException e) {
            throw new BadCredentialsException("Principal of X.509 Certificate must be a WebId URI. Actual value: '" + principal + "'");
        }
        ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>(3);
        authorities.add((GrantedAuthority)new SimpleGrantedAuthority("ROLE_CLIENT_CERTIFICATE_PRESENTED"));
        logger.debug("verifying webId '" + principal + "'");
        try {
            if (this.webIDVerificationAgent.verify(certificate.getPublicKey(), webID)) {
                authorities.add((GrantedAuthority)new SimpleGrantedAuthority("ROLE_WEBID"));
                logger.debug("webId '" + principal + "' successfully verified - ROLE_WEBID granted");
            } else {
                logger.debug("could not verify webId '" + principal + "'. ROLE_WEBID not granted");
            }
        }
        catch (Exception e) {
            logger.debug("could not verify webId '" + principal + "' because of an error during verification. ROLE_WEBID not granted. Cause is logged", (Throwable)e);
        }
        stopWatch.stop();
        logger.debug("webID check took " + stopWatch.getLastTaskTimeMillis() + " millis");
        return new WebIdUserDetails(webID, authorities);
    }
}

