/*
 * Decompiled with CFR 0.152.
 */
package won.node.springsecurity;

import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import won.cryptography.webid.AccessControlRules;
import won.node.service.nodeconfig.URIService;
import won.protocol.repository.AtomMessageContainerRepository;
import won.protocol.repository.ConnectionMessageContainerRepository;
import won.protocol.repository.MessageEventRepository;

public class WonDefaultAccessControlRules
implements AccessControlRules {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Autowired
    protected MessageEventRepository messageEventRepository;
    @Autowired
    protected AtomMessageContainerRepository atomMessageContainerRepository;
    @Autowired
    protected ConnectionMessageContainerRepository connectionMessageContainerRepository;
    @Autowired
    protected URIService uriService;

    public boolean isAccessPermitted(String resourceUriString, List<String> requesterWebIDs) {
        URI resourceUri = this.uriService.toResourceURIIfPossible(URI.create(resourceUriString));
        String firstWebId = requesterWebIDs.get(0);
        if (requesterWebIDs.size() > 1) {
            logger.warn("received more than 1 requester webids, only using first one: ", (Object)firstWebId);
        }
        URI webId = URI.create(firstWebId);
        if (this.uriService.isEventURI(resourceUri)) {
            if (logger.isDebugEnabled()) {
                logger.debug("checking access for event {} with webID {} ({} of {})", new Object[]{resourceUri, firstWebId, 1, requesterWebIDs.size()});
            }
            URI messageUri = this.uriService.toGenericMessageURI(resourceUri);
            return this.messageEventRepository.isReadPermittedForWebID(messageUri, webId);
        }
        if (this.uriService.isConnectionEventsURI(resourceUri)) {
            if (logger.isDebugEnabled()) {
                logger.debug("checking access for connectionEvent{} with webID {} ({} of {})", new Object[]{resourceUri, firstWebId, 1, requesterWebIDs.size()});
            }
            return this.connectionMessageContainerRepository.isReadPermittedForWebID(this.uriService.getConnectionURIofConnectionEventsURI(resourceUri), webId);
        }
        if (this.uriService.isAtomEventsURI(resourceUri)) {
            if (logger.isDebugEnabled()) {
                logger.debug("checking access for atomEvent {} with webID {} ({} of {})", new Object[]{resourceUri, firstWebId, 1, requesterWebIDs.size()});
            }
            return this.atomMessageContainerRepository.isReadPermittedForWebID(this.uriService.getAtomURIofAtomEventsURI(resourceUri), webId);
        }
        if (this.uriService.isAtomUnreadURI(resourceUri)) {
            if (logger.isDebugEnabled()) {
                logger.debug("checking access for unreadEventsRequest {} with webID {} ({} of {})", new Object[]{resourceUri, firstWebId, 1, requesterWebIDs.size()});
            }
            return webId.equals(this.uriService.getAtomURIofAtomUnreadURI(resourceUri));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("request could not be categorized, denying: {} with webID {} ({} of {})", new Object[]{resourceUri, firstWebId, 1, requesterWebIDs.size()});
        }
        return false;
    }
}

