/*
 * Decompiled with CFR 0.152.
 */
package at.unbounded.event;

import at.unbounded.event.Event;
import at.unbounded.event.EventHandler;
import at.unbounded.event.EventHandlerMethod;
import at.unbounded.event.EventListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class EventBus {
    private volatile Map<Class<?>, Map<Byte, Map<EventListener, Method[]>>> unbakedListener = new HashMap();
    private volatile Map<Class<?>, EventHandlerMethod[]> bakedListener = new ConcurrentHashMap();
    private final Lock lock = new ReentrantLock();

    public void call(Event event) {
        EventHandlerMethod[] handlers = this.bakedListener.get(event.getClass());
        if (handlers != null) {
            for (EventHandlerMethod method : handlers) {
                try {
                    method.invoke(event);
                }
                catch (IllegalAccessException ex) {
                    throw new Error("Can't call method, change to public");
                }
                catch (IllegalArgumentException ex) {
                    throw new Error("Method has to much arguments");
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        }
    }

    private void bake(Class<?> event) {
        Map<Byte, Map<EventListener, Method[]>> priorityListenerHandlers = this.unbakedListener.get(event);
        if (priorityListenerHandlers != null) {
            ArrayList<EventHandlerMethod> handlers = new ArrayList<EventHandlerMethod>(priorityListenerHandlers.size() * 2);
            byte value = 5;
            do {
                Map<EventListener, Method[]> listenerHandlers;
                if ((listenerHandlers = priorityListenerHandlers.get(value)) == null) continue;
                for (Map.Entry<EventListener, Method[]> listenerHandlersEntry : listenerHandlers.entrySet()) {
                    for (Method method : listenerHandlersEntry.getValue()) {
                        EventHandlerMethod handler = new EventHandlerMethod(listenerHandlersEntry.getKey(), method);
                        handlers.add(handler);
                    }
                }
            } while ((value = (byte)(value - 1)) > -5);
            this.bakedListener.put(event, handlers.toArray(new EventHandlerMethod[handlers.size()]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(EventListener listener) {
        Map<Class<?>, Map<Byte, Set<Method>>> handlers = EventBus.research(listener);
        try {
            this.lock.lock();
            for (Map.Entry<Class<?>, Map<Byte, Set<Method>>> handlersEntry : handlers.entrySet()) {
                Map<Byte, Map<EventListener, Method[]>> priorities = this.unbakedListener.get(handlersEntry.getKey());
                if (priorities == null) {
                    priorities = new HashMap<Byte, Map<EventListener, Method[]>>();
                    this.unbakedListener.put(handlersEntry.getKey(), priorities);
                }
                for (Map.Entry<Byte, Set<Method>> prioritiesEntry : handlersEntry.getValue().entrySet()) {
                    Map<EventListener, Method[]> priority = priorities.get(prioritiesEntry.getKey());
                    if (priority == null) {
                        priority = new HashMap<EventListener, Method[]>();
                        priorities.put(prioritiesEntry.getKey(), priority);
                    }
                    priority.put(listener, prioritiesEntry.getValue().toArray(new Method[prioritiesEntry.getValue().size()]));
                }
                this.bake(handlersEntry.getKey());
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(EventListener listener) {
        Map<Class<?>, Map<Byte, Set<Method>>> handlers = EventBus.research(listener);
        try {
            this.lock.lock();
            for (Map.Entry<Class<?>, Map<Byte, Set<Method>>> handlersEntry : handlers.entrySet()) {
                Map<Byte, Map<EventListener, Method[]>> priorities = this.unbakedListener.get(handlersEntry.getKey());
                if (priorities != null) {
                    for (Byte prioritiesEntry : handlersEntry.getValue().keySet()) {
                        Map<EventListener, Method[]> priority = priorities.get(prioritiesEntry);
                        if (priority == null) continue;
                        priority.remove(listener);
                        if (!priority.isEmpty()) continue;
                        priorities.remove(prioritiesEntry);
                    }
                    if (priorities.isEmpty()) {
                        this.unbakedListener.remove(handlersEntry.getKey());
                    }
                }
                this.bake(handlersEntry.getKey());
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private static Map<Class<?>, Map<Byte, Set<Method>>> research(EventListener listener) {
        HashMap handlers = new HashMap();
        for (Method method : listener.getClass().getDeclaredMethods()) {
            HashSet<Method> priority;
            Class<?>[] parameters;
            EventHandler annotation = method.getAnnotation(EventHandler.class);
            if (annotation == null || (parameters = method.getParameterTypes()).length != 1) continue;
            HashMap<Byte, HashSet<Method>> priorities = (HashMap<Byte, HashSet<Method>>)handlers.get(parameters[0]);
            if (priorities == null) {
                priorities = new HashMap<Byte, HashSet<Method>>();
                handlers.put(parameters[0], priorities);
            }
            if ((priority = (HashSet<Method>)priorities.get(annotation.priority().getPriority())) == null) {
                priority = new HashSet<Method>();
                priorities.put(annotation.priority().getPriority(), priority);
            }
            priority.add(method);
        }
        return handlers;
    }
}

