/*
 * Decompiled with CFR 0.152.
 */
package at.unbounded.mathematic;

public final class Mathematic {
    public static final double PI = Math.PI;
    public static final double PI2 = Math.PI * 2;

    private Mathematic() {
    }

    public static int clamp(int value, int min, int max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static float clamp(float value, float min, float max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static double clamp(double value, double min, double max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static int abs(int value) {
        return value >= 0 ? value : -value;
    }

    public static float abs(float value) {
        return value >= 0.0f ? value : -value;
    }

    public static double abs(double value) {
        return value >= 0.0 ? value : -value;
    }

    public static int power(int base, int exponent) {
        if (exponent == 0) {
            return 1;
        }
        if (exponent < 0) {
            if (base == 1) {
                return 1;
            }
            if (base == -1) {
                if (exponent % 2 == 0) {
                    return 1;
                }
                return -1;
            }
            return 0;
        }
        --exponent;
        float shift = base;
        while (true) {
            if ((exponent & 1) != 0) {
                base = (int)((float)base * shift);
            }
            if ((exponent >>= 1) == 0) break;
            shift *= shift;
        }
        return base;
    }

    public static float power(float base, int exponent) {
        if (exponent == 0) {
            return 1.0f;
        }
        if (exponent < 0) {
            base = 1.0f / base;
            exponent = -exponent;
        }
        --exponent;
        float shift = base;
        while (true) {
            if ((exponent & 1) != 0) {
                base *= shift;
            }
            if ((exponent >>= 1) == 0) break;
            shift *= shift;
        }
        return base;
    }

    public static double power(double base, int exponent) {
        if (exponent == 0) {
            return 1.0;
        }
        if (exponent < 0) {
            base = 1.0 / base;
            exponent = -exponent;
        }
        --exponent;
        double shift = base;
        while (true) {
            if ((exponent & 1) != 0) {
                base *= shift;
            }
            if ((exponent >>= 1) == 0) break;
            shift *= shift;
        }
        return base;
    }

    public static int floor(float value) {
        int rounded = (int)value;
        return value < (float)rounded ? rounded - 1 : rounded;
    }

    public static int floor(double value) {
        int rounded = (int)value;
        return value < (double)rounded ? rounded - 1 : rounded;
    }

    public static int ceil(float value) {
        int rounded = (int)value;
        return value >= (float)rounded ? rounded + 1 : rounded;
    }

    public static int ceil(double value) {
        int rounded = (int)value;
        return value >= (double)rounded ? rounded + 1 : rounded;
    }

    public static int normalize(int input, int multiplier) {
        int straight;
        if (multiplier == 0) {
            return 0;
        }
        if (input == 0) {
            return multiplier;
        }
        if (input < 0) {
            multiplier *= -1;
        }
        if ((straight = input % multiplier) == 0) {
            return input;
        }
        return input + multiplier - straight;
    }

    public static float normalize(float input, float multiplier) {
        float straight;
        if (multiplier == 0.0f) {
            return 0.0f;
        }
        if (input == 0.0f) {
            return multiplier;
        }
        if (input < 0.0f) {
            multiplier *= -1.0f;
        }
        if ((straight = input % multiplier) == 0.0f) {
            return input;
        }
        return input + multiplier - straight;
    }

    public static double normalize(double input, double multiplier) {
        double straight;
        if (multiplier == 0.0) {
            return 0.0;
        }
        if (input == 0.0) {
            return multiplier;
        }
        if (input < 0.0) {
            multiplier *= -1.0;
        }
        if ((straight = input % multiplier) == 0.0) {
            return input;
        }
        return input + multiplier - straight;
    }

    public static int lerp(int a, int b, int t) {
        return a + t * (b - a);
    }

    public static float lerp(float a, float b, float t) {
        return a + t * (b - a);
    }

    public static double lerp(double a, double b, double t) {
        return a + t * (b - a);
    }

    public static float sine(float degrees) {
        int rounded = (int)degrees;
        if ((float)rounded == degrees && rounded % 90 == 0) {
            if ((rounded %= 360) < 0) {
                rounded += 360;
            }
            if (rounded == 0) {
                return 0.0f;
            }
            if (rounded == 90) {
                return 1.0f;
            }
            if (rounded == 180) {
                return 0.0f;
            }
            return -1.0f;
        }
        return (float)Math.sin(degrees);
    }

    public static double sine(double degrees) {
        int rounded = (int)degrees;
        if ((double)rounded == degrees && rounded % 90 == 0) {
            if ((rounded %= 360) < 0) {
                rounded += 360;
            }
            if (rounded == 0) {
                return 0.0;
            }
            if (rounded == 90) {
                return 1.0;
            }
            if (rounded == 180) {
                return 0.0;
            }
            return -1.0;
        }
        return Math.sin(degrees);
    }

    public static float cosine(float degrees) {
        int rounded = (int)degrees;
        if ((float)rounded == degrees && rounded % 90 == 0) {
            if ((rounded %= 360) < 0) {
                rounded += 360;
            }
            if (rounded == 0) {
                return 1.0f;
            }
            if (rounded == 90) {
                return 0.0f;
            }
            if (rounded == 180) {
                return -1.0f;
            }
            return 0.0f;
        }
        return (float)Math.cos(degrees);
    }

    public static double cosine(double degrees) {
        int rounded = (int)degrees;
        if ((double)rounded == degrees && rounded % 90 == 0) {
            if ((rounded %= 360) < 0) {
                rounded += 360;
            }
            if (rounded == 0) {
                return 1.0;
            }
            if (rounded == 90) {
                return 0.0;
            }
            if (rounded == 180) {
                return -1.0;
            }
            return 0.0;
        }
        return Math.cos(degrees);
    }

    public static float tangent(float degrees) {
        return Mathematic.sine(degrees) / Mathematic.cosine(degrees);
    }

    public static double tangent(double degrees) {
        return Mathematic.sine(degrees) / Mathematic.cosine(degrees);
    }

    public static float cotangent(float degrees) {
        return 1.0f / Mathematic.tangent(degrees);
    }

    public static double cotangent(double degrees) {
        return 1.0 / Mathematic.tangent(degrees);
    }
}

