/*
 * Decompiled with CFR 0.152.
 */
package at.unbounded.mathematic;

public final class MathematicPrecondition {
    private MathematicPrecondition() {
    }

    public static int assertPositive(String message, int x) {
        if (x <= 0) {
            throw new IllegalArgumentException(String.format("%s (%d) must be greater 0", message, x));
        }
        return x;
    }

    public static int assertNegative(String message, int x) {
        if (x >= 0) {
            throw new IllegalArgumentException(String.format("%s (%d) must be lesser 0", message, x));
        }
        return x;
    }

    public static int assertNonPositive(String message, int x) {
        if (x > 0) {
            throw new IllegalArgumentException(String.format("%s (%d) must be lesser or equal 0", message, x));
        }
        return x;
    }

    public static int assertNonNegative(String message, int x) {
        if (x < 0) {
            throw new IllegalArgumentException(String.format("%s (%d) must be greater or equal 0", message, x));
        }
        return x;
    }

    public static int assertBetween(String message, int x, int minimum, int maximum) {
        if (x > maximum || x < minimum) {
            throw new IllegalArgumentException(String.format("%s (%d) must be greater %d and lesser %d", message, x, minimum, maximum));
        }
        return x;
    }
}

