/*
 * Decompiled with CFR 0.152.
 */
package at.unbounded.mathematic.geom;

import at.unbounded.mathematic.geom.Angle;
import at.unbounded.mathematic.geom.AngleDegree;
import at.unbounded.mathematic.geom.AngleGradian;
import at.unbounded.mathematic.geom.AngleRadian;

public class AngleTime
implements Angle {
    private int seconds;
    private int minutes;
    private int hours;

    public AngleTime(int time) {
        this.seconds = time % 60;
        this.minutes = time / 60 % 60;
        this.hours = time / 3600;
    }

    public AngleTime(int seconds, int minutes, int hours) {
        this.seconds = seconds;
        this.minutes = minutes;
        this.hours = hours;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getHours() {
        return this.hours;
    }

    @Override
    public AngleDegree toDegree() {
        return new AngleDegree((double)(this.seconds + (this.minutes + this.hours * 60) * 60) / 240.0);
    }

    @Override
    public AngleRadian toRadian() {
        return new AngleRadian((double)(this.seconds + (this.minutes + this.hours * 60) * 60) * 7.27220521664304E-5);
    }

    @Override
    public AngleGradian toGradian() {
        return new AngleGradian((double)(this.seconds + (this.minutes + this.hours * 60) * 60) * 0.004629629629629629);
    }

    @Override
    public AngleTime toTime() {
        return new AngleTime(this.seconds, this.minutes, this.hours);
    }
}

