/*
 * Decompiled with CFR 0.152.
 */
package at.unbounded.mathematic.geom;

import at.unbounded.primitive.DoublePrimitive;

public class Matrix3D {
    private double m00;
    private double m01;
    private double m02;
    private double m10;
    private double m11;
    private double m12;
    private double m20;
    private double m21;
    private double m22;

    public Matrix3D() {
        this.m00 = 0.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = 0.0;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 0.0;
    }

    public Matrix3D(Matrix3D matrix) {
        this.m00 = matrix.m00;
        this.m01 = matrix.m01;
        this.m02 = matrix.m02;
        this.m10 = matrix.m10;
        this.m11 = matrix.m11;
        this.m12 = matrix.m12;
        this.m20 = matrix.m20;
        this.m21 = matrix.m21;
        this.m22 = matrix.m22;
    }

    public Matrix3D(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        this.m20 = m20;
        this.m21 = m21;
        this.m22 = m22;
    }

    public double getM00() {
        return this.m00;
    }

    public Matrix3D setM00(double m00) {
        this.m00 = m00;
        return this;
    }

    public double getM01() {
        return this.m01;
    }

    public Matrix3D setM01(double m01) {
        this.m01 = m01;
        return this;
    }

    public double getM02() {
        return this.m02;
    }

    public Matrix3D setM02(double m02) {
        this.m02 = m02;
        return this;
    }

    public double getM10() {
        return this.m10;
    }

    public Matrix3D setM10(double m10) {
        this.m10 = this.m00;
        return this;
    }

    public double getM11() {
        return this.m11;
    }

    public Matrix3D setM11(double m11) {
        this.m11 = m11;
        return this;
    }

    public double getM12() {
        return this.m12;
    }

    public Matrix3D setM12(double m12) {
        this.m12 = m12;
        return this;
    }

    public double getM20() {
        return this.m20;
    }

    public Matrix3D setM20(double m20) {
        this.m20 = m20;
        return this;
    }

    public double getM21() {
        return this.m21;
    }

    public Matrix3D setM21(double m21) {
        this.m21 = m21;
        return this;
    }

    public double getM22() {
        return this.m22;
    }

    public Matrix3D setM22(double m22) {
        this.m22 = m22;
        return this;
    }

    public double get(int row, int column) {
        if (row == 0) {
            if (column == 0) {
                return this.m00;
            }
            if (column == 1) {
                return this.m01;
            }
            if (column == 2) {
                return this.m02;
            }
        } else if (row == 1) {
            if (column == 0) {
                return this.m10;
            }
            if (column == 1) {
                return this.m11;
            }
            if (column == 2) {
                return this.m12;
            }
        } else if (row == 2) {
            if (column == 0) {
                return this.m20;
            }
            if (column == 1) {
                return this.m21;
            }
            if (column == 2) {
                return this.m22;
            }
        }
        return Double.NaN;
    }

    public Matrix3D set(int row, int column, double value) {
        if (row == 0) {
            if (column == 0) {
                this.m00 = value;
            } else if (column == 1) {
                this.m01 = value;
            } else if (column == 2) {
                this.m02 = value;
            }
        } else if (row == 1) {
            if (column == 0) {
                this.m10 = value;
            } else if (column == 1) {
                this.m11 = value;
            } else if (column == 2) {
                this.m12 = value;
            }
        } else if (row == 2) {
            if (column == 0) {
                this.m20 = value;
            } else if (column == 1) {
                this.m21 = value;
            } else if (column == 2) {
                this.m22 = value;
            }
        }
        return this;
    }

    public Matrix3D add(Matrix3D matrix) {
        this.m00 += matrix.m00;
        this.m01 += matrix.m01;
        this.m02 += matrix.m02;
        this.m10 += matrix.m10;
        this.m11 += matrix.m11;
        this.m12 += matrix.m12;
        this.m20 += matrix.m20;
        this.m21 += matrix.m21;
        this.m22 += matrix.m22;
        return this;
    }

    public Matrix3D sub(Matrix3D matrix) {
        this.m00 -= matrix.m00;
        this.m01 -= matrix.m01;
        this.m02 -= matrix.m02;
        this.m10 -= matrix.m10;
        this.m11 -= matrix.m11;
        this.m12 -= matrix.m12;
        this.m20 -= matrix.m20;
        this.m21 -= matrix.m21;
        this.m22 -= matrix.m22;
        return this;
    }

    public Matrix3D mul(Matrix3D matrix) {
        this.m00 = this.m00 * matrix.m00 + this.m01 * matrix.m10 + this.m02 * matrix.m20;
        this.m01 = this.m00 * matrix.m01 + this.m01 * matrix.m11 + this.m02 * matrix.m21;
        this.m02 = this.m00 * matrix.m02 + this.m01 * matrix.m12 + this.m02 * matrix.m22;
        this.m10 = this.m10 * matrix.m00 + this.m11 * matrix.m10 + this.m12 * matrix.m20;
        this.m11 = this.m10 * matrix.m01 + this.m11 * matrix.m11 + this.m12 * matrix.m21;
        this.m12 = this.m10 * matrix.m02 + this.m11 * matrix.m12 + this.m12 * matrix.m22;
        this.m20 = this.m20 * matrix.m00 + this.m21 * matrix.m10 + this.m22 * matrix.m20;
        this.m21 = this.m20 * matrix.m01 + this.m21 * matrix.m11 + this.m22 * matrix.m21;
        this.m22 = this.m20 * matrix.m02 + this.m21 * matrix.m12 + this.m22 * matrix.m22;
        return this;
    }

    public Matrix3D negate() {
        this.m00 = -this.m00;
        this.m01 = -this.m01;
        this.m02 = -this.m02;
        this.m10 = -this.m10;
        this.m11 = -this.m11;
        this.m12 = -this.m12;
        this.m20 = -this.m20;
        this.m21 = -this.m21;
        this.m22 = -this.m22;
        return this;
    }

    public Matrix3D transpose() {
        double temp = this.m01;
        this.m01 = this.m10;
        this.m10 = temp;
        temp = this.m02;
        this.m02 = this.m20;
        this.m20 = temp;
        temp = this.m12;
        this.m12 = this.m21;
        this.m21 = temp;
        return this;
    }

    public double determinant() {
        return this.m00 * (this.m11 * this.m22 - this.m12 * this.m21) + this.m01 * (this.m12 * this.m20 - this.m10 * this.m22) + this.m02 * (this.m10 * this.m21 - this.m11 * this.m20);
    }

    public Matrix3D invert() {
        double determinant = this.determinant();
        if (determinant == 0.0) {
            throw new IllegalStateException("Matrix is not invertible");
        }
        this.m00 = (this.m11 * this.m22 - this.m12 * this.m21) / determinant;
        this.m01 = (-this.m01 * this.m22 + this.m02 * this.m21) / determinant;
        this.m02 = (this.m01 * this.m12 - this.m02 * this.m11) / determinant;
        this.m10 = (-this.m10 * this.m22 + this.m12 * this.m20) / determinant;
        this.m11 = (this.m00 * this.m22 - this.m02 * this.m20) / determinant;
        this.m12 = (-this.m00 * this.m12 + this.m02 * this.m10) / determinant;
        this.m20 = (this.m10 * this.m21 - this.m11 * this.m20) / determinant;
        this.m21 = (-this.m00 * this.m21 + this.m01 * this.m20) / determinant;
        this.m22 = (this.m00 * this.m11 - this.m01 * this.m10) / determinant;
        return this;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof Matrix3D) {
            Matrix3D matrix = (Matrix3D)other;
            return this.m00 == matrix.m00 && this.m01 == matrix.m01 && this.m02 == matrix.m02 && this.m10 == matrix.m10 && this.m11 == matrix.m11 && this.m12 == matrix.m12 && this.m20 == matrix.m20 && this.m21 == matrix.m21 && this.m22 == matrix.m22;
        }
        return false;
    }

    public int hashCode() {
        return DoublePrimitive.hashCode(this.m00) ^ DoublePrimitive.hashCode(this.m01) ^ DoublePrimitive.hashCode(this.m02) ^ DoublePrimitive.hashCode(this.m10) ^ DoublePrimitive.hashCode(this.m11) ^ DoublePrimitive.hashCode(this.m12) ^ DoublePrimitive.hashCode(this.m20) ^ DoublePrimitive.hashCode(this.m21) ^ DoublePrimitive.hashCode(this.m22);
    }

    public String toString() {
        return String.format("Matrix3D([%d, %d, %d], [%d, %d, %d], [%d, %d, %d])", this.m00, this.m01, this.m02, this.m10, this.m11, this.m12, this.m20, this.m21, this.m22);
    }
}

