/*
 * Decompiled with CFR 0.152.
 */
package at.unbounded.mathematic.geom;

import at.unbounded.primitive.FloatPrimitive;

public class Matrix3F {
    private float m00;
    private float m01;
    private float m02;
    private float m10;
    private float m11;
    private float m12;
    private float m20;
    private float m21;
    private float m22;

    public Matrix3F() {
        this.m00 = 0.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 0.0f;
        this.m12 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 0.0f;
    }

    public Matrix3F(Matrix3F matrix) {
        this.m00 = matrix.m00;
        this.m01 = matrix.m01;
        this.m02 = matrix.m02;
        this.m10 = matrix.m10;
        this.m11 = matrix.m11;
        this.m12 = matrix.m12;
        this.m20 = matrix.m20;
        this.m21 = matrix.m21;
        this.m22 = matrix.m22;
    }

    public Matrix3F(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22) {
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        this.m20 = m20;
        this.m21 = m21;
        this.m22 = m22;
    }

    public float getM00() {
        return this.m00;
    }

    public Matrix3F setM00(float m00) {
        this.m00 = m00;
        return this;
    }

    public float getM01() {
        return this.m01;
    }

    public Matrix3F setM01(float m01) {
        this.m01 = m01;
        return this;
    }

    public float getM02() {
        return this.m02;
    }

    public Matrix3F setM02(float m02) {
        this.m02 = m02;
        return this;
    }

    public float getM10() {
        return this.m10;
    }

    public Matrix3F setM10(float m10) {
        this.m10 = this.m00;
        return this;
    }

    public float getM11() {
        return this.m11;
    }

    public Matrix3F setM11(float m11) {
        this.m11 = m11;
        return this;
    }

    public float getM12() {
        return this.m12;
    }

    public Matrix3F setM12(float m12) {
        this.m12 = m12;
        return this;
    }

    public float getM20() {
        return this.m20;
    }

    public Matrix3F setM20(float m20) {
        this.m20 = m20;
        return this;
    }

    public float getM21() {
        return this.m21;
    }

    public Matrix3F setM21(float m21) {
        this.m21 = m21;
        return this;
    }

    public float getM22() {
        return this.m22;
    }

    public Matrix3F setM22(float m22) {
        this.m22 = m22;
        return this;
    }

    public float get(int row, int column) {
        if (row == 0) {
            if (column == 0) {
                return this.m00;
            }
            if (column == 1) {
                return this.m01;
            }
            if (column == 2) {
                return this.m02;
            }
        } else if (row == 1) {
            if (column == 0) {
                return this.m10;
            }
            if (column == 1) {
                return this.m11;
            }
            if (column == 2) {
                return this.m12;
            }
        } else if (row == 2) {
            if (column == 0) {
                return this.m20;
            }
            if (column == 1) {
                return this.m21;
            }
            if (column == 2) {
                return this.m22;
            }
        }
        return Float.NaN;
    }

    public Matrix3F set(int row, int column, float value) {
        if (row == 0) {
            if (column == 0) {
                this.m00 = value;
            } else if (column == 1) {
                this.m01 = value;
            } else if (column == 2) {
                this.m02 = value;
            }
        } else if (row == 1) {
            if (column == 0) {
                this.m10 = value;
            } else if (column == 1) {
                this.m11 = value;
            } else if (column == 2) {
                this.m12 = value;
            }
        } else if (row == 2) {
            if (column == 0) {
                this.m20 = value;
            } else if (column == 1) {
                this.m21 = value;
            } else if (column == 2) {
                this.m22 = value;
            }
        }
        return this;
    }

    public Matrix3F add(Matrix3F matrix) {
        this.m00 += matrix.m00;
        this.m01 += matrix.m01;
        this.m02 += matrix.m02;
        this.m10 += matrix.m10;
        this.m11 += matrix.m11;
        this.m12 += matrix.m12;
        this.m20 += matrix.m20;
        this.m21 += matrix.m21;
        this.m22 += matrix.m22;
        return this;
    }

    public Matrix3F sub(Matrix3F matrix) {
        this.m00 -= matrix.m00;
        this.m01 -= matrix.m01;
        this.m02 -= matrix.m02;
        this.m10 -= matrix.m10;
        this.m11 -= matrix.m11;
        this.m12 -= matrix.m12;
        this.m20 -= matrix.m20;
        this.m21 -= matrix.m21;
        this.m22 -= matrix.m22;
        return this;
    }

    public Matrix3F mul(Matrix3F matrix) {
        this.m00 = this.m00 * matrix.m00 + this.m01 * matrix.m10 + this.m02 * matrix.m20;
        this.m01 = this.m00 * matrix.m01 + this.m01 * matrix.m11 + this.m02 * matrix.m21;
        this.m02 = this.m00 * matrix.m02 + this.m01 * matrix.m12 + this.m02 * matrix.m22;
        this.m10 = this.m10 * matrix.m00 + this.m11 * matrix.m10 + this.m12 * matrix.m20;
        this.m11 = this.m10 * matrix.m01 + this.m11 * matrix.m11 + this.m12 * matrix.m21;
        this.m12 = this.m10 * matrix.m02 + this.m11 * matrix.m12 + this.m12 * matrix.m22;
        this.m20 = this.m20 * matrix.m00 + this.m21 * matrix.m10 + this.m22 * matrix.m20;
        this.m21 = this.m20 * matrix.m01 + this.m21 * matrix.m11 + this.m22 * matrix.m21;
        this.m22 = this.m20 * matrix.m02 + this.m21 * matrix.m12 + this.m22 * matrix.m22;
        return this;
    }

    public Matrix3F negate() {
        this.m00 = -this.m00;
        this.m01 = -this.m01;
        this.m02 = -this.m02;
        this.m10 = -this.m10;
        this.m11 = -this.m11;
        this.m12 = -this.m12;
        this.m20 = -this.m20;
        this.m21 = -this.m21;
        this.m22 = -this.m22;
        return this;
    }

    public Matrix3F transpose() {
        float temp = this.m01;
        this.m01 = this.m10;
        this.m10 = temp;
        temp = this.m02;
        this.m02 = this.m20;
        this.m20 = temp;
        temp = this.m12;
        this.m12 = this.m21;
        this.m21 = temp;
        return this;
    }

    public float determinant() {
        return this.m00 * (this.m11 * this.m22 - this.m12 * this.m21) + this.m01 * (this.m12 * this.m20 - this.m10 * this.m22) + this.m02 * (this.m10 * this.m21 - this.m11 * this.m20);
    }

    public Matrix3F invert() {
        float determinant = this.determinant();
        if ((double)determinant == 0.0) {
            throw new IllegalStateException("Matrix is not invertible");
        }
        this.m00 = (this.m11 * this.m22 - this.m12 * this.m21) / determinant;
        this.m01 = (-this.m01 * this.m22 + this.m02 * this.m21) / determinant;
        this.m02 = (this.m01 * this.m12 - this.m02 * this.m11) / determinant;
        this.m10 = (-this.m10 * this.m22 + this.m12 * this.m20) / determinant;
        this.m11 = (this.m00 * this.m22 - this.m02 * this.m20) / determinant;
        this.m12 = (-this.m00 * this.m12 + this.m02 * this.m10) / determinant;
        this.m20 = (this.m10 * this.m21 - this.m11 * this.m20) / determinant;
        this.m21 = (-this.m00 * this.m21 + this.m01 * this.m20) / determinant;
        this.m22 = (this.m00 * this.m11 - this.m01 * this.m10) / determinant;
        return this;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof Matrix3F) {
            Matrix3F matrix = (Matrix3F)other;
            return this.m00 == matrix.m00 && this.m01 == matrix.m01 && this.m02 == matrix.m02 && this.m10 == matrix.m10 && this.m11 == matrix.m11 && this.m12 == matrix.m12 && this.m20 == matrix.m20 && this.m21 == matrix.m21 && this.m22 == matrix.m22;
        }
        return false;
    }

    public int hashCode() {
        return FloatPrimitive.hashCode(this.m00) ^ FloatPrimitive.hashCode(this.m01) ^ FloatPrimitive.hashCode(this.m02) ^ FloatPrimitive.hashCode(this.m10) ^ FloatPrimitive.hashCode(this.m11) ^ FloatPrimitive.hashCode(this.m12) ^ FloatPrimitive.hashCode(this.m20) ^ FloatPrimitive.hashCode(this.m21) ^ FloatPrimitive.hashCode(this.m22);
    }

    public String toString() {
        return String.format("Matrix3F([%d, %d, %d], [%d, %d, %d], [%d, %d, %d])", Float.valueOf(this.m00), Float.valueOf(this.m01), Float.valueOf(this.m02), Float.valueOf(this.m10), Float.valueOf(this.m11), Float.valueOf(this.m12), Float.valueOf(this.m20), Float.valueOf(this.m21), Float.valueOf(this.m22));
    }
}

