/*
 * Decompiled with CFR 0.152.
 */
package at.unbounded.mathematic.geom;

import at.unbounded.primitive.DoublePrimitive;

public class Matrix4D {
    private double m00;
    private double m01;
    private double m02;
    private double m03;
    private double m10;
    private double m11;
    private double m12;
    private double m13;
    private double m20;
    private double m21;
    private double m22;
    private double m23;
    private double m30;
    private double m31;
    private double m32;
    private double m33;

    public Matrix4D() {
        this.m00 = 0.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m03 = 0.0;
        this.m10 = 0.0;
        this.m11 = 0.0;
        this.m12 = 0.0;
        this.m13 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 0.0;
        this.m23 = 0.0;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 0.0;
    }

    public Matrix4D(Matrix4D matrix) {
        this.m00 = matrix.m00;
        this.m01 = matrix.m01;
        this.m02 = matrix.m02;
        this.m03 = matrix.m03;
        this.m10 = matrix.m10;
        this.m11 = matrix.m11;
        this.m12 = matrix.m12;
        this.m13 = matrix.m13;
        this.m20 = matrix.m20;
        this.m21 = matrix.m21;
        this.m22 = matrix.m22;
        this.m23 = matrix.m23;
        this.m30 = matrix.m30;
        this.m31 = matrix.m31;
        this.m32 = matrix.m32;
        this.m33 = matrix.m33;
    }

    public Matrix4D(double m00, double m01, double m02, double m03, double m10, double m11, double m12, double m13, double m20, double m21, double m22, double m23, double m30, double m31, double m32, double m33) {
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m03 = m03;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        this.m13 = m13;
        this.m20 = m20;
        this.m21 = m21;
        this.m22 = m22;
        this.m23 = m23;
        this.m30 = m30;
        this.m31 = m31;
        this.m32 = m32;
        this.m33 = m33;
    }

    public double getM00() {
        return this.m00;
    }

    public Matrix4D setM00(double m00) {
        this.m00 = m00;
        return this;
    }

    public double getM01() {
        return this.m01;
    }

    public Matrix4D setM01(double m01) {
        this.m01 = m01;
        return this;
    }

    public double getM02() {
        return this.m02;
    }

    public Matrix4D setM02(double m02) {
        this.m02 = m02;
        return this;
    }

    public double getM03() {
        return this.m03;
    }

    public Matrix4D setM03(double m03) {
        this.m03 = m03;
        return this;
    }

    public double getM10() {
        return this.m10;
    }

    public Matrix4D setM10(double m10) {
        this.m10 = this.m00;
        return this;
    }

    public double getM11() {
        return this.m11;
    }

    public Matrix4D setM11(double m11) {
        this.m11 = m11;
        return this;
    }

    public double getM12() {
        return this.m12;
    }

    public Matrix4D setM12(double m12) {
        this.m12 = m12;
        return this;
    }

    public double getM13() {
        return this.m13;
    }

    public Matrix4D setM13(double m13) {
        this.m13 = m13;
        return this;
    }

    public double getM20() {
        return this.m20;
    }

    public Matrix4D setM20(double m20) {
        this.m20 = m20;
        return this;
    }

    public double getM21() {
        return this.m21;
    }

    public Matrix4D setM21(double m21) {
        this.m21 = m21;
        return this;
    }

    public double getM22() {
        return this.m22;
    }

    public Matrix4D setM22(double m22) {
        this.m22 = m22;
        return this;
    }

    public double getM23() {
        return this.m23;
    }

    public Matrix4D setM23(double m23) {
        this.m23 = m23;
        return this;
    }

    public double getM30() {
        return this.m30;
    }

    public Matrix4D setM30(double m30) {
        this.m30 = m30;
        return this;
    }

    public double getM31() {
        return this.m31;
    }

    public Matrix4D setM31(double m31) {
        this.m31 = m31;
        return this;
    }

    public double getM32() {
        return this.m32;
    }

    public Matrix4D setM32(double m32) {
        this.m32 = m32;
        return this;
    }

    public double getM33() {
        return this.m33;
    }

    public Matrix4D setM33(double m33) {
        this.m33 = m33;
        return this;
    }

    public double get(int row, int column) {
        if (row == 0) {
            if (column == 0) {
                return this.m00;
            }
            if (column == 1) {
                return this.m01;
            }
            if (column == 2) {
                return this.m02;
            }
            if (column == 3) {
                return this.m03;
            }
        } else if (row == 1) {
            if (column == 0) {
                return this.m10;
            }
            if (column == 1) {
                return this.m11;
            }
            if (column == 2) {
                return this.m12;
            }
            if (column == 3) {
                return this.m13;
            }
        } else if (row == 2) {
            if (column == 0) {
                return this.m20;
            }
            if (column == 1) {
                return this.m21;
            }
            if (column == 2) {
                return this.m22;
            }
            if (column == 3) {
                return this.m23;
            }
        } else if (row == 3) {
            if (column == 0) {
                return this.m30;
            }
            if (column == 1) {
                return this.m31;
            }
            if (column == 2) {
                return this.m32;
            }
            if (column == 3) {
                return this.m33;
            }
        }
        return Double.NaN;
    }

    public Matrix4D set(int row, int column, double value) {
        if (row == 0) {
            if (column == 0) {
                this.m00 = value;
            } else if (column == 1) {
                this.m01 = value;
            } else if (column == 2) {
                this.m02 = value;
            } else if (column == 3) {
                this.m03 = value;
            }
        } else if (row == 1) {
            if (column == 0) {
                this.m10 = value;
            } else if (column == 1) {
                this.m11 = value;
            } else if (column == 2) {
                this.m12 = value;
            } else if (column == 3) {
                this.m13 = value;
            }
        } else if (row == 2) {
            if (column == 0) {
                this.m20 = value;
            } else if (column == 1) {
                this.m21 = value;
            } else if (column == 2) {
                this.m22 = value;
            } else if (column == 3) {
                this.m23 = value;
            }
        } else if (row == 3) {
            if (column == 0) {
                this.m30 = value;
            } else if (column == 1) {
                this.m31 = value;
            } else if (column == 2) {
                this.m32 = value;
            } else if (column == 3) {
                this.m33 = value;
            }
        }
        return this;
    }

    public Matrix4D add(Matrix4D matrix) {
        this.m00 += matrix.m00;
        this.m01 += matrix.m01;
        this.m02 += matrix.m02;
        this.m03 += matrix.m03;
        this.m10 += matrix.m10;
        this.m11 += matrix.m11;
        this.m12 += matrix.m12;
        this.m13 += matrix.m13;
        this.m20 += matrix.m20;
        this.m21 += matrix.m21;
        this.m22 += matrix.m22;
        this.m23 += matrix.m23;
        this.m30 += matrix.m30;
        this.m31 += matrix.m31;
        this.m32 += matrix.m32;
        this.m33 += matrix.m33;
        return this;
    }

    public Matrix4D sub(Matrix4D matrix) {
        this.m00 -= matrix.m00;
        this.m01 -= matrix.m01;
        this.m02 -= matrix.m02;
        this.m03 -= matrix.m03;
        this.m10 -= matrix.m10;
        this.m11 -= matrix.m11;
        this.m12 -= matrix.m12;
        this.m13 -= matrix.m13;
        this.m20 -= matrix.m20;
        this.m21 -= matrix.m21;
        this.m22 -= matrix.m22;
        this.m23 -= matrix.m23;
        this.m30 -= matrix.m30;
        this.m31 -= matrix.m31;
        this.m32 -= matrix.m32;
        this.m33 -= matrix.m33;
        return this;
    }

    public Matrix4D mul(Matrix4D matrix) {
        this.m00 = this.m00 * matrix.m00 + this.m01 * matrix.m10 + this.m02 * matrix.m20 + this.m03 * matrix.m30;
        this.m01 = this.m00 * matrix.m01 + this.m01 * matrix.m11 + this.m02 * matrix.m21 + this.m03 * matrix.m31;
        this.m02 = this.m00 * matrix.m02 + this.m01 * matrix.m12 + this.m02 * matrix.m22 + this.m03 * matrix.m32;
        this.m03 = this.m00 * matrix.m03 + this.m01 * matrix.m13 + this.m02 * matrix.m23 + this.m03 * matrix.m33;
        this.m10 = this.m10 * matrix.m00 + this.m11 * matrix.m10 + this.m12 * matrix.m20 + this.m13 * matrix.m30;
        this.m11 = this.m10 * matrix.m01 + this.m11 * matrix.m11 + this.m12 * matrix.m21 + this.m13 * matrix.m31;
        this.m12 = this.m10 * matrix.m02 + this.m11 * matrix.m12 + this.m12 * matrix.m22 + this.m13 * matrix.m32;
        this.m13 = this.m10 * matrix.m03 + this.m11 * matrix.m13 + this.m12 * matrix.m23 + this.m13 * matrix.m33;
        this.m20 = this.m20 * matrix.m00 + this.m21 * matrix.m10 + this.m22 * matrix.m20 + this.m23 * matrix.m30;
        this.m21 = this.m20 * matrix.m01 + this.m21 * matrix.m11 + this.m22 * matrix.m21 + this.m23 * matrix.m31;
        this.m22 = this.m20 * matrix.m02 + this.m21 * matrix.m12 + this.m22 * matrix.m22 + this.m23 * matrix.m32;
        this.m23 = this.m20 * matrix.m03 + this.m21 * matrix.m13 + this.m22 * matrix.m23 + this.m23 * matrix.m33;
        this.m30 = this.m30 * matrix.m00 + this.m31 * matrix.m10 + this.m32 * matrix.m20 + this.m33 * matrix.m30;
        this.m31 = this.m30 * matrix.m01 + this.m31 * matrix.m11 + this.m32 * matrix.m21 + this.m33 * matrix.m31;
        this.m32 = this.m30 * matrix.m02 + this.m31 * matrix.m12 + this.m32 * matrix.m22 + this.m33 * matrix.m32;
        this.m33 = this.m30 * matrix.m03 + this.m31 * matrix.m13 + this.m32 * matrix.m23 + this.m33 * matrix.m33;
        return this;
    }

    public Matrix4D negate() {
        this.m00 = -this.m00;
        this.m01 = -this.m01;
        this.m02 = -this.m02;
        this.m03 = -this.m03;
        this.m10 = -this.m10;
        this.m11 = -this.m11;
        this.m12 = -this.m12;
        this.m13 = -this.m13;
        this.m20 = -this.m20;
        this.m21 = -this.m21;
        this.m22 = -this.m22;
        this.m23 = -this.m23;
        this.m30 = -this.m30;
        this.m31 = -this.m31;
        this.m32 = -this.m32;
        this.m33 = -this.m33;
        return this;
    }

    public Matrix4D transpose() {
        double temp = this.m01;
        this.m01 = this.m10;
        this.m10 = temp;
        temp = this.m02;
        this.m02 = this.m20;
        this.m20 = temp;
        temp = this.m03;
        this.m03 = this.m30;
        this.m30 = temp;
        temp = this.m12;
        this.m12 = this.m21;
        this.m21 = temp;
        temp = this.m13;
        this.m13 = this.m31;
        this.m31 = temp;
        temp = this.m23;
        this.m23 = this.m32;
        this.m32 = temp;
        return this;
    }

    public double determinant() {
        return this.m00 * (this.m11 * this.m22 * this.m33 + this.m12 * this.m23 * this.m31 + this.m13 * this.m21 * this.m32 - this.m13 * this.m22 * this.m31 - this.m11 * this.m23 * this.m32 - this.m12 * this.m21 * this.m33) - this.m01 * (this.m10 * this.m22 * this.m33 + this.m12 * this.m23 * this.m30 + this.m13 * this.m20 * this.m32 - this.m13 * this.m22 * this.m30 - this.m10 * this.m23 * this.m32 - this.m12 * this.m20 * this.m33) + this.m02 * (this.m10 * this.m21 * this.m33 + this.m11 * this.m23 * this.m30 + this.m13 * this.m20 * this.m31 - this.m13 * this.m21 * this.m30 - this.m10 * this.m23 * this.m31 - this.m11 * this.m20 * this.m33) - this.m03 * (this.m10 * this.m21 * this.m32 + this.m11 * this.m22 * this.m30 + this.m12 * this.m20 * this.m31 - this.m12 * this.m21 * this.m30 - this.m10 * this.m22 * this.m31 - this.m11 * this.m20 * this.m32);
    }

    public Matrix4D invert() {
        double determinant = this.determinant();
        if (determinant == 0.0) {
            throw new IllegalStateException("Matrix is not invertible");
        }
        this.m00 = (this.m12 * this.m23 * this.m31 - this.m13 * this.m22 * this.m31 + this.m13 * this.m21 * this.m32 - this.m11 * this.m23 * this.m32 - this.m12 * this.m21 * this.m33 + this.m11 * this.m22 * this.m33) / determinant;
        this.m01 = (this.m03 * this.m22 * this.m31 - this.m02 * this.m23 * this.m31 - this.m03 * this.m21 * this.m32 + this.m01 * this.m23 * this.m32 + this.m02 * this.m21 * this.m33 - this.m01 * this.m22 * this.m33) / determinant;
        this.m02 = (this.m02 * this.m13 * this.m31 - this.m03 * this.m12 * this.m31 + this.m03 * this.m11 * this.m32 - this.m01 * this.m13 * this.m32 - this.m02 * this.m11 * this.m33 + this.m01 * this.m12 * this.m33) / determinant;
        this.m03 = (this.m03 * this.m12 * this.m21 - this.m02 * this.m13 * this.m21 - this.m03 * this.m11 * this.m22 + this.m01 * this.m13 * this.m22 + this.m02 * this.m11 * this.m23 - this.m01 * this.m12 * this.m23) / determinant;
        this.m10 = (this.m13 * this.m22 * this.m30 - this.m12 * this.m23 * this.m30 - this.m13 * this.m20 * this.m32 + this.m10 * this.m23 * this.m32 + this.m12 * this.m20 * this.m33 - this.m10 * this.m22 * this.m33) / determinant;
        this.m11 = (this.m02 * this.m23 * this.m30 - this.m03 * this.m22 * this.m30 + this.m03 * this.m20 * this.m32 - this.m00 * this.m23 * this.m32 - this.m02 * this.m20 * this.m33 + this.m00 * this.m22 * this.m33) / determinant;
        this.m12 = (this.m03 * this.m12 * this.m30 - this.m02 * this.m13 * this.m30 - this.m03 * this.m10 * this.m32 + this.m00 * this.m13 * this.m32 + this.m02 * this.m10 * this.m33 - this.m00 * this.m12 * this.m33) / determinant;
        this.m13 = (this.m02 * this.m13 * this.m20 - this.m03 * this.m12 * this.m20 + this.m03 * this.m10 * this.m22 - this.m00 * this.m13 * this.m22 - this.m02 * this.m10 * this.m23 + this.m00 * this.m12 * this.m23) / determinant;
        this.m20 = (this.m11 * this.m23 * this.m30 - this.m13 * this.m21 * this.m30 + this.m13 * this.m20 * this.m31 - this.m10 * this.m23 * this.m31 - this.m11 * this.m20 * this.m33 + this.m10 * this.m21 * this.m33) / determinant;
        this.m21 = (this.m03 * this.m21 * this.m30 - this.m01 * this.m23 * this.m30 - this.m03 * this.m20 * this.m31 + this.m00 * this.m23 * this.m31 + this.m01 * this.m20 * this.m33 - this.m00 * this.m21 * this.m33) / determinant;
        this.m22 = (this.m01 * this.m13 * this.m30 - this.m03 * this.m11 * this.m30 + this.m03 * this.m10 * this.m31 - this.m00 * this.m13 * this.m31 - this.m01 * this.m10 * this.m33 + this.m00 * this.m11 * this.m33) / determinant;
        this.m23 = (this.m03 * this.m11 * this.m20 - this.m01 * this.m13 * this.m20 - this.m03 * this.m10 * this.m21 + this.m00 * this.m13 * this.m21 + this.m01 * this.m10 * this.m23 - this.m00 * this.m11 * this.m23) / determinant;
        this.m30 = (this.m12 * this.m21 * this.m30 - this.m11 * this.m22 * this.m30 - this.m12 * this.m20 * this.m31 + this.m10 * this.m22 * this.m31 + this.m11 * this.m20 * this.m32 - this.m10 * this.m21 * this.m32) / determinant;
        this.m31 = (this.m01 * this.m22 * this.m30 - this.m02 * this.m21 * this.m30 + this.m02 * this.m20 * this.m31 - this.m00 * this.m22 * this.m31 - this.m01 * this.m20 * this.m32 + this.m00 * this.m21 * this.m32) / determinant;
        this.m32 = (this.m02 * this.m11 * this.m30 - this.m01 * this.m12 * this.m30 - this.m02 * this.m10 * this.m31 + this.m00 * this.m12 * this.m31 + this.m01 * this.m10 * this.m32 - this.m00 * this.m11 * this.m32) / determinant;
        this.m33 = (this.m01 * this.m12 * this.m20 - this.m02 * this.m11 * this.m20 + this.m02 * this.m10 * this.m21 - this.m00 * this.m12 * this.m21 - this.m01 * this.m10 * this.m22 + this.m00 * this.m11 * this.m22) / determinant;
        return this;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof Matrix4D) {
            Matrix4D matrix = (Matrix4D)other;
            return this.m00 == matrix.m00 && this.m01 == matrix.m01 && this.m02 == matrix.m02 && this.m03 == matrix.m03 && this.m10 == matrix.m10 && this.m11 == matrix.m11 && this.m12 == matrix.m12 && this.m13 == matrix.m13 && this.m20 == matrix.m20 && this.m21 == matrix.m21 && this.m22 == matrix.m22 && this.m23 == matrix.m23 && this.m30 == matrix.m30 && this.m31 == matrix.m31 && this.m32 == matrix.m32 && this.m33 == matrix.m33;
        }
        return false;
    }

    public int hashCode() {
        return DoublePrimitive.hashCode(this.m00) ^ DoublePrimitive.hashCode(this.m01) ^ DoublePrimitive.hashCode(this.m02) ^ DoublePrimitive.hashCode(this.m03) ^ DoublePrimitive.hashCode(this.m10) ^ DoublePrimitive.hashCode(this.m11) ^ DoublePrimitive.hashCode(this.m12) ^ DoublePrimitive.hashCode(this.m13) ^ DoublePrimitive.hashCode(this.m20) ^ DoublePrimitive.hashCode(this.m21) ^ DoublePrimitive.hashCode(this.m22) ^ DoublePrimitive.hashCode(this.m23) ^ DoublePrimitive.hashCode(this.m30) ^ DoublePrimitive.hashCode(this.m31) ^ DoublePrimitive.hashCode(this.m32) ^ DoublePrimitive.hashCode(this.m33);
    }

    public String toString() {
        return String.format("Matrix4D([%d, %d, %d, %d], [%d, %d, %d, %d], [%d, %d, %d, %d], [%d, %d, %d, %d])", this.m00, this.m01, this.m02, this.m03, this.m10, this.m11, this.m12, this.m13, this.m20, this.m21, this.m22, this.m23, this.m30, this.m31, this.m32, this.m33);
    }
}

