/*
 * Decompiled with CFR 0.152.
 */
package at.unbounded.mathematic.geom;

import at.unbounded.primitive.FloatPrimitive;

public class Matrix4F {
    private float m00;
    private float m01;
    private float m02;
    private float m03;
    private float m10;
    private float m11;
    private float m12;
    private float m13;
    private float m20;
    private float m21;
    private float m22;
    private float m23;
    private float m30;
    private float m31;
    private float m32;
    private float m33;

    public Matrix4F() {
        this.m00 = 0.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m03 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 0.0f;
        this.m12 = 0.0f;
        this.m13 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 0.0f;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 0.0f;
    }

    public Matrix4F(Matrix4F matrix) {
        this.m00 = matrix.m00;
        this.m01 = matrix.m01;
        this.m02 = matrix.m02;
        this.m03 = matrix.m03;
        this.m10 = matrix.m10;
        this.m11 = matrix.m11;
        this.m12 = matrix.m12;
        this.m13 = matrix.m13;
        this.m20 = matrix.m20;
        this.m21 = matrix.m21;
        this.m22 = matrix.m22;
        this.m23 = matrix.m23;
        this.m30 = matrix.m30;
        this.m31 = matrix.m31;
        this.m32 = matrix.m32;
        this.m33 = matrix.m33;
    }

    public Matrix4F(float m00, float m01, float m02, float m03, float m10, float m11, float m12, float m13, float m20, float m21, float m22, float m23, float m30, float m31, float m32, float m33) {
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m03 = m03;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        this.m13 = m13;
        this.m20 = m20;
        this.m21 = m21;
        this.m22 = m22;
        this.m23 = m23;
        this.m30 = m30;
        this.m31 = m31;
        this.m32 = m32;
        this.m33 = m33;
    }

    public float getM00() {
        return this.m00;
    }

    public Matrix4F setM00(float m00) {
        this.m00 = m00;
        return this;
    }

    public float getM01() {
        return this.m01;
    }

    public Matrix4F setM01(float m01) {
        this.m01 = m01;
        return this;
    }

    public float getM02() {
        return this.m02;
    }

    public Matrix4F setM02(float m02) {
        this.m02 = m02;
        return this;
    }

    public float getM03() {
        return this.m03;
    }

    public Matrix4F setM03(float m03) {
        this.m03 = m03;
        return this;
    }

    public float getM10() {
        return this.m10;
    }

    public Matrix4F setM10(float m10) {
        this.m10 = this.m00;
        return this;
    }

    public float getM11() {
        return this.m11;
    }

    public Matrix4F setM11(float m11) {
        this.m11 = m11;
        return this;
    }

    public float getM12() {
        return this.m12;
    }

    public Matrix4F setM12(float m12) {
        this.m12 = m12;
        return this;
    }

    public float getM13() {
        return this.m13;
    }

    public Matrix4F setM13(float m13) {
        this.m13 = m13;
        return this;
    }

    public float getM20() {
        return this.m20;
    }

    public Matrix4F setM20(float m20) {
        this.m20 = m20;
        return this;
    }

    public float getM21() {
        return this.m21;
    }

    public Matrix4F setM21(float m21) {
        this.m21 = m21;
        return this;
    }

    public float getM22() {
        return this.m22;
    }

    public Matrix4F setM22(float m22) {
        this.m22 = m22;
        return this;
    }

    public float getM23() {
        return this.m23;
    }

    public Matrix4F setM23(float m23) {
        this.m23 = m23;
        return this;
    }

    public float getM30() {
        return this.m30;
    }

    public Matrix4F setM30(float m30) {
        this.m30 = m30;
        return this;
    }

    public float getM31() {
        return this.m31;
    }

    public Matrix4F setM31(float m31) {
        this.m31 = m31;
        return this;
    }

    public float getM32() {
        return this.m32;
    }

    public Matrix4F setM32(float m32) {
        this.m32 = m32;
        return this;
    }

    public float getM33() {
        return this.m33;
    }

    public Matrix4F setM33(float m33) {
        this.m33 = m33;
        return this;
    }

    public float get(int row, int column) {
        if (row == 0) {
            if (column == 0) {
                return this.m00;
            }
            if (column == 1) {
                return this.m01;
            }
            if (column == 2) {
                return this.m02;
            }
            if (column == 3) {
                return this.m03;
            }
        } else if (row == 1) {
            if (column == 0) {
                return this.m10;
            }
            if (column == 1) {
                return this.m11;
            }
            if (column == 2) {
                return this.m12;
            }
            if (column == 3) {
                return this.m13;
            }
        } else if (row == 2) {
            if (column == 0) {
                return this.m20;
            }
            if (column == 1) {
                return this.m21;
            }
            if (column == 2) {
                return this.m22;
            }
            if (column == 3) {
                return this.m23;
            }
        } else if (row == 3) {
            if (column == 0) {
                return this.m30;
            }
            if (column == 1) {
                return this.m31;
            }
            if (column == 2) {
                return this.m32;
            }
            if (column == 3) {
                return this.m33;
            }
        }
        return Float.NaN;
    }

    public Matrix4F set(int row, int column, float value) {
        if (row == 0) {
            if (column == 0) {
                this.m00 = value;
            } else if (column == 1) {
                this.m01 = value;
            } else if (column == 2) {
                this.m02 = value;
            } else if (column == 3) {
                this.m03 = value;
            }
        } else if (row == 1) {
            if (column == 0) {
                this.m10 = value;
            } else if (column == 1) {
                this.m11 = value;
            } else if (column == 2) {
                this.m12 = value;
            } else if (column == 3) {
                this.m13 = value;
            }
        } else if (row == 2) {
            if (column == 0) {
                this.m20 = value;
            } else if (column == 1) {
                this.m21 = value;
            } else if (column == 2) {
                this.m22 = value;
            } else if (column == 3) {
                this.m23 = value;
            }
        } else if (row == 3) {
            if (column == 0) {
                this.m30 = value;
            } else if (column == 1) {
                this.m31 = value;
            } else if (column == 2) {
                this.m32 = value;
            } else if (column == 3) {
                this.m33 = value;
            }
        }
        return this;
    }

    public Matrix4F add(Matrix4F matrix) {
        this.m00 += matrix.m00;
        this.m01 += matrix.m01;
        this.m02 += matrix.m02;
        this.m03 += matrix.m03;
        this.m10 += matrix.m10;
        this.m11 += matrix.m11;
        this.m12 += matrix.m12;
        this.m13 += matrix.m13;
        this.m20 += matrix.m20;
        this.m21 += matrix.m21;
        this.m22 += matrix.m22;
        this.m23 += matrix.m23;
        this.m30 += matrix.m30;
        this.m31 += matrix.m31;
        this.m32 += matrix.m32;
        this.m33 += matrix.m33;
        return this;
    }

    public Matrix4F sub(Matrix4F matrix) {
        this.m00 -= matrix.m00;
        this.m01 -= matrix.m01;
        this.m02 -= matrix.m02;
        this.m03 -= matrix.m03;
        this.m10 -= matrix.m10;
        this.m11 -= matrix.m11;
        this.m12 -= matrix.m12;
        this.m13 -= matrix.m13;
        this.m20 -= matrix.m20;
        this.m21 -= matrix.m21;
        this.m22 -= matrix.m22;
        this.m23 -= matrix.m23;
        this.m30 -= matrix.m30;
        this.m31 -= matrix.m31;
        this.m32 -= matrix.m32;
        this.m33 -= matrix.m33;
        return this;
    }

    public Matrix4F mul(Matrix4F matrix) {
        this.m00 = this.m00 * matrix.m00 + this.m01 * matrix.m10 + this.m02 * matrix.m20 + this.m03 * matrix.m30;
        this.m01 = this.m00 * matrix.m01 + this.m01 * matrix.m11 + this.m02 * matrix.m21 + this.m03 * matrix.m31;
        this.m02 = this.m00 * matrix.m02 + this.m01 * matrix.m12 + this.m02 * matrix.m22 + this.m03 * matrix.m32;
        this.m03 = this.m00 * matrix.m03 + this.m01 * matrix.m13 + this.m02 * matrix.m23 + this.m03 * matrix.m33;
        this.m10 = this.m10 * matrix.m00 + this.m11 * matrix.m10 + this.m12 * matrix.m20 + this.m13 * matrix.m30;
        this.m11 = this.m10 * matrix.m01 + this.m11 * matrix.m11 + this.m12 * matrix.m21 + this.m13 * matrix.m31;
        this.m12 = this.m10 * matrix.m02 + this.m11 * matrix.m12 + this.m12 * matrix.m22 + this.m13 * matrix.m32;
        this.m13 = this.m10 * matrix.m03 + this.m11 * matrix.m13 + this.m12 * matrix.m23 + this.m13 * matrix.m33;
        this.m20 = this.m20 * matrix.m00 + this.m21 * matrix.m10 + this.m22 * matrix.m20 + this.m23 * matrix.m30;
        this.m21 = this.m20 * matrix.m01 + this.m21 * matrix.m11 + this.m22 * matrix.m21 + this.m23 * matrix.m31;
        this.m22 = this.m20 * matrix.m02 + this.m21 * matrix.m12 + this.m22 * matrix.m22 + this.m23 * matrix.m32;
        this.m23 = this.m20 * matrix.m03 + this.m21 * matrix.m13 + this.m22 * matrix.m23 + this.m23 * matrix.m33;
        this.m30 = this.m30 * matrix.m00 + this.m31 * matrix.m10 + this.m32 * matrix.m20 + this.m33 * matrix.m30;
        this.m31 = this.m30 * matrix.m01 + this.m31 * matrix.m11 + this.m32 * matrix.m21 + this.m33 * matrix.m31;
        this.m32 = this.m30 * matrix.m02 + this.m31 * matrix.m12 + this.m32 * matrix.m22 + this.m33 * matrix.m32;
        this.m33 = this.m30 * matrix.m03 + this.m31 * matrix.m13 + this.m32 * matrix.m23 + this.m33 * matrix.m33;
        return this;
    }

    public Matrix4F negate() {
        this.m00 = -this.m00;
        this.m01 = -this.m01;
        this.m02 = -this.m02;
        this.m03 = -this.m03;
        this.m10 = -this.m10;
        this.m11 = -this.m11;
        this.m12 = -this.m12;
        this.m13 = -this.m13;
        this.m20 = -this.m20;
        this.m21 = -this.m21;
        this.m22 = -this.m22;
        this.m23 = -this.m23;
        this.m30 = -this.m30;
        this.m31 = -this.m31;
        this.m32 = -this.m32;
        this.m33 = -this.m33;
        return this;
    }

    public Matrix4F transpose() {
        float temp = this.m01;
        this.m01 = this.m10;
        this.m10 = temp;
        temp = this.m02;
        this.m02 = this.m20;
        this.m20 = temp;
        temp = this.m03;
        this.m03 = this.m30;
        this.m30 = temp;
        temp = this.m12;
        this.m12 = this.m21;
        this.m21 = temp;
        temp = this.m13;
        this.m13 = this.m31;
        this.m31 = temp;
        temp = this.m23;
        this.m23 = this.m32;
        this.m32 = temp;
        return this;
    }

    public float determinant() {
        return this.m00 * (this.m11 * this.m22 * this.m33 + this.m12 * this.m23 * this.m31 + this.m13 * this.m21 * this.m32 - this.m13 * this.m22 * this.m31 - this.m11 * this.m23 * this.m32 - this.m12 * this.m21 * this.m33) - this.m01 * (this.m10 * this.m22 * this.m33 + this.m12 * this.m23 * this.m30 + this.m13 * this.m20 * this.m32 - this.m13 * this.m22 * this.m30 - this.m10 * this.m23 * this.m32 - this.m12 * this.m20 * this.m33) + this.m02 * (this.m10 * this.m21 * this.m33 + this.m11 * this.m23 * this.m30 + this.m13 * this.m20 * this.m31 - this.m13 * this.m21 * this.m30 - this.m10 * this.m23 * this.m31 - this.m11 * this.m20 * this.m33) - this.m03 * (this.m10 * this.m21 * this.m32 + this.m11 * this.m22 * this.m30 + this.m12 * this.m20 * this.m31 - this.m12 * this.m21 * this.m30 - this.m10 * this.m22 * this.m31 - this.m11 * this.m20 * this.m32);
    }

    public Matrix4F invert() {
        float determinant = this.determinant();
        if ((double)determinant == 0.0) {
            throw new IllegalStateException("Matrix is not invertible");
        }
        this.m00 = (this.m12 * this.m23 * this.m31 - this.m13 * this.m22 * this.m31 + this.m13 * this.m21 * this.m32 - this.m11 * this.m23 * this.m32 - this.m12 * this.m21 * this.m33 + this.m11 * this.m22 * this.m33) / determinant;
        this.m01 = (this.m03 * this.m22 * this.m31 - this.m02 * this.m23 * this.m31 - this.m03 * this.m21 * this.m32 + this.m01 * this.m23 * this.m32 + this.m02 * this.m21 * this.m33 - this.m01 * this.m22 * this.m33) / determinant;
        this.m02 = (this.m02 * this.m13 * this.m31 - this.m03 * this.m12 * this.m31 + this.m03 * this.m11 * this.m32 - this.m01 * this.m13 * this.m32 - this.m02 * this.m11 * this.m33 + this.m01 * this.m12 * this.m33) / determinant;
        this.m03 = (this.m03 * this.m12 * this.m21 - this.m02 * this.m13 * this.m21 - this.m03 * this.m11 * this.m22 + this.m01 * this.m13 * this.m22 + this.m02 * this.m11 * this.m23 - this.m01 * this.m12 * this.m23) / determinant;
        this.m10 = (this.m13 * this.m22 * this.m30 - this.m12 * this.m23 * this.m30 - this.m13 * this.m20 * this.m32 + this.m10 * this.m23 * this.m32 + this.m12 * this.m20 * this.m33 - this.m10 * this.m22 * this.m33) / determinant;
        this.m11 = (this.m02 * this.m23 * this.m30 - this.m03 * this.m22 * this.m30 + this.m03 * this.m20 * this.m32 - this.m00 * this.m23 * this.m32 - this.m02 * this.m20 * this.m33 + this.m00 * this.m22 * this.m33) / determinant;
        this.m12 = (this.m03 * this.m12 * this.m30 - this.m02 * this.m13 * this.m30 - this.m03 * this.m10 * this.m32 + this.m00 * this.m13 * this.m32 + this.m02 * this.m10 * this.m33 - this.m00 * this.m12 * this.m33) / determinant;
        this.m13 = (this.m02 * this.m13 * this.m20 - this.m03 * this.m12 * this.m20 + this.m03 * this.m10 * this.m22 - this.m00 * this.m13 * this.m22 - this.m02 * this.m10 * this.m23 + this.m00 * this.m12 * this.m23) / determinant;
        this.m20 = (this.m11 * this.m23 * this.m30 - this.m13 * this.m21 * this.m30 + this.m13 * this.m20 * this.m31 - this.m10 * this.m23 * this.m31 - this.m11 * this.m20 * this.m33 + this.m10 * this.m21 * this.m33) / determinant;
        this.m21 = (this.m03 * this.m21 * this.m30 - this.m01 * this.m23 * this.m30 - this.m03 * this.m20 * this.m31 + this.m00 * this.m23 * this.m31 + this.m01 * this.m20 * this.m33 - this.m00 * this.m21 * this.m33) / determinant;
        this.m22 = (this.m01 * this.m13 * this.m30 - this.m03 * this.m11 * this.m30 + this.m03 * this.m10 * this.m31 - this.m00 * this.m13 * this.m31 - this.m01 * this.m10 * this.m33 + this.m00 * this.m11 * this.m33) / determinant;
        this.m23 = (this.m03 * this.m11 * this.m20 - this.m01 * this.m13 * this.m20 - this.m03 * this.m10 * this.m21 + this.m00 * this.m13 * this.m21 + this.m01 * this.m10 * this.m23 - this.m00 * this.m11 * this.m23) / determinant;
        this.m30 = (this.m12 * this.m21 * this.m30 - this.m11 * this.m22 * this.m30 - this.m12 * this.m20 * this.m31 + this.m10 * this.m22 * this.m31 + this.m11 * this.m20 * this.m32 - this.m10 * this.m21 * this.m32) / determinant;
        this.m31 = (this.m01 * this.m22 * this.m30 - this.m02 * this.m21 * this.m30 + this.m02 * this.m20 * this.m31 - this.m00 * this.m22 * this.m31 - this.m01 * this.m20 * this.m32 + this.m00 * this.m21 * this.m32) / determinant;
        this.m32 = (this.m02 * this.m11 * this.m30 - this.m01 * this.m12 * this.m30 - this.m02 * this.m10 * this.m31 + this.m00 * this.m12 * this.m31 + this.m01 * this.m10 * this.m32 - this.m00 * this.m11 * this.m32) / determinant;
        this.m33 = (this.m01 * this.m12 * this.m20 - this.m02 * this.m11 * this.m20 + this.m02 * this.m10 * this.m21 - this.m00 * this.m12 * this.m21 - this.m01 * this.m10 * this.m22 + this.m00 * this.m11 * this.m22) / determinant;
        return this;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof Matrix4F) {
            Matrix4F matrix = (Matrix4F)other;
            return this.m00 == matrix.m00 && this.m01 == matrix.m01 && this.m02 == matrix.m02 && this.m03 == matrix.m03 && this.m10 == matrix.m10 && this.m11 == matrix.m11 && this.m12 == matrix.m12 && this.m13 == matrix.m13 && this.m20 == matrix.m20 && this.m21 == matrix.m21 && this.m22 == matrix.m22 && this.m23 == matrix.m23 && this.m30 == matrix.m30 && this.m31 == matrix.m31 && this.m32 == matrix.m32 && this.m33 == matrix.m33;
        }
        return false;
    }

    public int hashCode() {
        return FloatPrimitive.hashCode(this.m00) ^ FloatPrimitive.hashCode(this.m01) ^ FloatPrimitive.hashCode(this.m02) ^ FloatPrimitive.hashCode(this.m03) ^ FloatPrimitive.hashCode(this.m10) ^ FloatPrimitive.hashCode(this.m11) ^ FloatPrimitive.hashCode(this.m12) ^ FloatPrimitive.hashCode(this.m13) ^ FloatPrimitive.hashCode(this.m20) ^ FloatPrimitive.hashCode(this.m21) ^ FloatPrimitive.hashCode(this.m22) ^ FloatPrimitive.hashCode(this.m23) ^ FloatPrimitive.hashCode(this.m30) ^ FloatPrimitive.hashCode(this.m31) ^ FloatPrimitive.hashCode(this.m32) ^ FloatPrimitive.hashCode(this.m33);
    }

    public String toString() {
        return String.format("Matrix4F([%d, %d, %d, %d], [%d, %d, %d, %d], [%d, %d, %d, %d], [%d, %d, %d, %d])", Float.valueOf(this.m00), Float.valueOf(this.m01), Float.valueOf(this.m02), Float.valueOf(this.m03), Float.valueOf(this.m10), Float.valueOf(this.m11), Float.valueOf(this.m12), Float.valueOf(this.m13), Float.valueOf(this.m20), Float.valueOf(this.m21), Float.valueOf(this.m22), Float.valueOf(this.m23), Float.valueOf(this.m30), Float.valueOf(this.m31), Float.valueOf(this.m32), Float.valueOf(this.m33));
    }
}

