/*
 * Decompiled with CFR 0.152.
 */
package at.unbounded.mathematic.geom;

import at.unbounded.primitive.DoublePrimitive;

public class Vector2D {
    private double x;
    private double y;

    public Vector2D() {
        this.x = 0.0;
        this.y = 0.0;
    }

    public Vector2D(Vector2D vector) {
        this.x = vector.x;
        this.y = vector.y;
    }

    public Vector2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public double getX() {
        return this.x;
    }

    public Vector2D setX(double x) {
        this.x = x;
        return this;
    }

    public double getY() {
        return this.y;
    }

    public Vector2D setY(double y) {
        this.y = y;
        return this;
    }

    public Vector2D add(Vector2D vector) {
        this.x += vector.x;
        this.y += vector.y;
        return this;
    }

    public Vector2D add(double x, double y) {
        this.x += x;
        this.y += y;
        return this;
    }

    public Vector2D sub(Vector2D vector) {
        this.x -= vector.x;
        this.y -= vector.y;
        return this;
    }

    public Vector2D sub(double x, double y) {
        this.x -= x;
        this.y -= y;
        return this;
    }

    public Vector2D mul(Vector2D vector) {
        this.x *= vector.x;
        this.y *= vector.y;
        return this;
    }

    public Vector2D mul(double x, double y) {
        this.x *= x;
        this.y *= y;
        return this;
    }

    public Vector2D div(Vector2D vector) {
        this.x /= vector.x;
        this.y /= vector.y;
        return this;
    }

    public Vector2D div(double x, double y) {
        this.x /= x;
        this.y /= y;
        return this;
    }

    public Vector2D scale(double n) {
        this.x *= n;
        this.y *= n;
        return this;
    }

    public Vector2D negate() {
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }

    public Vector2D normalize() {
        double n = 1.0 / Math.sqrt(this.x * this.x + this.y * this.y);
        this.x *= n;
        this.y *= n;
        return this;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public double lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public double distance(Vector2D vector) {
        return Math.sqrt(Math.pow(vector.x - this.x, 2.0) + Math.pow(vector.y - this.y, 2.0));
    }

    public double distanceSquared(Vector2D vector) {
        return Math.pow(vector.x - this.x, 2.0) + Math.pow(vector.y - this.y, 2.0);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof Vector2D) {
            Vector2D vector = (Vector2D)other;
            return this.x == vector.x && this.y == vector.y;
        }
        return false;
    }

    public int hashCode() {
        return DoublePrimitive.hashCode(this.x) ^ DoublePrimitive.hashCode(this.y);
    }

    public String toString() {
        return String.format("Vector2D(%d, %d)", this.x, this.y);
    }
}

