/*
 * Decompiled with CFR 0.152.
 */
package at.unbounded.mathematic.geom;

import at.unbounded.primitive.FloatPrimitive;

public class Vector2F {
    private float x;
    private float y;

    public Vector2F() {
        this.x = 0.0f;
        this.y = 0.0f;
    }

    public Vector2F(Vector2F vector) {
        this.x = vector.x;
        this.y = vector.y;
    }

    public Vector2F(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public float getX() {
        return this.x;
    }

    public Vector2F setX(float x) {
        this.x = x;
        return this;
    }

    public float getY() {
        return this.y;
    }

    public Vector2F setY(float y) {
        this.y = y;
        return this;
    }

    public Vector2F add(Vector2F vector) {
        this.x += vector.x;
        this.y += vector.y;
        return this;
    }

    public Vector2F add(float x, float y) {
        this.x += x;
        this.y += y;
        return this;
    }

    public Vector2F sub(Vector2F vector) {
        this.x -= vector.x;
        this.y -= vector.y;
        return this;
    }

    public Vector2F sub(float x, float y) {
        this.x -= x;
        this.y -= y;
        return this;
    }

    public Vector2F mul(Vector2F vector) {
        this.x *= vector.x;
        this.y *= vector.y;
        return this;
    }

    public Vector2F mul(float x, float y) {
        this.x *= x;
        this.y *= y;
        return this;
    }

    public Vector2F div(Vector2F vector) {
        this.x /= vector.x;
        this.y /= vector.y;
        return this;
    }

    public Vector2F div(float x, float y) {
        this.x /= x;
        this.y /= y;
        return this;
    }

    public Vector2F scale(float n) {
        this.x *= n;
        this.y *= n;
        return this;
    }

    public Vector2F negate() {
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }

    public Vector2F normalize() {
        double n = 1.0 / Math.sqrt(this.x * this.x + this.y * this.y);
        this.x = (float)((double)this.x * n);
        this.y = (float)((double)this.y * n);
        return this;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public double lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public double distance(Vector2F vector) {
        return Math.sqrt(Math.pow(vector.x - this.x, 2.0) + Math.pow(vector.y - this.y, 2.0));
    }

    public double distanceSquared(Vector2F vector) {
        return Math.pow(vector.x - this.x, 2.0) + Math.pow(vector.y - this.y, 2.0);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof Vector2F) {
            Vector2F vector = (Vector2F)other;
            return this.x == vector.x && this.y == vector.y;
        }
        return false;
    }

    public int hashCode() {
        return FloatPrimitive.hashCode(this.x) ^ FloatPrimitive.hashCode(this.y);
    }

    public String toString() {
        return String.format("Vector2F(%d, %d)", Float.valueOf(this.x), Float.valueOf(this.y));
    }
}

