/*
 * Decompiled with CFR 0.152.
 */
package at.unbounded.mathematic.geom;

import at.unbounded.primitive.IntegerPrimitive;

public class Vector2I {
    private int x;
    private int y;

    public Vector2I() {
        this.x = 0;
        this.y = 0;
    }

    public Vector2I(Vector2I vector) {
        this.x = vector.x;
        this.y = vector.y;
    }

    public Vector2I(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public int getX() {
        return this.x;
    }

    public Vector2I setX(int x) {
        this.x = x;
        return this;
    }

    public int getY() {
        return this.y;
    }

    public Vector2I setY(int y) {
        this.y = y;
        return this;
    }

    public Vector2I add(Vector2I vector) {
        this.x += vector.x;
        this.y += vector.y;
        return this;
    }

    public Vector2I add(int x, int y) {
        this.x += x;
        this.y += y;
        return this;
    }

    public Vector2I sub(Vector2I vector) {
        this.x -= vector.x;
        this.y -= vector.y;
        return this;
    }

    public Vector2I sub(int x, int y) {
        this.x -= x;
        this.y -= y;
        return this;
    }

    public Vector2I mul(Vector2I vector) {
        this.x *= vector.x;
        this.y *= vector.y;
        return this;
    }

    public Vector2I mul(int x, int y) {
        this.x *= x;
        this.y *= y;
        return this;
    }

    public Vector2I div(Vector2I vector) {
        this.x /= vector.x;
        this.y /= vector.y;
        return this;
    }

    public Vector2I div(int x, int y) {
        this.x /= x;
        this.y /= y;
        return this;
    }

    public Vector2I scale(int n) {
        this.x *= n;
        this.y *= n;
        return this;
    }

    public Vector2I negate() {
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }

    public Vector2I normalize() {
        double n = 1.0 / Math.sqrt(this.x * this.x + this.y * this.y);
        this.x = (int)((double)this.x * n);
        this.y = (int)((double)this.y * n);
        return this;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public double lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public double distance(Vector2I vector) {
        return Math.sqrt(Math.pow(vector.x - this.x, 2.0) + Math.pow(vector.y - this.y, 2.0));
    }

    public double distanceSquared(Vector2I vector) {
        return Math.pow(vector.x - this.x, 2.0) + Math.pow(vector.y - this.y, 2.0);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof Vector2I) {
            Vector2I vector = (Vector2I)other;
            return this.x == vector.x && this.y == vector.y;
        }
        return false;
    }

    public int hashCode() {
        return IntegerPrimitive.hashCode(this.x) ^ IntegerPrimitive.hashCode(this.y);
    }

    public String toString() {
        return String.format("Vector2I(%d, %d)", this.x, this.y);
    }
}

