/*
 * Decompiled with CFR 0.152.
 */
package at.unbounded.mathematic.geom;

import at.unbounded.primitive.LongPrimitive;

public class Vector2L {
    private long x;
    private long y;

    public Vector2L() {
        this.x = 0L;
        this.y = 0L;
    }

    public Vector2L(Vector2L vector) {
        this.x = vector.x;
        this.y = vector.y;
    }

    public Vector2L(long x, long y) {
        this.x = x;
        this.y = y;
    }

    public long getX() {
        return this.x;
    }

    public Vector2L setX(long x) {
        this.x = x;
        return this;
    }

    public long getY() {
        return this.y;
    }

    public Vector2L setY(long y) {
        this.y = y;
        return this;
    }

    public Vector2L add(Vector2L vector) {
        this.x += vector.x;
        this.y += vector.y;
        return this;
    }

    public Vector2L add(long x, long y) {
        this.x += x;
        this.y += y;
        return this;
    }

    public Vector2L sub(Vector2L vector) {
        this.x -= vector.x;
        this.y -= vector.y;
        return this;
    }

    public Vector2L sub(long x, long y) {
        this.x -= x;
        this.y -= y;
        return this;
    }

    public Vector2L mul(Vector2L vector) {
        this.x *= vector.x;
        this.y *= vector.y;
        return this;
    }

    public Vector2L mul(long x, long y) {
        this.x *= x;
        this.y *= y;
        return this;
    }

    public Vector2L div(Vector2L vector) {
        this.x /= vector.x;
        this.y /= vector.y;
        return this;
    }

    public Vector2L div(long x, long y) {
        this.x /= x;
        this.y /= y;
        return this;
    }

    public Vector2L scale(long n) {
        this.x *= n;
        this.y *= n;
        return this;
    }

    public Vector2L negate() {
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }

    public Vector2L normalize() {
        double n = 1.0 / Math.sqrt(this.x * this.x + this.y * this.y);
        this.x = (long)((double)this.x * n);
        this.y = (long)((double)this.y * n);
        return this;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public double lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public double distance(Vector2L vector) {
        return Math.sqrt(Math.pow(vector.x - this.x, 2.0) + Math.pow(vector.y - this.y, 2.0));
    }

    public double distanceSquared(Vector2L vector) {
        return Math.pow(vector.x - this.x, 2.0) + Math.pow(vector.y - this.y, 2.0);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof Vector2L) {
            Vector2L vector = (Vector2L)other;
            return this.x == vector.x && this.y == vector.y;
        }
        return false;
    }

    public int hashCode() {
        return LongPrimitive.hashCode(this.x) ^ LongPrimitive.hashCode(this.y);
    }

    public String toString() {
        return String.format("Vector2L(%d, %d)", this.x, this.y);
    }
}

