/*
 * Decompiled with CFR 0.152.
 */
package at.unbounded.mathematic.geom;

import at.unbounded.primitive.DoublePrimitive;

public class Vector3D {
    private double x;
    private double y;
    private double z;

    public Vector3D() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    public Vector3D(Vector3D vector) {
        this.x = vector.x;
        this.y = vector.y;
        this.z = vector.z;
    }

    public Vector3D(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public double getX() {
        return this.x;
    }

    public Vector3D setX(double x) {
        this.x = x;
        return this;
    }

    public double getY() {
        return this.y;
    }

    public Vector3D setY(double y) {
        this.y = y;
        return this;
    }

    public double getZ() {
        return this.z;
    }

    public Vector3D setZ(double z) {
        this.z = z;
        return this;
    }

    public Vector3D add(Vector3D vector) {
        this.x += vector.x;
        this.y += vector.y;
        this.z += vector.z;
        return this;
    }

    public Vector3D add(double x, double y, double z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public Vector3D sub(Vector3D vector) {
        this.x -= vector.x;
        this.y -= vector.y;
        this.z -= vector.z;
        return this;
    }

    public Vector3D sub(double x, double y, double z) {
        this.x -= x;
        this.y -= y;
        this.z -= z;
        return this;
    }

    public Vector3D mul(Vector3D vector) {
        this.x *= vector.x;
        this.y *= vector.y;
        this.z *= vector.z;
        return this;
    }

    public Vector3D mul(double x, double y, double z) {
        this.x *= x;
        this.y *= y;
        this.z *= z;
        return this;
    }

    public Vector3D div(Vector3D vector) {
        this.x /= vector.x;
        this.y /= vector.y;
        this.z /= vector.z;
        return this;
    }

    public Vector3D div(double x, double y, double z) {
        this.x /= x;
        this.y /= y;
        this.z /= z;
        return this;
    }

    public Vector3D scale(double n) {
        this.x *= n;
        this.y *= n;
        this.z *= n;
        return this;
    }

    public Vector3D negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public Vector3D normalize() {
        double n = 1.0 / Math.sqrt(this.x * this.x + this.y * this.y);
        this.x *= n;
        this.y *= n;
        this.z *= n;
        return this;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public double lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public double distance(Vector3D vector) {
        return Math.sqrt(Math.pow(vector.x - this.x, 2.0) + Math.pow(vector.y - this.y, 2.0) + Math.pow(vector.z - this.z, 2.0));
    }

    public double distanceSquared(Vector3D vector) {
        return Math.pow(vector.x - this.x, 2.0) + Math.pow(vector.y - this.y, 2.0) + Math.pow(vector.z - this.z, 2.0);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof Vector3D) {
            Vector3D vector = (Vector3D)other;
            return this.x == vector.x && this.y == vector.y && this.z == vector.z;
        }
        return false;
    }

    public int hashCode() {
        return DoublePrimitive.hashCode(this.x) ^ DoublePrimitive.hashCode(this.y) ^ DoublePrimitive.hashCode(this.z);
    }

    public String toString() {
        return String.format("Vector3D(%d, %d, %d)", this.x, this.y, this.z);
    }
}

