/*
 * Decompiled with CFR 0.152.
 */
package at.unbounded.mathematic.geom;

import at.unbounded.primitive.FloatPrimitive;

public class Vector3F {
    private float x;
    private float y;
    private float z;

    public Vector3F() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
    }

    public Vector3F(Vector3F vector) {
        this.x = vector.x;
        this.y = vector.y;
        this.z = vector.z;
    }

    public Vector3F(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public float getX() {
        return this.x;
    }

    public Vector3F setX(float x) {
        this.x = x;
        return this;
    }

    public float getY() {
        return this.y;
    }

    public Vector3F setY(float y) {
        this.y = y;
        return this;
    }

    public float getZ() {
        return this.z;
    }

    public Vector3F setZ(float z) {
        this.z = z;
        return this;
    }

    public Vector3F add(Vector3F vector) {
        this.x += vector.x;
        this.y += vector.y;
        this.z += vector.z;
        return this;
    }

    public Vector3F add(float x, float y, float z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public Vector3F sub(Vector3F vector) {
        this.x -= vector.x;
        this.y -= vector.y;
        this.z -= vector.z;
        return this;
    }

    public Vector3F sub(float x, float y, float z) {
        this.x -= x;
        this.y -= y;
        this.z -= z;
        return this;
    }

    public Vector3F mul(Vector3F vector) {
        this.x *= vector.x;
        this.y *= vector.y;
        this.z *= vector.z;
        return this;
    }

    public Vector3F mul(float x, float y, float z) {
        this.x *= x;
        this.y *= y;
        this.z *= z;
        return this;
    }

    public Vector3F div(Vector3F vector) {
        this.x /= vector.x;
        this.y /= vector.y;
        this.z /= vector.z;
        return this;
    }

    public Vector3F div(float x, float y, float z) {
        this.x /= x;
        this.y /= y;
        this.z /= z;
        return this;
    }

    public Vector3F scale(float n) {
        this.x *= n;
        this.y *= n;
        this.z *= n;
        return this;
    }

    public Vector3F negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public Vector3F normalize() {
        double n = 1.0 / Math.sqrt(this.x * this.x + this.y * this.y);
        this.x = (float)((double)this.x * n);
        this.y = (float)((double)this.y * n);
        this.z = (float)((double)this.z * n);
        return this;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public double lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public double distance(Vector3F vector) {
        return Math.sqrt(Math.pow(vector.x - this.x, 2.0) + Math.pow(vector.y - this.y, 2.0) + Math.pow(vector.z - this.z, 2.0));
    }

    public double distanceSquared(Vector3F vector) {
        return Math.pow(vector.x - this.x, 2.0) + Math.pow(vector.y - this.y, 2.0) + Math.pow(vector.z - this.z, 2.0);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof Vector3F) {
            Vector3F vector = (Vector3F)other;
            return this.x == vector.x && this.y == vector.y && this.z == vector.z;
        }
        return false;
    }

    public int hashCode() {
        return FloatPrimitive.hashCode(this.x) ^ FloatPrimitive.hashCode(this.y) ^ FloatPrimitive.hashCode(this.z);
    }

    public String toString() {
        return String.format("Vector3F(%d, %d, %d)", Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z));
    }
}

