/*
 * Decompiled with CFR 0.152.
 */
package at.unbounded.mathematic.geom;

import at.unbounded.primitive.IntegerPrimitive;

public class Vector3I {
    private int x;
    private int y;
    private int z;

    public Vector3I() {
        this.x = 0;
        this.y = 0;
        this.z = 0;
    }

    public Vector3I(Vector3I vector) {
        this.x = vector.x;
        this.y = vector.y;
        this.z = vector.z;
    }

    public Vector3I(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public int getX() {
        return this.x;
    }

    public Vector3I setX(int x) {
        this.x = x;
        return this;
    }

    public int getY() {
        return this.y;
    }

    public Vector3I setY(int y) {
        this.y = y;
        return this;
    }

    public int getZ() {
        return this.z;
    }

    public Vector3I setZ(int z) {
        this.z = z;
        return this;
    }

    public Vector3I add(Vector3I vector) {
        this.x += vector.x;
        this.y += vector.y;
        this.z += vector.z;
        return this;
    }

    public Vector3I add(int x, int y, int z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public Vector3I sub(Vector3I vector) {
        this.x -= vector.x;
        this.y -= vector.y;
        this.z -= vector.z;
        return this;
    }

    public Vector3I sub(int x, int y, int z) {
        this.x -= x;
        this.y -= y;
        this.z -= z;
        return this;
    }

    public Vector3I mul(Vector3I vector) {
        this.x *= vector.x;
        this.y *= vector.y;
        this.z *= vector.z;
        return this;
    }

    public Vector3I mul(int x, int y, int z) {
        this.x *= x;
        this.y *= y;
        this.z *= z;
        return this;
    }

    public Vector3I div(Vector3I vector) {
        this.x /= vector.x;
        this.y /= vector.y;
        this.z /= vector.z;
        return this;
    }

    public Vector3I div(int x, int y, int z) {
        this.x /= x;
        this.y /= y;
        this.z /= z;
        return this;
    }

    public Vector3I scale(int n) {
        this.x *= n;
        this.y *= n;
        this.z *= n;
        return this;
    }

    public Vector3I negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public Vector3I normalize() {
        double n = 1.0 / Math.sqrt(this.x * this.x + this.y * this.y);
        this.x = (int)((double)this.x * n);
        this.y = (int)((double)this.y * n);
        this.z = (int)((double)this.z * n);
        return this;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public double lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public double distance(Vector3I vector) {
        return Math.sqrt(Math.pow(vector.x - this.x, 2.0) + Math.pow(vector.y - this.y, 2.0) + Math.pow(vector.z - this.z, 2.0));
    }

    public double distanceSquared(Vector3I vector) {
        return Math.pow(vector.x - this.x, 2.0) + Math.pow(vector.y - this.y, 2.0) + Math.pow(vector.z - this.z, 2.0);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof Vector3I) {
            Vector3I vector = (Vector3I)other;
            return this.x == vector.x && this.y == vector.y && this.z == vector.z;
        }
        return false;
    }

    public int hashCode() {
        return IntegerPrimitive.hashCode(this.x) ^ IntegerPrimitive.hashCode(this.y) ^ IntegerPrimitive.hashCode(this.z);
    }

    public String toString() {
        return String.format("Vector3I(%d, %d, %d)", this.x, this.y, this.z);
    }
}

