/*
 * Decompiled with CFR 0.152.
 */
package at.unbounded.mathematic.geom;

import at.unbounded.primitive.LongPrimitive;

public class Vector3L {
    private long x;
    private long y;
    private long z;

    public Vector3L() {
        this.x = 0L;
        this.y = 0L;
        this.z = 0L;
    }

    public Vector3L(Vector3L vector) {
        this.x = vector.x;
        this.y = vector.y;
        this.z = vector.z;
    }

    public Vector3L(long x, long y, long z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public long getX() {
        return this.x;
    }

    public Vector3L setX(long x) {
        this.x = x;
        return this;
    }

    public long getY() {
        return this.y;
    }

    public Vector3L setY(long y) {
        this.y = y;
        return this;
    }

    public long getZ() {
        return this.z;
    }

    public Vector3L setZ(long z) {
        this.z = z;
        return this;
    }

    public Vector3L add(Vector3L vector) {
        this.x += vector.x;
        this.y += vector.y;
        this.z += vector.z;
        return this;
    }

    public Vector3L add(long x, long y, long z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public Vector3L sub(Vector3L vector) {
        this.x -= vector.x;
        this.y -= vector.y;
        this.z -= vector.z;
        return this;
    }

    public Vector3L sub(long x, long y, long z) {
        this.x -= x;
        this.y -= y;
        this.z -= z;
        return this;
    }

    public Vector3L mul(Vector3L vector) {
        this.x *= vector.x;
        this.y *= vector.y;
        this.z *= vector.z;
        return this;
    }

    public Vector3L mul(long x, long y, long z) {
        this.x *= x;
        this.y *= y;
        this.z *= z;
        return this;
    }

    public Vector3L div(Vector3L vector) {
        this.x /= vector.x;
        this.y /= vector.y;
        this.z /= vector.z;
        return this;
    }

    public Vector3L div(long x, long y, long z) {
        this.x /= x;
        this.y /= y;
        this.z /= z;
        return this;
    }

    public Vector3L scale(long n) {
        this.x *= n;
        this.y *= n;
        this.z *= n;
        return this;
    }

    public Vector3L negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public Vector3L normalize() {
        double n = 1.0 / Math.sqrt(this.x * this.x + this.y * this.y);
        this.x = (long)((double)this.x * n);
        this.y = (long)((double)this.y * n);
        this.z = (long)((double)this.z * n);
        return this;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public double lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public double distance(Vector3L vector) {
        return Math.sqrt(Math.pow(vector.x - this.x, 2.0) + Math.pow(vector.y - this.y, 2.0) + Math.pow(vector.z - this.z, 2.0));
    }

    public double distanceSquared(Vector3L vector) {
        return Math.pow(vector.x - this.x, 2.0) + Math.pow(vector.y - this.y, 2.0) + Math.pow(vector.z - this.z, 2.0);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof Vector3L) {
            Vector3L vector = (Vector3L)other;
            return this.x == vector.x && this.y == vector.y && this.z == vector.z;
        }
        return false;
    }

    public int hashCode() {
        return LongPrimitive.hashCode(this.x) ^ LongPrimitive.hashCode(this.y) ^ LongPrimitive.hashCode(this.z);
    }

    public String toString() {
        return String.format("Vector3L(%d, %d, %d)", this.x, this.y, this.z);
    }
}

