/*
 * Decompiled with CFR 0.152.
 */
package at.unbounded.mathematic.interpolation;

import at.unbounded.mathematic.Mathematic;
import at.unbounded.mathematic.geom.Vector3D;
import at.unbounded.mathematic.interpolation.Interpolation;
import java.util.List;

public final class KochanekBartelsInterpolation
implements Interpolation {
    private final Vector3D[] coeffPrimus;
    private final Vector3D[] coeffSecundus;
    private final Vector3D[] coeffTertius;
    private final Vector3D[] coeffQuartus;
    private final double scaling;

    public KochanekBartelsInterpolation(List<Interpolation.Node> nodes) {
        this.coeffPrimus = new Vector3D[nodes.size()];
        this.coeffSecundus = new Vector3D[nodes.size()];
        this.coeffTertius = new Vector3D[nodes.size()];
        this.coeffQuartus = new Vector3D[nodes.size()];
        if (nodes.size() != 0) {
            Interpolation.Node node = nodes.get(0);
            double nextTension = node.getTension();
            double nextBias = node.getBias();
            double nextContinuity = node.getContinuity();
            for (int i = 0; i < nodes.size(); ++i) {
                double tension = nextTension;
                double bias = nextBias;
                double continuity = nextContinuity;
                if (i + 1 < nodes.size()) {
                    node = nodes.get(i + 1);
                    nextTension = node.getTension();
                    nextBias = node.getBias();
                    nextContinuity = node.getContinuity();
                }
                double tangentsPrimus = (1.0 - tension) * (1.0 + bias) * (1.0 + continuity) / 2.0;
                double tangentsSecundus = (1.0 - tension) * (1.0 - bias) * (1.0 - continuity) / 2.0;
                double tangentsTertius = (1.0 - nextTension) * (1.0 + nextBias) * (1.0 - nextContinuity) / 2.0;
                double tangentsQuartus = (1.0 - nextTension) * (1.0 - nextBias) * (1.0 + nextContinuity) / 2.0;
                this.coeffPrimus[i] = this.linearCombination(nodes, i, -tangentsPrimus, tangentsPrimus - tangentsSecundus - tangentsTertius + 2.0, tangentsSecundus + tangentsTertius - tangentsQuartus - 2.0, tangentsQuartus);
                this.coeffSecundus[i] = this.linearCombination(nodes, i, 2.0 * tangentsPrimus, -2.0 * tangentsPrimus + 2.0 * tangentsSecundus + tangentsTertius - 3.0, -2.0 * tangentsSecundus - tangentsTertius + tangentsQuartus + 3.0, -tangentsQuartus);
                this.coeffTertius[i] = this.linearCombination(nodes, i, -tangentsPrimus, tangentsPrimus - tangentsSecundus, tangentsTertius, 0.0);
                this.coeffQuartus[i] = i < 0 ? nodes.get(0).getPosition() : (i >= nodes.size() ? nodes.get(nodes.size() - 1).getPosition() : nodes.get(i).getPosition());
            }
        }
        this.scaling = nodes.size() - 1;
    }

    @Override
    public Vector3D getPosition(double position) {
        if (position > 1.0) {
            return null;
        }
        int index = Mathematic.floor(position *= this.scaling);
        double remainder = position - (double)index;
        Vector3D primus = this.coeffPrimus[index];
        Vector3D secundus = this.coeffSecundus[index];
        Vector3D tertius = this.coeffTertius[index];
        Vector3D quartus = this.coeffQuartus[index];
        return primus.scale(remainder).add(secundus).scale(remainder).add(tertius).scale(remainder).add(quartus);
    }

    @Override
    public Vector3D get1stDerivaive(double position) {
        if (position > 1.0) {
            return null;
        }
        int index = Mathematic.floor(position *= this.scaling);
        Vector3D primus = this.coeffPrimus[index];
        Vector3D secundus = this.coeffSecundus[index];
        Vector3D tertius = this.coeffTertius[index];
        return primus.scale(1.5 * position - 3.0 * (double)index).add(secundus).scale(2.0 * position).add(primus.scale(1.5 * (double)index).sub(secundus).scale(2.0 * (double)index)).add(tertius).scale(this.scaling);
    }

    @Override
    public double arcusLength(double positionA, double positionB) {
        if (positionA > positionB) {
            double swap = positionA;
            positionA = positionB;
            positionB = swap;
        }
        int indexA = Mathematic.floor(positionA *= this.scaling);
        double remainderA = positionA - (double)indexA;
        int indexB = Mathematic.floor(positionB *= this.scaling);
        double remainderB = positionB - (double)indexB;
        return this.arcusLengthRecursive(indexA, remainderA, indexB, remainderB);
    }

    private double arcusLengthRecursive(int indexA, double remainderA, int indexB, double remainderB) {
        switch (indexB - indexA) {
            case 0: {
                return this.arcusLengthRecursive(indexA, remainderA, remainderB);
            }
            case 1: {
                return this.arcusLengthRecursive(indexA, remainderA, 1.0) + this.arcusLengthRecursive(indexB, 0.0, remainderB);
            }
        }
        return this.arcusLengthRecursive(indexA, remainderA, indexB - 1, 1.0) + this.arcusLengthRecursive(indexB, 0.0, remainderB);
    }

    private double arcusLengthRecursive(int index, double remainderA, double remainderB) {
        Vector3D primus = this.coeffPrimus[index].scale(3.0);
        Vector3D secundus = this.coeffSecundus[index].scale(2.0);
        Vector3D tertius = this.coeffTertius[index];
        double accumulator = primus.scale(remainderA).add(secundus).scale(remainderA).add(tertius).length() / 2.0;
        for (int i = 1; i < 7; ++i) {
            double t = (remainderB - remainderA) * (double)i / 8.0 + remainderA;
            accumulator += primus.scale(t).add(secundus).scale(t).add(tertius).length();
        }
        return accumulator * (remainderB - remainderA) / 8.0;
    }

    public Vector3D linearCombination(List<Interpolation.Node> nodes, int base, double alpha, double beta, double gamma, double delta) {
        int virtual = base - 1;
        Vector3D primus = virtual < 0 ? nodes.get(0).getPosition() : (virtual >= nodes.size() ? nodes.get(nodes.size() - 1).getPosition() : nodes.get(virtual).getPosition());
        virtual = base;
        Vector3D secundus = virtual < 0 ? nodes.get(0).getPosition() : (virtual >= nodes.size() ? nodes.get(nodes.size() - 1).getPosition() : nodes.get(virtual).getPosition());
        virtual = base + 1;
        Vector3D tertius = virtual < 0 ? nodes.get(0).getPosition() : (virtual >= nodes.size() ? nodes.get(nodes.size() - 1).getPosition() : nodes.get(virtual).getPosition());
        virtual = base + 2;
        Vector3D quartus = virtual < 0 ? nodes.get(0).getPosition() : (virtual >= nodes.size() ? nodes.get(nodes.size() - 1).getPosition() : nodes.get(virtual).getPosition());
        return primus.scale(alpha).add(secundus.scale(beta)).add(tertius.scale(gamma)).add(quartus.scale(delta));
    }
}

