/*
 * Decompiled with CFR 0.152.
 */
package at.unbounded.mathematic.interpolation;

import at.unbounded.mathematic.Mathematic;
import at.unbounded.mathematic.geom.Vector3D;
import at.unbounded.mathematic.interpolation.Interpolation;
import java.util.List;

public final class LinearInterpolation
implements Interpolation {
    private final List<Interpolation.Node> nodes;
    private final double scaling;

    public LinearInterpolation(List<Interpolation.Node> nodes) {
        this.nodes = nodes;
        this.scaling = nodes.size() - 1;
    }

    @Override
    public Vector3D getPosition(double position) {
        if (position > 1.0) {
            return null;
        }
        int index = Mathematic.floor(position *= this.scaling);
        double remainder = position - (double)index;
        Vector3D positionBegin = this.nodes.get(index).getPosition();
        Vector3D positionEnd = this.nodes.get(index + 1).getPosition();
        return positionBegin.scale(1.0 - remainder).add(positionEnd.scale(remainder));
    }

    @Override
    public Vector3D get1stDerivaive(double position) {
        if (position > 1.0) {
            return null;
        }
        int index = Mathematic.floor(position *= this.scaling);
        Vector3D positionBegin = this.nodes.get(index).getPosition();
        Vector3D positionEnd = this.nodes.get(index + 1).getPosition();
        return positionEnd.sub(positionBegin);
    }

    @Override
    public double arcusLength(double positionA, double positionB) {
        if (positionA > positionB) {
            double swap = positionA;
            positionA = positionB;
            positionB = swap;
        }
        int indexA = Mathematic.floor(positionA *= this.scaling);
        double remainderA = positionA - (double)indexA;
        int indexB = Mathematic.floor(positionB *= this.scaling);
        double remainderB = positionB - (double)indexB;
        return this.arcusLengthRecursive(indexA, remainderA, indexB, remainderB);
    }

    private double arcusLengthRecursive(int indexA, double remainderA, int indexB, double remainderB) {
        switch (indexB - indexA) {
            case 0: {
                return this.arcusLengthRecursive(indexA, remainderA, remainderB);
            }
            case 1: {
                return this.arcusLengthRecursive(indexA, remainderA, 1.0) + this.arcusLengthRecursive(indexB, 0.0, remainderB);
            }
        }
        return this.arcusLengthRecursive(indexA, remainderA, indexB - 1, 1.0) + this.arcusLengthRecursive(indexB, 0.0, remainderB);
    }

    private double arcusLengthRecursive(int index, double remainderA, double remainderB) {
        Vector3D positionBegin = this.nodes.get(index).getPosition();
        Vector3D positionEnd = this.nodes.get(index + 1).getPosition();
        return positionBegin.distance(positionEnd) * (remainderB - remainderA);
    }
}

