/*
 * Decompiled with CFR 0.152.
 */
package at.unbounded.mathematic.noise;

import at.unbounded.mathematic.geom.Vector2D;
import at.unbounded.mathematic.geom.Vector3D;
import at.unbounded.mathematic.noise.Noise;
import at.unbounded.mathematic.noise.WhiteNoise;

public final class BrownianNoise
implements Noise {
    private final WhiteNoise noise;
    private double lacunarity = 2.1379201;
    private double persistence = 0.836281;
    private double[] octaves;
    private double scale;

    public BrownianNoise(long seed) {
        this.noise = new WhiteNoise(seed);
        this.octaves = new double[9];
        for (int i = 0; i < 9; ++i) {
            this.octaves[i] = Math.pow(this.lacunarity, -this.persistence * (double)i);
        }
        double total = 0.0;
        for (double octave : this.octaves) {
            total += octave;
        }
        this.scale = 1.0 / total;
    }

    public double getLacunarity() {
        return this.lacunarity;
    }

    public void setLacunarity(double lacunarity) {
        this.lacunarity = lacunarity;
        for (int i = 0; i < this.octaves.length; ++i) {
            this.octaves[i] = Math.pow(lacunarity, -this.persistence * (double)i);
        }
        double total = 0.0;
        for (double octave : this.octaves) {
            total += octave;
        }
        this.scale = 1.0 / total;
    }

    public double getPersistence() {
        return this.persistence;
    }

    public void setPersistence(double persistence) {
        this.persistence = persistence;
        for (int i = 0; i < this.octaves.length; ++i) {
            this.octaves[i] = Math.pow(this.lacunarity, -persistence * (double)i);
        }
        double total = 0.0;
        for (double octave : this.octaves) {
            total += octave;
        }
        this.scale = 1.0 / total;
    }

    public int getOctaves() {
        return this.octaves.length;
    }

    public void setOctaves(int octaves) {
        this.octaves = new double[octaves];
        for (int i = 0; i < octaves; ++i) {
            this.octaves[i] = Math.pow(this.lacunarity, -this.persistence * (double)i);
        }
        double total = 0.0;
        for (double octave : this.octaves) {
            total += octave;
        }
        this.scale = 1.0 / total;
    }

    @Override
    public double noise(Vector2D vector) {
        double result = 0.0;
        for (int i = 0; i < this.octaves.length; ++i) {
            result += this.noise.noise(vector) * this.octaves[i];
            vector.scale(this.lacunarity);
        }
        return result * this.scale;
    }

    @Override
    public double noise(Vector3D vector) {
        double result = 0.0;
        for (int i = 0; i < this.octaves.length; ++i) {
            result += this.noise.noise(vector) * this.octaves[i];
            vector.scale(this.lacunarity);
        }
        return result * this.scale;
    }
}

