/*
 * Decompiled with CFR 0.152.
 */
package at.unbounded.mathematic.noise;

import at.unbounded.mathematic.geom.Vector2D;
import at.unbounded.mathematic.geom.Vector3D;
import at.unbounded.mathematic.noise.Noise;

public final class WhiteNoise
implements Noise {
    private final long seed;

    public WhiteNoise(long seed) {
        this.seed = seed;
    }

    @Override
    public double noise(Vector2D vector) {
        long stage1 = this.seed ^ Double.doubleToLongBits(vector.getX());
        stage1 = stage1 ^ 0x3DL ^ stage1 >>> 16;
        stage1 += stage1 << 3;
        stage1 ^= stage1 >>> 4;
        stage1 *= 668265261L;
        stage1 ^= stage1 >>> 15;
        long stage2 = this.seed ^ stage1 + Double.doubleToLongBits(vector.getY());
        stage2 = stage2 ^ 0x3DL ^ stage2 >>> 16;
        stage2 += stage2 << 3;
        stage2 ^= stage2 >>> 4;
        stage2 *= 668265261L;
        stage2 ^= stage2 >>> 15;
        return stage2 / Long.MAX_VALUE;
    }

    @Override
    public double noise(Vector3D vector) {
        long stage1 = this.seed ^ Double.doubleToLongBits(vector.getX());
        stage1 = stage1 ^ 0x3DL ^ stage1 >>> 16;
        stage1 += stage1 << 3;
        stage1 ^= stage1 >>> 4;
        stage1 *= 668265261L;
        stage1 ^= stage1 >>> 15;
        long stage2 = this.seed ^ stage1 + Double.doubleToLongBits(vector.getY());
        stage2 = stage2 ^ 0x3DL ^ stage2 >>> 16;
        stage2 += stage2 << 3;
        stage2 ^= stage2 >>> 4;
        stage2 *= 668265261L;
        stage2 ^= stage2 >>> 15;
        long stage3 = this.seed ^ stage2 + Double.doubleToLongBits(vector.getZ());
        stage3 = stage3 ^ 0x3DL ^ stage3 >>> 16;
        stage3 += stage3 << 3;
        stage3 ^= stage3 >>> 4;
        stage3 *= 668265261L;
        stage3 ^= stage3 >>> 15;
        return stage3 / Long.MAX_VALUE;
    }
}

