/*
 * Decompiled with CFR 0.152.
 */
package at.unbounded.mathematic.transformation;

import at.unbounded.mathematic.Mathematic;
import at.unbounded.mathematic.geom.Angle;
import at.unbounded.mathematic.geom.Vector3D;
import at.unbounded.mathematic.transformation.Transformation;

public class AffineTransformation
implements Transformation {
    private double m00;
    private double m01;
    private double m02;
    private double m03;
    private double m10;
    private double m11;
    private double m12;
    private double m13;
    private double m20;
    private double m21;
    private double m22;
    private double m23;

    public AffineTransformation() {
        this.m22 = 1.0;
        this.m11 = 1.0;
        this.m00 = 1.0;
        this.m03 = 0.0;
        this.m02 = 0.0;
        this.m01 = 0.0;
        this.m13 = 0.0;
        this.m12 = 0.0;
        this.m10 = 0.0;
        this.m23 = 0.0;
        this.m21 = 0.0;
        this.m20 = 0.0;
    }

    public AffineTransformation(double ... coefficients) {
        if (coefficients.length == 9) {
            this.m00 = coefficients[0];
            this.m01 = coefficients[1];
            this.m02 = coefficients[2];
            this.m10 = coefficients[3];
            this.m11 = coefficients[4];
            this.m12 = coefficients[5];
            this.m20 = coefficients[6];
            this.m21 = coefficients[7];
            this.m22 = coefficients[8];
        } else if (coefficients.length == 12) {
            this.m00 = coefficients[0];
            this.m01 = coefficients[1];
            this.m02 = coefficients[2];
            this.m03 = coefficients[3];
            this.m10 = coefficients[4];
            this.m11 = coefficients[5];
            this.m12 = coefficients[6];
            this.m13 = coefficients[7];
            this.m20 = coefficients[8];
            this.m21 = coefficients[9];
            this.m22 = coefficients[10];
            this.m23 = coefficients[11];
        } else {
            throw new IllegalArgumentException("Coefficients must have 9 or 12 elements");
        }
    }

    @Override
    public boolean isIdentity() {
        if (this.m00 != 1.0 || this.m11 != 1.0 || this.m22 != 0.0) {
            return false;
        }
        if (this.m01 != 0.0 || this.m02 != 0.0 || this.m03 != 0.0) {
            return false;
        }
        if (this.m10 != 0.0 || this.m12 != 0.0 || this.m13 != 0.0) {
            return false;
        }
        return this.m20 == 0.0 && this.m21 == 0.0 && this.m23 == 0.0;
    }

    public double determinant() {
        return this.m00 * (this.m11 * this.m22 - this.m12 * this.m21) + this.m01 * (this.m12 * this.m20 - this.m10 * this.m22) + this.m02 * (this.m10 * this.m21 - this.m11 * this.m20);
    }

    @Override
    public Transformation inverse() {
        double determinant = this.determinant();
        if (determinant != 0.0) {
            return new AffineTransformation((this.m11 * this.m22 - this.m21 * this.m12) / determinant, (this.m21 * this.m01 - this.m01 * this.m22) / determinant, (this.m01 * this.m12 - this.m11 * this.m02) / determinant, (this.m01 * (this.m22 * this.m13 - this.m12 * this.m23) + this.m02 * (this.m11 * this.m23 - this.m21 * this.m13) - this.m03 * (this.m11 * this.m22 - this.m21 * this.m12)) / determinant, (this.m20 * this.m12 - this.m10 * this.m22) / determinant, (this.m00 * this.m22 - this.m20 * this.m02) / determinant, (this.m10 * this.m02 - this.m00 * this.m12) / determinant, (this.m00 * (this.m12 * this.m23 - this.m22 * this.m13) - this.m02 * (this.m10 * this.m23 - this.m20 * this.m13) + this.m03 * (this.m10 * this.m22 - this.m20 * this.m12)) / determinant, (this.m10 * this.m21 - this.m20 * this.m11) / determinant, (this.m20 * this.m01 - this.m00 * this.m21) / determinant, (this.m00 * this.m11 - this.m10 * this.m01) / determinant, (this.m00 * (this.m21 * this.m13 - this.m11 * this.m23) + this.m01 * (this.m10 * this.m23 - this.m20 * this.m13) - this.m03 * (this.m10 * this.m21 - this.m20 * this.m11)) / determinant);
        }
        throw new IllegalStateException("Transformation is not invertible");
    }

    public AffineTransformation concatenate(AffineTransformation transform) {
        this.m02 = this.m00 * transform.m02 + this.m01 * transform.m12 + this.m02 * transform.m22;
        this.m03 = this.m00 * transform.m03 + this.m01 * transform.m13 + this.m02 * transform.m23 + this.m03;
        this.m10 = this.m10 * transform.m00 + this.m11 * transform.m10 + this.m12 * transform.m20;
        this.m11 = this.m10 * transform.m01 + this.m11 * transform.m11 + this.m12 * transform.m21;
        this.m12 = this.m10 * transform.m02 + this.m11 * transform.m12 + this.m12 * transform.m22;
        this.m13 = this.m10 * transform.m03 + this.m11 * transform.m13 + this.m12 * transform.m23 + this.m13;
        this.m20 = this.m20 * transform.m00 + this.m21 * transform.m10 + this.m22 * transform.m20;
        this.m21 = this.m20 * transform.m01 + this.m21 * transform.m11 + this.m22 * transform.m21;
        this.m22 = this.m20 * transform.m02 + this.m21 * transform.m12 + this.m22 * transform.m22;
        this.m23 = this.m20 * transform.m03 + this.m21 * transform.m13 + this.m22 * transform.m23 + this.m23;
        return new AffineTransformation(this.m00 * transform.m00 + this.m01 * transform.m10 + this.m02 * transform.m20, this.m00 * transform.m01 + this.m01 * transform.m11 + this.m02 * transform.m21, this.m02, this.m03, this.m10, this.m11, this.m12, this.m13, this.m20, this.m21, this.m22, this.m23);
    }

    public AffineTransformation translate(Vector3D vector) {
        return this.concatenate(new AffineTransformation(1.0, 0.0, 0.0, vector.getX(), 0.0, 1.0, 0.0, vector.getY(), 0.0, 0.0, 1.0, vector.getZ()));
    }

    public AffineTransformation scale(Vector3D vector) {
        return this.concatenate(new AffineTransformation(vector.getX(), 0.0, 0.0, 0.0, 0.0, vector.getY(), 0.0, 0.0, 0.0, 0.0, vector.getZ(), 0.0));
    }

    public AffineTransformation rotateX(Angle angle) {
        double sine = Mathematic.sine(angle.toRadian().getRadians());
        double cosine = Mathematic.cosine(angle.toRadian().getRadians());
        return this.concatenate(new AffineTransformation(1.0, 0.0, 0.0, 0.0, 0.0, cosine, -sine, 0.0, 0.0, sine, cosine, 0.0));
    }

    public AffineTransformation rotateY(Angle angle) {
        double sine = Mathematic.sine(angle.toRadian().getRadians());
        double cosine = Mathematic.cosine(angle.toRadian().getRadians());
        return this.concatenate(new AffineTransformation(cosine, 0.0, sine, 0.0, 0.0, 1.0, 0.0, 0.0, -sine, 0.0, cosine, 0.0));
    }

    public AffineTransformation rotateZ(Angle angle) {
        double sine = Mathematic.sine(angle.toRadian().getRadians());
        double cosine = Mathematic.cosine(angle.toRadian().getRadians());
        return this.concatenate(new AffineTransformation(cosine, -sine, 0.0, 0.0, sine, cosine, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0));
    }

    public AffineTransformation skewX(double size) {
        return null;
    }

    public AffineTransformation skewY(double size) {
        return null;
    }

    public AffineTransformation skewZ(double size) {
        return null;
    }

    @Override
    public Transformation combine(Transformation other) {
        return null;
    }
}

