/*
 * Decompiled with CFR 0.152.
 */
package at.unbounded.mathematic.transformation;

import at.unbounded.mathematic.transformation.Transformation;

public class CombinedTransformation
implements Transformation {
    private final Transformation[] transforms;

    public CombinedTransformation(Transformation ... transforms) {
        this.transforms = transforms;
    }

    @Override
    public boolean isIdentity() {
        for (Transformation transform : this.transforms) {
            if (transform.isIdentity()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Transformation inverse() {
        Transformation[] inverse = new Transformation[this.transforms.length];
        for (int i = 0; i < this.transforms.length; ++i) {
            inverse[i] = this.transforms[i].inverse();
        }
        return new CombinedTransformation(inverse);
    }

    @Override
    public Transformation combine(Transformation other) {
        if (other instanceof CombinedTransformation) {
            CombinedTransformation combination = (CombinedTransformation)other;
            Transformation[] combinationTransforms = new Transformation[this.transforms.length + combination.transforms.length];
            System.arraycopy(this.transforms, 0, combinationTransforms, 0, this.transforms.length);
            System.arraycopy(combination.transforms, 0, combinationTransforms, this.transforms.length, combination.transforms.length);
            return new CombinedTransformation(combinationTransforms);
        }
        return new CombinedTransformation(this, other);
    }
}

