/*
 * Decompiled with CFR 0.152.
 */
package at.unbounded.reflection;

import at.unbounded.reflection.ClassMatcher;

public class ClassExactMatcher
extends ClassMatcher {
    private final Class<?> clazz;
    private final Option option;

    public ClassExactMatcher(Class<?> matcher, Option option) {
        this.clazz = matcher;
        this.option = option;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public Option getOption() {
        return this.option;
    }

    @Override
    public boolean match(Class<?> other) {
        if (this.clazz == null) {
            return this.option != Option.MATCH_EXACT;
        }
        if (this.option.equals((Object)Option.MATCH_SUPER)) {
            return other.isAssignableFrom(this.clazz);
        }
        if (this.option.equals((Object)Option.MATCH_DERIVED)) {
            return this.clazz.isAssignableFrom(other);
        }
        return this.clazz.equals(other);
    }

    @Override
    protected int weight() {
        return -ClassExactMatcher.getSuperclasses(this.clazz);
    }

    public static enum Option {
        MATCH_EXACT,
        MATCH_SUPER,
        MATCH_DERIVED;

    }
}

