/*
 * Decompiled with CFR 0.152.
 */
package at.unbounded.reflection;

public abstract class ClassMatcher
implements Comparable<ClassMatcher> {
    public abstract boolean match(Class<?> var1);

    protected abstract int weight();

    @Override
    public int compareTo(ClassMatcher o) {
        if (o instanceof ClassMatcher) {
            return Integer.compare(this.weight(), o.weight());
        }
        return -1;
    }

    public ClassMatcher not() {
        return new ClassMatcher(){

            @Override
            public boolean match(Class<?> clazz) {
                return !ClassMatcher.this.match(clazz);
            }

            @Override
            protected int weight() {
                return -2;
            }
        };
    }

    public ClassMatcher and(final ClassMatcher other) {
        return new ClassMatcher(){

            @Override
            public boolean match(Class<?> clazz) {
                return ClassMatcher.this.match(clazz) && other.match(clazz);
            }

            @Override
            protected int weight() {
                return Math.max(ClassMatcher.this.weight(), other.weight());
            }
        };
    }

    public ClassMatcher or(final ClassMatcher other) {
        return new ClassMatcher(){

            @Override
            public boolean match(Class<?> clazz) {
                return ClassMatcher.this.match(clazz) || other.match(clazz);
            }

            @Override
            protected int weight() {
                return Math.max(ClassMatcher.this.weight(), other.weight());
            }
        };
    }

    public static int getSuperclasses(Class<?> clazz) {
        int count = 0;
        while (clazz != null) {
            ++count;
            clazz = clazz.getSuperclass();
        }
        return count;
    }
}

