/*
 * Decompiled with CFR 0.152.
 */
package at.unbounded.reflection;

import at.unbounded.reflection.ConstructorAccessor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class DefaultConstructorAccessor
implements ConstructorAccessor {
    private final Constructor<?> constructor;

    public DefaultConstructorAccessor(Constructor<?> constructor) {
        this.constructor = constructor;
    }

    @Override
    public Constructor<?> getConstructor() {
        return this.constructor;
    }

    @Override
    public Object invoke(Object ... arguments) {
        try {
            return this.constructor.newInstance(arguments);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException("Cannot instantiate object", ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException("Cannot invoke the constructor", ex);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Cannot be reflected.", ex);
        }
    }
}

