/*
 * Decompiled with CFR 0.152.
 */
package at.unbounded.reflection;

import at.unbounded.reflection.FieldAccessor;
import java.lang.reflect.Field;

public class DefaultFieldAccessor
implements FieldAccessor {
    private final Field field;

    public DefaultFieldAccessor(Field field) {
        this.field = field;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public Object get(Object instance) {
        try {
            return this.field.get(instance);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException("Cannot read  " + this.field, ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Cannot be reflected.", ex);
        }
    }

    @Override
    public void set(Object instance, Object value) {
        try {
            this.field.set(instance, value);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException("Cannot set field " + this.field + " to value " + value, ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Cannot be reflected.", ex);
        }
    }
}

